/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.workcalendar;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.util.DateUtils;

public class WorkCalendarSetEdit
extends AbstractFormPlugin
implements IConfirmCallBack {
    public final SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");

    public void initialize() {
        super.initialize();
        this.initProperty();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Map set = (Map)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("set")), Map.class);
        this.addSetToData(set);
        Calendar cal = Calendar.getInstance();
        this.getModel().setValue("expireyearfrom", (Object)cal.get(1));
        this.getModel().setValue("expiremonthfrom", (Object)(cal.get(2) + 1));
    }

    private void addSetToData(Map set) {
        this.getModel().setValue("issunrest", set.get("issunrest"));
        this.getModel().setValue("ismonrest", set.get("ismonrest"));
        this.getModel().setValue("istuerest", set.get("istuerest"));
        this.getModel().setValue("iswedrest", set.get("iswedrest"));
        this.getModel().setValue("isthurest", set.get("isthurest"));
        this.getModel().setValue("isfrirest", set.get("isfrirest"));
        this.getModel().setValue("issatrest", set.get("issatrest"));
        this.getModel().setValue("ishalfsunrest", set.get("ishalfsunrest"));
        this.getModel().setValue("ishalfmonrest", set.get("ishalfmonrest"));
        this.getModel().setValue("ishalftuerest", set.get("ishalftuerest"));
        this.getModel().setValue("ishalfwedrest", set.get("ishalfwedrest"));
        this.getModel().setValue("ishalfthurest", set.get("ishalfthurest"));
        this.getModel().setValue("ishalffrirest", set.get("ishalffrirest"));
        this.getModel().setValue("ishalfsatrest", set.get("ishalfsatrest"));
        this.getModel().setValue("hourofbegintimeam", set.get("hourofbegintimeam"));
        this.getModel().setValue("minofbegintimeam", set.get("minofbegintimeam"));
        this.getModel().setValue("hourofendtimeam", set.get("hourofendtimeam"));
        this.getModel().setValue("minofendtimeam", set.get("minofendtimeam"));
        this.getModel().setValue("hourofbegintimepm", set.get("hourofbegintimepm"));
        this.getModel().setValue("minofbegintimepm", set.get("minofbegintimepm"));
        this.getModel().setValue("hourofendtimepm", set.get("hourofendtimepm"));
        this.getModel().setValue("minofendtimepm", set.get("minofendtimepm"));
        this.getModel().setValue("expireyearfrom", set.get("expireyearfrom"));
        this.getModel().setValue("expiremonthfrom", set.get("expiremonthfrom"));
        this.getModel().setValue("expireyearto", set.get("expireyearto"));
        this.getModel().setValue("expiremonthto", set.get("expiremonthto"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op;
        Object source = args.getSource();
        if (source instanceof AbstractOperate && "ok".equalsIgnoreCase((op = (AbstractOperate)source).getOperateKey())) {
            if (!this.getModel().getDataChanged()) {
                this.getView().close();
                return;
            }
            if (this.validate()) {
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                this.getModel().setDataChanged(false);
                this.getView().close();
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
    }

    private boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        if (!this.amTimeValidate()) {
            return false;
        }
        if (!this.pmTimeValidate()) {
            return false;
        }
        return this.expireDateValidate();
    }

    private boolean amTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (!(this.nullToZero(obj, "hourofbegintimeam") || this.nullToZero(obj, "minofbegintimeam") || this.nullToZero(obj, "hourofendtimeam") || this.nullToZero(obj, "minofendtimeam"))) {
            result = DateUtils.compareHourAndMinute((int)obj.getInt("hourofbegintimeam"), (int)obj.getInt("minofbegintimeam"), (int)obj.getInt("hourofendtimeam"), (int)obj.getInt("minofendtimeam"));
            if (!result) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"WorkCalendarSetEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            return result;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165\u3002", (String)"WorkCalendarSetEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        return result;
    }

    private boolean nullToZero(DynamicObject obj, String propertyName) {
        Object property = obj.get(propertyName);
        if (property != null && property.toString().length() != 0) {
            return false;
        }
        obj.set(propertyName, (Object)0);
        return true;
    }

    private boolean dateExclusionValidate() {
        boolean[] isHalfWorkDay;
        boolean result = true;
        boolean[] isRestDay = WorkCalendarSetEdit.getRestDays(this.getModel().getDataEntity());
        if (isRestDay.length != (isHalfWorkDay = WorkCalendarSetEdit.getHalfWorkDays(this.getModel().getDataEntity())).length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (!isRestDay[i] || !isHalfWorkDay[i]) continue;
            result = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"WorkCalendarSetEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean pmTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (!(this.nullToZero(obj, "hourofbegintimepm") || this.nullToZero(obj, "minofbegintimepm") || this.nullToZero(obj, "hourofendtimepm") || this.nullToZero(obj, "minofendtimepm"))) {
            result = DateUtils.compareHourAndMinute((int)obj.getInt("hourofbegintimepm"), (int)obj.getInt("minofbegintimepm"), (int)obj.getInt("hourofendtimepm"), (int)obj.getInt("minofendtimepm"));
            if (!result) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"WorkCalendarSetEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            return result;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165\u3002", (String)"WorkCalendarSetEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        return result;
    }

    private boolean expireDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get("expireyearfrom") != null && obj.get("expiremonthfrom") != null && obj.get("expireyearto") != null && obj.get("expiremonthto") != null) {
            int yearFrom = obj.getInt("expireyearfrom");
            int monthFrom = obj.getInt("expiremonthfrom");
            int yearTo = obj.getInt("expireyearto");
            int monthTo = obj.getInt("expiremonthto");
            if (yearTo >= yearFrom && (yearTo != yearFrom || monthTo >= monthFrom)) {
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkCalendarSetEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkCalendarSetEdit_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        return false;
    }

    private DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    private void initProperty() {
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        this.genYearComboItems("expireyearfrom", currentYear);
        this.genYearComboItems("expireyearto", currentYear);
    }

    private void genYearComboItems(String propertyName, int currentYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(100);
        for (int i = 0; i < 100; ++i) {
            String year = String.valueOf(currentYear + i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public static boolean[] getRestDays(DynamicObject workCalendar) {
        return new boolean[]{workCalendar.getBoolean("issunrest"), workCalendar.getBoolean("ismonrest"), workCalendar.getBoolean("istuerest"), workCalendar.getBoolean("iswedrest"), workCalendar.getBoolean("isthurest"), workCalendar.getBoolean("isfrirest"), workCalendar.getBoolean("issatrest")};
    }

    public static boolean[] getHalfWorkDays(DynamicObject workCalendar) {
        return new boolean[]{workCalendar.getBoolean("ishalfsunrest"), workCalendar.getBoolean("ishalfmonrest"), workCalendar.getBoolean("ishalftuerest"), workCalendar.getBoolean("ishalfwedrest"), workCalendar.getBoolean("ishalfthurest"), workCalendar.getBoolean("ishalffrirest"), workCalendar.getBoolean("ishalfsatrest")};
    }
}

