/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.opplugin.foreignmarketrate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.property.LendingMarketRateProp;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class ForeignMarketRateImportOp
extends AbstractTmcBatchImportPlugin {
    private static final String SYSTEM_ID = "tmc-fbd-opplugin";
    private static final Map<String, String> NECESSARY_KEY_FIELDS = new HashMap<String, String>(){
        {
            this.put("releasedate", ResManager.loadKDString((String)"\u53d1\u5e03\u65e5\u671f", (String)"ForeignMarketRateImportOp_3", (String)ForeignMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("originalcurrency.name", ResManager.loadKDString((String)"\u539f\u5e01", (String)"ForeignMarketRateImportOp_4", (String)ForeignMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("targetcurrency.name", ResManager.loadKDString((String)"\u76ee\u6807\u5e01", (String)"ForeignMarketRateImportOp_5", (String)ForeignMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("deadlinename", ResManager.loadKDString((String)"\u671f\u9650\u7c7b\u522b", (String)"ForeignMarketRateImportOp_6", (String)ForeignMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("targetcurrencyamount", ResManager.loadKDString((String)"\u76ee\u6807\u8d27\u5e01\u6570\u91cf", (String)"ForeignMarketRateImportOp_7", (String)ForeignMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("ratesources.name", ResManager.loadKDString((String)"\u724c\u4ef7\u6765\u6e90", (String)"ForeignMarketRateImportOp_8", (String)ForeignMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
        }
    };

    protected void beforeImportOp(Map<String, Object> rowdata, Map<String, Object> option) throws ParseException {
        String importType = this.getCurrentImportType();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date publishDate = simpleDateFormat.parse((String)rowdata.get("releasedate"));
        String targetCurrencyAmount = (String)rowdata.get("targetcurrencyamount");
        String organization = (String)rowdata.get("organization");
        Map originalCurrencyMap = (Map)rowdata.get("originalcurrency");
        Map targetCurrencyMap = (Map)rowdata.get("targetcurrency");
        Map deadLineMap = (Map)rowdata.get("deadline");
        Map ratesourcesMap = (Map)rowdata.get("ratesources");
        if (((String)originalCurrencyMap.get("number")).equals(targetCurrencyMap.get("number"))) {
            this.addErrMessage(ResManager.loadKDString((String)"\u539f\u5e01\u548c\u76ee\u6807\u5e01\u4e0d\u80fd\u4e00\u6837\u3002", (String)"ForeignMarketRateSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
        if ("new".equals(importType)) {
            DynamicObjectCollection foreignMarketRateArr = this.queryForeignMarketRateData(publishDate, organization, targetCurrencyAmount, (String)originalCurrencyMap.get("number"), (String)targetCurrencyMap.get("number"), (String)deadLineMap.get("number"), (String)ratesourcesMap.get("number"));
            if (null != foreignMarketRateArr && LendingMarketRateProp.ZERO < foreignMarketRateArr.size()) {
                this.addErrMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u671f\u9650\u7684\u5916\u6c47\u5e02\u573a\u724c\u4ef7\uff0c\u4e0d\u80fd\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u66f4\u65b0\u5df2\u6709\u6570\u636e\u7684\u76f8\u5173\u64cd\u4f5c\u3002", (String)"ForeignMarketRateImportOp_0", (String)SYSTEM_ID, (Object[])new Object[0]));
            }
        } else if ("override".equals(importType) || "overridenew".equals(importType)) {
            List fields = this.getSelectKeyFields();
            if (fields == null) {
                this.addErrMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u64cd\u4f5c\u8bf7\u9009\u62e9 %d \u9879\u552f\u4e00\u6821\u9a8c\u503c\uff1a\u724c\u4ef7\u6765\u6e90\u3001\u53d1\u5e03\u65e5\u671f\u3001\u671f\u9650\u540d\u79f0\u3001\u539f\u5e01\u3001\u76ee\u6807\u5e01\u548c\u76ee\u6807\u8d27\u5e01\u6570\u91cf\u3002", (String)"ForeignMarketRateImportOp_9", (String)SYSTEM_ID, (Object[])new Object[]{NECESSARY_KEY_FIELDS.size()}));
            } else {
                NECESSARY_KEY_FIELDS.entrySet().stream().forEach(consumer -> {
                    if (!fields.contains(consumer.getKey())) {
                        this.addErrMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u64cd\u4f5c\u6ca1\u6709\u5305\u542b\u552f\u4e00\u6821\u9a8c\u503c\uff1a%s\u3002", (String)"ForeignMarketRateImportOp_2", (String)SYSTEM_ID, (Object[])new Object[]{consumer.getValue()}));
                    }
                });
            }
        }
    }

    protected void afterImportOp(List<Map<String, Object>> datas) {
    }

    private DynamicObjectCollection queryForeignMarketRateData(Date publishDate, String organization, String targetCurrencyAmount, String originalCurrency, String targetCurrency, String deadLine, String ratesources) {
        DynamicObjectCollection foreignMarketRateArr = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
        DynamicObject originalCurrencyObj = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)originalCurrency)});
        DynamicObject targetCurrencyObj = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)targetCurrency)});
        DynamicObject terCodeObj = QueryServiceHelper.queryOne((String)"fbd_termcategorycode", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)deadLine)});
        DynamicObject forRateObj = QueryServiceHelper.queryOne((String)organization, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)ratesources)});
        if (null != originalCurrencyObj && null != targetCurrencyObj && null != terCodeObj && null != forRateObj) {
            filters.add(new QFilter("ratesources", "=", (Object)forRateObj.getLong("id")));
            filters.add(new QFilter("targetcurrency", "=", (Object)targetCurrencyObj.getLong("id")).or(new QFilter("targetcurrency", "=", (Object)originalCurrencyObj.getLong("id"))));
            filters.add(new QFilter("targetcurrencyamount", "=", (Object)targetCurrencyAmount));
            filters.add(new QFilter("releasedate", "=", (Object)publishDate));
            filters.add(new QFilter("deadline", "=", (Object)terCodeObj.getLong("id")));
            foreignMarketRateArr = QueryServiceHelper.query((String)"fbd_foreignmarkerate", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        }
        return foreignMarketRateArr;
    }
}

