/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.opplugin.lendingmarketrate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.property.LendingMarketRateProp;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class LendingMarketRateImportOp
extends AbstractTmcBatchImportPlugin {
    private static final String SYSTEM_ID = "tmc-fbd-opplugin";
    private static final Map<String, String> NECESSARY_KEY_FIELDS = new HashMap<String, String>(){
        private static final long serialVersionUID = 5191148007740336206L;
        {
            this.put("publishdate", ResManager.loadKDString((String)"\u53d1\u5e03\u65e5\u671f", (String)"LendingMarketRateImportOp_4", (String)LendingMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"LendingMarketRateImportOp_5", (String)LendingMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("lendingmarket", ResManager.loadKDString((String)"\u501f\u8d37\u5e02\u573a", (String)"LendingMarketRateImportOp_6", (String)LendingMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
            this.put("termcategory", ResManager.loadKDString((String)"\u671f\u9650\u7c7b\u522b", (String)"LendingMarketRateImportOp_7", (String)LendingMarketRateImportOp.SYSTEM_ID, (Object[])new Object[0]));
        }
    };

    public String getDefaultKeyFields() {
        return NECESSARY_KEY_FIELDS.keySet().stream().collect(Collectors.joining(","));
    }

    public String getDefaultImportType() {
        return "overridenew";
    }

    protected void beforeImportOp(Map<String, Object> rowdata, Map<String, Object> option) throws ParseException {
        String importType = this.getCurrentImportType();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date publishDate = simpleDateFormat.parse((String)rowdata.get("publishdate"));
        Map currencyMap = (Map)rowdata.get("currency");
        Map lendingmarketMap = (Map)rowdata.get("lendingmarket");
        Map termcategoryMap = (Map)rowdata.get("termcategory");
        if ("new".equals(importType)) {
            DynamicObject[] loanMarketDataArray = this.queryLendingMarketData(publishDate, (String)currencyMap.get("number"), (String)lendingmarketMap.get("number"), (String)termcategoryMap.get("number"));
            if (null != loanMarketDataArray && LendingMarketRateProp.ZERO < loanMarketDataArray.length) {
                this.addErrMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u501f\u8d37\u5e02\u573a\u3001\u671f\u9650\u3001\u5e01\u79cd\u548c\u53d1\u5e03\u65e5\u671f\u7684\u5229\u7387\u503c\uff0c\u4e0d\u80fd\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u66f4\u65b0\u5df2\u6709\u6570\u636e\u7684\u76f8\u5173\u64cd\u4f5c\u3002", (String)"LendingMarketRateImportOp_1", (String)SYSTEM_ID, (Object[])new Object[0]));
            }
        } else if ("override".equals(importType) || "overridenew".equals(importType)) {
            List fields = this.getSelectKeyFields();
            if (fields == null) {
                this.addErrMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u64cd\u4f5c\u8bf7\u9009\u62e9 %d \u9879\u552f\u4e00\u6821\u9a8c\u503c\uff1a\u501f\u8d37\u5e02\u573a\u3001\u53d1\u5e03\u65e5\u671f\u3001\u671f\u9650\u540d\u79f0\u548c\u5e01\u79cd\u3002", (String)"LendingMarketRateImportOp_2", (String)SYSTEM_ID, (Object[])new Object[]{NECESSARY_KEY_FIELDS.size()}));
            } else {
                NECESSARY_KEY_FIELDS.entrySet().stream().forEach(consumer -> {
                    if (!fields.contains(consumer.getKey())) {
                        this.addErrMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u64cd\u4f5c\u6ca1\u6709\u5305\u542b\u552f\u4e00\u6821\u9a8c\u503c\uff1a%s\u3002", (String)"LendingMarketRateImportOp_3", (String)SYSTEM_ID, (Object[])new Object[]{consumer.getValue()}));
                    }
                });
            }
        }
    }

    private DynamicObject[] queryLendingMarketData(Date publishDate, String currency, String lendingMarket, String termCategory) {
        DynamicObject[] lendingMarketArr = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        DynamicObject currencyDy = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currency)});
        DynamicObject lendingMarketDy = QueryServiceHelper.queryOne((String)"fbd_lendingmarketcode", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)lendingMarket)});
        DynamicObject termCategoryDy = QueryServiceHelper.queryOne((String)"fbd_termcategorycode", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)termCategory)});
        if (null != currencyDy && null != lendingMarketDy && null != termCategoryDy) {
            filters.add(new QFilter("currency", "=", (Object)currencyDy.getLong("id")));
            filters.add(new QFilter("lendingmarket", "=", (Object)lendingMarketDy.getLong("id")));
            filters.add(new QFilter("termcategory", "=", (Object)termCategoryDy.getLong("id")));
            filters.add(new QFilter("publishdate", "=", (Object)publishDate));
            lendingMarketArr = BusinessDataServiceHelper.load((String)"fbd_loanmarketrate", (String)"id,currency,currency.name,status,lendingmarket,lendingmarket.name,termcategory,termcategory.number,publishdate,rate", (QFilter[])filters.toArray(new QFilter[0]));
        }
        return lendingMarketArr;
    }

    protected void afterImportOp(List<Map<String, Object>> rowdata) {
    }
}

