/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.surety;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.mservice.surety.ISuretyAppendService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyAppendService
implements ISuretyAppendService {
    private static final String SURETY_APPEND_PROP = String.join((CharSequence)",", "org", "billno", "billstatus", "bizstatus");

    @Override
    public Map<Long, String> validateBeforeAppend(DynamicObject[] bizBills) {
        DynamicObject bizBill = bizBills[0];
        Long bizBillId = bizBill.getLong("id");
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(2);
        String status = SuretyHelper.getBizPropName((String)bizBill.getDataEntityType().getName(), (String)"status");
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)this.loadBizBill(bizBill, status).getString(status))) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5355\u636e\u975e\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8ffd\u52a0\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyAppendService_1", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        boolean existSurety = this.existSuretyFromDb(bizBill);
        if (!existSurety) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u4fdd\u8bc1\u91d1\u975e\u5df2\u5b58\u5165\u3001\u90e8\u5206\u5b58\u51fa\u72b6\u6001\u3002", (String)"SuretyAppendService_0", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        return Collections.emptyMap();
    }

    private DynamicObject loadBizBill(DynamicObject bizBill, String status) {
        return QueryServiceHelper.queryOne((String)bizBill.getDataEntityType().getName(), (String)status, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizBill.getLong("id"))});
    }

    private boolean existSuretyFromDb(DynamicObject bizBill) {
        if (EmptyUtil.isEmpty((DynamicObject)bizBill)) {
            return false;
        }
        Long bizBillId = bizBill.getLong("id");
        QFilter idFilter = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)bizBill.getDataEntityType().getName()) ? new QFilter("entry_credit.creditbillid", "=", (Object)bizBillId) : new QFilter("entry.debtbillid", "=", (Object)bizBillId);
        idFilter.and("enable", "=", (Object)true);
        idFilter.and("bizstatus", "in", Arrays.asList(SuretyBizStatusEnum.SURETY_DONE.getValue(), SuretyBizStatusEnum.SURETY_PART.getValue()));
        return TmcDataServiceHelper.exists((String)"fbd_suretybill", (QFilter[])idFilter.toArray());
    }

    @Override
    public void append(DynamicObject[] bizBills) {
        this.suretyAppend(bizBills[0].getLong("id"), bizBills[0].getDataEntityType().getName());
    }

    private void suretyAppend(Long bizId, String entityName) {
        QFilter qFilter = SuretyHelper.getSuretyEntryFilterWithSave((Long)bizId, (String)entityName);
        Object[] suretyAppends = TmcDataServiceHelper.load((String)"fbd_surety_append", (String)SURETY_APPEND_PROP, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])suretyAppends)) {
            DynamicObject suretyBill = SuretyHelper.loadSuretyByBizId((Long)bizId, (String)entityName);
            OperateOption create = OperateOption.create();
            create.setVariableValue("suretyAppendDebtBillIdStr", String.valueOf(bizId));
            TmcOperateServiceHelper.execOperate((String)"pushandsaveappend", (String)"fbd_suretybill", (Object[])new Object[]{suretyBill.getLong("id")}, (OperateOption)create);
        }
        for (Object suretyAppend : suretyAppends) {
            if (!EmptyUtil.isEmpty((String)suretyAppend.getString("billno"))) continue;
            suretyAppend.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fbd_surety_append", (DynamicObject)suretyAppend, (String)suretyAppend.getDynamicObject("org").getString("id"), (String)""));
        }
        TmcDataServiceHelper.save((DynamicObject[])suretyAppends);
    }
}

