/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.surety;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.PartyTypeEnum;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbd.common.enums.SuretyStatusEnum;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbd.mservice.surety.ISuretyService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.surety.SuretyBean;
import kd.tmc.fbp.common.model.surety.SuretyDebtEntryStatusInfo;
import kd.tmc.fbp.common.model.surety.SuretyEntryBean;
import kd.tmc.fbp.common.model.surety.SuretyEntryIntInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyService
implements ISuretyService {
    public static final String SURETY_BILL_ENTRY_PROPS = String.join((CharSequence)",", String.join((CharSequence)",", "entry.debtbillid"), String.join((CharSequence)",", "entry.debttype"), String.join((CharSequence)",", "entry.applybillno"));
    private static Log logger = LogFactory.getLog(SuretyService.class);
    private static final String SURETY_PROP = String.join((CharSequence)",", "org", "billno", "billstatus", "enable", "bizstatus");
    private static final List<String> APPROVE_BILL_LIST = new ArrayList<String>();

    @Override
    public void generate(DynamicObject[] dataEntities, String formId) {
        if (EmptyUtil.isEmpty((Object[])dataEntities) || !APPROVE_BILL_LIST.contains(dataEntities[0].getDataEntityType().getName())) {
            return;
        }
        if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)dataEntities[0].getDataEntityType().getName())) {
            this.generateCreditSurety(dataEntities);
        } else {
            this.generateDebitSurety(dataEntities, formId);
        }
    }

    private void generateDebitSurety(DynamicObject[] dataEntities, String formId) {
        String entityName = dataEntities[0].getDataEntityType().getName();
        String bizNoProp = SuretyHelper.getBizPropName((String)entityName, (String)"bizno");
        String orgProp = SuretyHelper.getBizPropName((String)entityName, (String)"org");
        String creditLimitProp = SuretyHelper.getBizPropName((String)entityName, (String)"credit");
        String startDateProp = SuretyHelper.getBizPropName((String)entityName, (String)"debtstartdate");
        String endDateProp = SuretyHelper.getBizPropName((String)entityName, (String)"debtenddate");
        String amountProp = SuretyHelper.getBizPropName((String)entityName, (String)"amount");
        String finOrgProp = SuretyHelper.getBizPropName((String)entityName, (String)"finorginfo");
        ArrayList<SuretyBean> suretyList = new ArrayList<SuretyBean>(dataEntities.length);
        for (DynamicObject srcBill : dataEntities) {
            Long srcBillId = srcBill.getLong("id");
            DynamicObjectCollection suretyEntry = srcBill.getDynamicObjectCollection("entry_surety");
            this.dealDeleteEntry(srcBillId);
            if ("cdm_payablebill".equals(entityName) && EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) {
                suretyEntry = this.loadSuretyEntry(suretyEntry, srcBillId, srcBill.getLong("sourcebillid"));
            }
            if (suretyEntry == null || EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) continue;
            String billNo = srcBill.getString("billno");
            DynamicObject org = srcBill.getDynamicObject(orgProp);
            DynamicObject creditLimit = srcBill.getDynamicObject(creditLimitProp);
            String bizStatus = SuretyBillHelper.getActDebtBizStatus((DynamicObject)srcBill, (String)entityName);
            for (DynamicObject surety : suretyEntry) {
                BigDecimal suretySurplusAmount;
                DynamicObjectCollection entryEntity;
                if (EmptyUtil.isEmpty((DynamicObject)surety.getDynamicObject("suretybill"))) continue;
                SuretyBean suretyBean = new SuretyBean();
                suretyBean.setSuretyBillId(Long.valueOf(surety.getDynamicObject("suretybill").getLong("id")));
                suretyBean.setSrcBillId(srcBillId);
                suretyBean.setSrcBillType(SuretyService.getDebitType(formId, srcBill));
                suretyBean.setSrcBillNo(billNo);
                suretyBean.setBizNo(srcBill.getString(bizNoProp));
                if (EmptyUtil.isNoEmpty((DynamicObject)surety.getDynamicObject("suretyfinorg"))) {
                    suretyBean.setFinOrgId(Long.valueOf(surety.getDynamicObject("suretyfinorg").getLong("id")));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)surety.getDynamicObject("suretycurrency"))) {
                    suretyBean.setCurrencyId(Long.valueOf(surety.getDynamicObject("suretycurrency").getLong("id")));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)surety.getDynamicObject("suretyaccount"))) {
                    suretyBean.setSettleAccountId(Long.valueOf(surety.getDynamicObject("suretyaccount").getLong("id")));
                }
                suretyBean.setFinOrgOther(surety.getString("suretyfinorgother"));
                suretyBean.setInvestOrgType(surety.getString("suretyinvestorgtype"));
                DynamicObject suretyDb = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"surplusamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)suretyBean.getSuretyBillId())});
                suretyBean.setSurplusAmount(suretyDb.getBigDecimal("surplusamount"));
                suretyBean.setDebtCurrencyId(this.getBizBillCurrencyId(srcBill));
                suretyBean.setDebtAmount(srcBill.getBigDecimal(amountProp));
                BigDecimal exchangeRate = this.getRate(surety.getDynamicObject("suretycurrency"), srcBill, entityName);
                if ("cdm_payablebill_ap_manual".equals(entityName)) {
                    entryEntity = srcBill.getDynamicObjectCollection("entryentity");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)entryEntity.get(0)).getDynamicObject(finOrgProp))) {
                        suretyBean.setFinOrgId(Long.valueOf(((DynamicObject)entryEntity.get(0)).getDynamicObject(finOrgProp).getLong("id")));
                    }
                } else if ("cdm_payablebill".equals(entityName)) {
                    DynamicObject drawerAccount = srcBill.getDynamicObject("draweraccount");
                    if (EmptyUtil.isNoEmpty((DynamicObject)drawerAccount)) {
                        DynamicObject bank = drawerAccount.getDynamicObject("bank");
                        if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                            suretyBean.setDebtFinOrgId(Long.valueOf(bank.getLong("id")));
                        }
                        suretyBean.setBizBillSrcId(Long.valueOf(srcBill.getLong("sourcebillid")));
                    }
                    suretyBean.setSuretyMoney(srcBill.getBigDecimal("suretymoney"));
                } else if (Arrays.asList("cfm_loancontractbill", "fl_leasecontractbill").contains(entityName)) {
                    suretySurplusAmount = suretyDb.getBigDecimal("surplusamount").multiply(exchangeRate);
                    suretyBean.setSuretyMoney(suretyBean.getDebtAmount().compareTo(suretySurplusAmount) > 0 ? suretySurplusAmount : suretyBean.getDebtAmount());
                    suretyBean.setDebtFinOrgId(Long.valueOf(srcBill.getLong(finOrgProp)));
                } else if ("lc_lettercredit".equals(entityName)) {
                    suretyBean.setDebtAmount(srcBill.getBigDecimal(amountProp).multiply(BigDecimal.ONE.add(srcBill.getBigDecimal("amountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP))));
                    suretyBean.setSuretyMoney(srcBill.getBigDecimal("totalsuretymoney").multiply(exchangeRate));
                    suretyBean.setDebtFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
                } else {
                    suretySurplusAmount = suretyDb.getBigDecimal("surplusamount").multiply(exchangeRate);
                    suretyBean.setSuretyMoney(suretyBean.getDebtAmount().compareTo(suretySurplusAmount) > 0 ? suretySurplusAmount : suretyBean.getDebtAmount());
                    suretyBean.setDebtFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
                }
                suretyBean.setAmount(surety.getBigDecimal("suretyamount"));
                suretyBean.setIntDate(surety.getDate("suretyintdate"));
                suretyBean.setTerm(surety.getString("suretyterm"));
                suretyBean.setExpireDate(surety.getDate("suretyexpiredate"));
                suretyBean.setOrgId(Long.valueOf(org.getLong("id")));
                suretyBean.setSuretySource(surety.getString("suretysource"));
                suretyBean.setBizStatus(bizStatus);
                if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
                    suretyBean.setCreditId(Long.valueOf(creditLimit.getLong("id")));
                }
                if ("cdm_payablebill_ap_manual".equals(entityName)) {
                    entryEntity = srcBill.getDynamicObjectCollection("entryentity");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
                        suretyBean.setDebtStartDate(((DynamicObject)entryEntity.get(0)).getDate(startDateProp));
                    }
                } else {
                    suretyBean.setDebtStartDate(srcBill.getDate(startDateProp));
                }
                if ("cdm_payablebill_ap_manual".equals(entityName)) {
                    entryEntity = srcBill.getDynamicObjectCollection("entryentity");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
                        suretyBean.setDebtEndDate(((DynamicObject)entryEntity.get(0)).getDate(endDateProp));
                    }
                    this.setSuretyEntryBean(srcBill, suretyBean);
                } else {
                    suretyBean.setDebtEndDate(srcBill.getDate(endDateProp));
                }
                suretyList.add(suretyBean);
            }
        }
        if (EmptyUtil.isNoEmpty(suretyList)) {
            SuretyService.saveSurety(suretyList);
        }
    }

    private DynamicObjectCollection loadSuretyEntry(DynamicObjectCollection suretyEntry, Long id, Long srcBillId) {
        String column = String.join((CharSequence)",", "finorginfo", "currency", "amount", "surplusamount", "finorgother", "investorgtype", "settleaccount", "intdate", "term", "expiredate", "entry.debtbillid", "entry.suretysource");
        QFilter idFilter = new QFilter("entry.debtbillid", "=", (Object)id);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)column, (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            idFilter = new QFilter("entryentity.id", "=", (Object)srcBillId);
            DynamicObject payableBillApply = QueryServiceHelper.queryOne((String)"cdm_payablebill_ap_manual", (String)"id", (QFilter[])new QFilter[]{idFilter});
            if (EmptyUtil.isEmpty((DynamicObject)payableBillApply)) {
                QFilter oldIdFilter = new QFilter("id", "=", (Object)srcBillId);
                payableBillApply = QueryServiceHelper.queryOne((String)"cdm_payablebill_apply", (String)"id", (QFilter[])new QFilter[]{oldIdFilter});
            }
            if (EmptyUtil.isEmpty((DynamicObject)payableBillApply)) {
                return null;
            }
            srcBillId = payableBillApply.getLong("id");
            idFilter = new QFilter("entry.debtbillid", "=", (Object)srcBillId);
            suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)column, (QFilter[])new QFilter[]{idFilter});
        }
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            return null;
        }
        for (Object suretyBill : suretyBills) {
            DynamicObject suretyEntryObj = suretyEntry.addNew();
            suretyEntryObj.set("suretybill", suretyBill);
            suretyEntryObj.set("suretyfinorg", (Object)suretyBill.getDynamicObject("finorginfo"));
            suretyEntryObj.set("suretyfinorgother", (Object)suretyBill.getString("finorgother"));
            suretyEntryObj.set("suretyinvestorgtype", (Object)suretyBill.getString("investorgtype"));
            suretyEntryObj.set("suretycurrency", (Object)suretyBill.getDynamicObject("currency"));
            suretyEntryObj.set("suretyamount", (Object)suretyBill.getBigDecimal("amount"));
            suretyEntryObj.set("suretysurplusamount", (Object)suretyBill.getBigDecimal("surplusamount"));
            suretyEntryObj.set("suretyaccount", (Object)suretyBill.getDynamicObject("settleaccount"));
            suretyEntryObj.set("suretyintdate", (Object)suretyBill.getDate("intdate"));
            suretyEntryObj.set("suretyterm", (Object)suretyBill.getString("term"));
            suretyEntryObj.set("suretyexpiredate", (Object)suretyBill.getDate("expiredate"));
            suretyEntryObj.set("suretysource", (Object)this.getSuretySource(id, (DynamicObject)suretyBill));
        }
        return suretyEntry;
    }

    private String getSuretySource(Long id, DynamicObject suretyBill) {
        DynamicObjectCollection entryList = suretyBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryList) {
            Long debtBillId = entry.getLong("debtbillid");
            if (!id.equals(debtBillId)) continue;
            return entry.getString("suretysource");
        }
        return BillSourceEnum.HAND.getValue();
    }

    private BigDecimal getRate(DynamicObject fromCurrency, DynamicObject srcBill, String entityName) {
        Long tarCurrencyId;
        DynamicObject tarCurrency = srcBill.getDynamicObject(GuaranteeUseHelper.getBizPropName((String)entityName, (String)"bizcurrency"));
        if (EmptyUtil.isEmpty((DynamicObject)fromCurrency) || EmptyUtil.isEmpty((DynamicObject)tarCurrency)) {
            return BigDecimal.ONE;
        }
        Long fromCurrencyId = fromCurrency.getLong("id");
        if (fromCurrencyId.equals(tarCurrencyId = Long.valueOf(tarCurrency.getLong("id")))) {
            return BigDecimal.ONE;
        }
        Long orgId = srcBill.getDynamicObject(GuaranteeUseHelper.getBizPropName((String)entityName, (String)"debtor")).getLong("id");
        BigDecimal rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate());
        if (rate == null) {
            return BigDecimal.ONE;
        }
        return rate;
    }

    private void setSuretyEntryBean(DynamicObject srcBill, SuretyBean suretyBean) {
        suretyBean.setMultiEntry(srcBill.getBoolean("iseditsuretyamount"));
        DynamicObjectCollection entryEntity = srcBill.getDynamicObjectCollection("entryentity");
        ArrayList<SuretyEntryBean> suretyEntryBeans = new ArrayList<SuretyEntryBean>(entryEntity.size());
        List suretyEntityEntries = entryEntity.stream().filter(d -> !d.getBoolean("invalid")).collect(Collectors.toList());
        Long creditCurrencyId = null;
        if (EmptyUtil.isNoEmpty((Long)suretyBean.getCreditId())) {
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("creditlimit", "=", (Object)suretyBean.getCreditId())).and(new QFilter("sourcebillno", "=", (Object)suretyBean.getSrcBillNo()));
            DynamicObject creditUse = TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"currency,realamt", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                creditCurrencyId = creditUse.getDynamicObject("currency").getLong("id");
            }
        }
        for (DynamicObject entry : suretyEntityEntries) {
            SuretyEntryBean suretyEntryBean = new SuretyEntryBean();
            suretyEntryBean.setApplyBillId(Long.valueOf(entry.getLong("id")));
            suretyEntryBean.setDebtAmount(entry.getBigDecimal("amount"));
            suretyEntryBean.setSuretyAmount(entry.getBigDecimal("entry_suretyamount"));
            suretyEntryBean.setSrcBillType(suretyBean.getSrcBillType());
            SuretyService.setDebitFinOrgId(srcBill, suretyBean, entry, suretyEntryBean);
            suretyEntryBean.setDebtCurrencyId(this.getBizBillCurrencyId(srcBill));
            suretyEntryBean.setSrcBillId(Long.valueOf(srcBill.getLong("id")));
            suretyEntryBean.setSrcBillNo(srcBill.getString("billno"));
            suretyEntryBean.setBizStatus(SuretyStatusEnum.GUARANTING.getValue());
            suretyEntryBean.setSuretySource(BillSourceEnum.HAND.getValue());
            suretyEntryBean.setApplyBillNo(srcBill.getString("billno"));
            suretyEntryBean.setDebtStartDate(entry.getDate("issuedate"));
            suretyEntryBean.setDebtEndDate(entry.getDate("draftbillexpiredate"));
            suretyEntryBean.setCreditId(suretyBean.getCreditId());
            suretyEntryBean.setCreditCurrencyId(creditCurrencyId);
            suretyEntryBean.setCreditAmt(entry.getBigDecimal("entry_amountofcredit"));
            suretyEntryBeans.add(suretyEntryBean);
        }
        suretyBean.setSuretyEntries(suretyEntryBeans);
    }

    private Long getBizBillCurrencyId(DynamicObject srcBill) {
        String entityName = srcBill.getDataEntityType().getName();
        String currencyProp = SuretyHelper.getBizPropName((String)entityName, (String)"currency");
        DynamicObject currency = srcBill.getDynamicObject(currencyProp);
        return EmptyUtil.isEmpty((DynamicObject)currency) ? 0L : currency.getLong("id");
    }

    private static void setDebitFinOrgId(DynamicObject srcBill, SuretyBean suretyBean, DynamicObject entry, SuretyEntryBean suretyEntryBean) {
        String entityName = srcBill.getDataEntityType().getName();
        String finOrgProp = SuretyHelper.getBizPropName((String)entityName, (String)"finorginfo");
        if ("cdm_payablebill_ap_manual".equals(entityName)) {
            DynamicObject draftBillType = srcBill.getDynamicObject("draftbilltype");
            if (EmptyUtil.isEmpty((DynamicObject)draftBillType)) {
                return;
            }
            String settlementType = draftBillType.getString("settlementtype");
            if ("5".equals(settlementType) || "6".equals(settlementType)) {
                suretyEntryBean.setDebtFinOrgId(suretyBean.getFinOrgId());
            } else {
                DynamicObject finOrg = entry.getDynamicObject(finOrgProp);
                if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
                    return;
                }
                suretyEntryBean.setDebtFinOrgId(Long.valueOf(finOrg.getLong("id")));
            }
        }
    }

    private void generateCreditSurety(DynamicObject[] dataEntities) {
        String entityName = dataEntities[0].getDataEntityType().getName();
        String bizNoProp = SuretyHelper.getBizPropName((String)entityName, (String)"bizno");
        String orgProp = SuretyHelper.getBizPropName((String)entityName, (String)"org");
        ArrayList<SuretyBean> suretyList = new ArrayList<SuretyBean>(dataEntities.length);
        for (DynamicObject srcBill : dataEntities) {
            Long srcBillId = srcBill.getLong("id");
            String srcBillType = srcBill.getDataEntityType().getName();
            DynamicObjectCollection suretyEntry = srcBill.getDynamicObjectCollection("entry_surety");
            this.dealDeleteCreditEntry(srcBillId);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) continue;
            for (DynamicObject surety : suretyEntry) {
                SuretyBean suretyBean = new SuretyBean();
                if (EmptyUtil.isNoEmpty((DynamicObject)surety.getDynamicObject("suretybill"))) {
                    suretyBean.setSuretyBillId(Long.valueOf(surety.getDynamicObject("suretybill").getLong("id")));
                }
                suretyBean.setSrcBillId(srcBillId);
                suretyBean.setSrcBillType(srcBillType);
                suretyBean.setSrcBillNo(srcBill.getString("number"));
                suretyBean.setBizNo(srcBill.getString(bizNoProp));
                DynamicObject finOrg = surety.getDynamicObject("suretyfinorg");
                suretyBean.setFinOrgId(EmptyUtil.isEmpty((DynamicObject)finOrg) ? null : Long.valueOf(finOrg.getLong("id")));
                DynamicObject currency = surety.getDynamicObject("suretycurrency");
                if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                    suretyBean.setCurrencyId(Long.valueOf(currency.getLong("id")));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)surety.getDynamicObject("suretyaccount"))) {
                    suretyBean.setSettleAccountId(Long.valueOf(surety.getDynamicObject("suretyaccount").getLong("id")));
                }
                suretyBean.setFinOrgOther(surety.getString("suretyfinorgother"));
                suretyBean.setInvestOrgType(surety.getString("suretyinvestorgtype"));
                DynamicObject org = srcBill.getDynamicObject(orgProp);
                suretyBean.setOrgId(EmptyUtil.isEmpty((DynamicObject)org) ? null : Long.valueOf(org.getLong("id")));
                suretyBean.setIntDate(surety.getDate("suretyintdate"));
                suretyBean.setTerm(surety.getString("suretyterm"));
                suretyBean.setExpireDate(surety.getDate("suretyexpiredate"));
                suretyBean.setSuretySource(surety.getString("suretysource"));
                suretyBean.setSurplusAmount(surety.getBigDecimal("suretysurplusamount"));
                suretyBean.setAmount(surety.getBigDecimal("suretyamount"));
                suretyBean.setCreditSource(surety.getString("suretysource"));
                suretyList.add(suretyBean);
            }
        }
        if (EmptyUtil.isNoEmpty(suretyList)) {
            SuretyService.saveSuretyCredit(suretyList);
        }
    }

    private void dealDeleteEntry(Long srcBillId) {
        QFilter idFilter = new QFilter("entry.debtbillid", "=", (Object)srcBillId);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)SURETY_BILL_ENTRY_PROPS, (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            return;
        }
        for (Object suretyBill : suretyBills) {
            DynamicObjectCollection debtEntries = suretyBill.getDynamicObjectCollection("entry");
            debtEntries.removeIf(e -> srcBillId.equals(e.getLong("debtbillid")) && (!EmptyUtil.isNoEmpty((String)e.getString("applybillno")) || !"cdm_payablebill".equals(e.getString("debttype"))));
        }
        TmcDataServiceHelper.save((DynamicObject[])suretyBills);
    }

    private void dealDeleteCreditEntry(Long srcBillId) {
        QFilter idFilter = new QFilter("entry_credit.creditbillid", "=", (Object)srcBillId);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)String.join((CharSequence)",", "entry_credit.creditbillid"), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            return;
        }
        for (Object suretyBill : suretyBills) {
            DynamicObjectCollection debtEntries = suretyBill.getDynamicObjectCollection("entry_credit");
            debtEntries.removeIf(e -> srcBillId.equals(e.getDynamicObject("creditbillid").getLong("id")));
        }
        TmcDataServiceHelper.save((DynamicObject[])suretyBills);
    }

    private void confirmDebitSuretyBill(DynamicObject srcBill, String debitType) {
        DynamicObjectCollection suretyEntry = srcBill.getDynamicObjectCollection("entry_surety");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) {
            SuretyBean suretyBean = this.generateDebitSuretyBean(srcBill, debitType);
            ArrayList<SuretyBean> suretyList = new ArrayList<SuretyBean>(1);
            suretyList.add(suretyBean);
            SuretyService.saveSurety(suretyList);
        }
    }

    private void confirmSuretyCreditBill(DynamicObject srcBill) {
        DynamicObjectCollection suretyEntry = srcBill.getDynamicObjectCollection("entry_surety");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) {
            SuretyBean suretyBean = this.generateCreditSuretyBean(srcBill);
            ArrayList<SuretyBean> suretyList = new ArrayList<SuretyBean>(1);
            suretyList.add(suretyBean);
            SuretyService.saveSuretyCredit(suretyList);
            srcBill.set("issurety", (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
        }
    }

    private SuretyBean generateDebitSuretyBean(DynamicObject srcBill, String debitType) {
        SuretyBean suretyBean = new SuretyBean();
        String entityName = srcBill.getDataEntityType().getName();
        String bizNoProp = SuretyHelper.getBizPropName((String)entityName, (String)"bizno");
        String orgProp = SuretyHelper.getBizPropName((String)entityName, (String)"org");
        String creditLimitProp = SuretyHelper.getBizPropName((String)entityName, (String)"credit");
        suretyBean.setSrcBillId(Long.valueOf(srcBill.getLong("id")));
        suretyBean.setSrcBillType(debitType);
        suretyBean.setSrcBillNo(srcBill.getString("billno"));
        suretyBean.setBizNo(srcBill.getString(bizNoProp));
        String finOrgProp = SuretyHelper.getBizPropName((String)entityName, (String)"finorginfo");
        String investOrgTypeProp = SuretyHelper.getBizPropName((String)entityName, (String)"investorgtype");
        SuretyService.setInvestOrgType(srcBill, suretyBean, investOrgTypeProp);
        if (EmptyUtil.isNoEmpty((String)finOrgProp)) {
            if ("cdm_payablebill_ap_manual".equals(entityName) || "cdm_payablebill".equals(entityName)) {
                String settlementType = srcBill.getDynamicObject("draftbilltype").getString("settlementtype");
                if ("5".equals(settlementType)) {
                    DynamicObject acceptCompany = srcBill.getDynamicObject("acceptercompany");
                    if (EmptyUtil.isNoEmpty((DynamicObject)acceptCompany)) {
                        suretyBean.setFinOrgId(Long.valueOf(acceptCompany.getLong("id")));
                        suretyBean.setFinOrgOther(acceptCompany.getString("name"));
                    }
                    suretyBean.setInvestOrgType(CreditorTypeEnum.OTHER.getFormId());
                } else if ("6".equals(settlementType)) {
                    long accepterFinOrg = srcBill.getDynamicObject("accepterfinorg").getLong("id");
                    suretyBean.setInvestOrgType(CreditorTypeEnum.FINORG.getFormId());
                    suretyBean.setFinOrgId(Long.valueOf(accepterFinOrg));
                    suretyBean.setDebtFinOrgId(Long.valueOf(accepterFinOrg));
                    suretyBean.setFinOrgOther(srcBill.getDynamicObject("accepterfinorg").getString("name"));
                } else if ("cdm_payablebill_ap_manual".equals(entityName)) {
                    DynamicObjectCollection entryEntity = srcBill.getDynamicObjectCollection("entryentity");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)entryEntity.get(0)).getDynamicObject(finOrgProp))) {
                        suretyBean.setFinOrgId(Long.valueOf(((DynamicObject)entryEntity.get(0)).getDynamicObject(finOrgProp).getLong("id")));
                        suretyBean.setDebtFinOrgId(Long.valueOf(((DynamicObject)entryEntity.get(0)).getDynamicObject(finOrgProp).getLong("id")));
                        suretyBean.setFinOrgOther(((DynamicObject)entryEntity.get(0)).getDynamicObject(finOrgProp).getString("name"));
                    }
                } else if ("cdm_payablebill".equals(entityName)) {
                    suretyBean.setFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
                    suretyBean.setDebtFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
                    suretyBean.setFinOrgOther(srcBill.getDynamicObject(finOrgProp).getString("name"));
                }
            } else if (Arrays.asList("cfm_loancontractbill", "fl_leasecontractbill").contains(entityName)) {
                suretyBean.setFinOrgId(Long.valueOf(srcBill.getLong(finOrgProp)));
                suretyBean.setDebtFinOrgId(Long.valueOf(srcBill.getLong(finOrgProp)));
                suretyBean.setFinOrgOther(srcBill.getString("textcreditor"));
            } else if (EmptyUtil.isNoEmpty((DynamicObject)srcBill.getDynamicObject(finOrgProp))) {
                suretyBean.setFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
                suretyBean.setDebtFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
                suretyBean.setFinOrgOther(srcBill.getDynamicObject(finOrgProp).getString("name"));
            }
        }
        String amountProp = SuretyHelper.getBizPropName((String)entityName, (String)"amount");
        suretyBean.setDebtAmount(srcBill.getBigDecimal(amountProp));
        suretyBean.setSuretyMoney(suretyBean.getDebtAmount());
        if ("cdm_payablebill".equals(entityName)) {
            Date draftBillExpireDate = srcBill.getDate("draftbillexpiredate");
            suretyBean.setExpireDate(draftBillExpireDate);
            suretyBean.setBizBillSrcId(Long.valueOf(srcBill.getLong("sourcebillid")));
            suretyBean.setSuretyMoney(srcBill.getBigDecimal("suretyMoney"));
        } else if ("cdm_payablebill_ap_manual".equals(entityName)) {
            Date draftBillExpireDate;
            DynamicObjectCollection entryEntitys = srcBill.getDynamicObjectCollection("entryentity");
            if (entryEntitys == null || entryEntitys.size() < 1) {
                draftBillExpireDate = new Date();
            } else {
                Collections.sort(entryEntitys, (o1, o2) -> o2.getDate("draftbillexpiredate").compareTo(o1.getDate("draftbillexpiredate")));
                draftBillExpireDate = ((DynamicObject)entryEntitys.get(0)).getDate("draftbillexpiredate");
            }
            suretyBean.setExpireDate(draftBillExpireDate);
            suretyBean.setSuretyMoney(srcBill.getBigDecimal("suretyMoney"));
        } else if ("lc_lettercredit".equals(entityName)) {
            suretyBean.setDebtAmount(srcBill.getBigDecimal(amountProp).multiply(BigDecimal.ONE.add(srcBill.getBigDecimal("amountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP))));
            BigDecimal exchangeRate = this.getRate(srcBill.getDynamicObject("suretycur"), srcBill, entityName);
            suretyBean.setSuretyMoney(srcBill.getBigDecimal("totalsuretymoney").multiply(exchangeRate));
        }
        String currencyProp = SuretyHelper.getBizPropName((String)entityName, (String)"currency");
        suretyBean.setCurrencyId(Long.valueOf(srcBill.getDynamicObject(currencyProp).getLong("id")));
        if ("lc_lettercredit".equals(entityName)) {
            suretyBean.setCurrencyId(Long.valueOf(srcBill.getDynamicObject("suretycur").getLong("id")));
        }
        suretyBean.setDebtCurrencyId(Long.valueOf(srcBill.getDynamicObject(currencyProp).getLong("id")));
        if ("cdm_payablebill_ap_manual".equals(entityName) || "cdm_payablebill".equals(entityName)) {
            suretyBean.setAmount("cdm_payablebill_ap_manual".equals(entityName) && srcBill.containsProperty("iseditsuretyamount") && srcBill.getBoolean("iseditsuretyamount") ? srcBill.getDynamicObjectCollection("entryentity").stream().map(e -> e.getBigDecimal("entry_suretyamount")).reduce(BigDecimal.ZERO, BigDecimal::add) : srcBill.getBigDecimal("suretymoney"));
        } else if ("lc_lettercredit".equals(entityName)) {
            suretyBean.setAmount(srcBill.getBigDecimal("totalsuretymoney"));
        } else {
            suretyBean.setAmount(srcBill.getBigDecimal(amountProp));
        }
        suretyBean.setSurplusAmount(suretyBean.getAmount());
        DynamicObject org = srcBill.getDynamicObject(orgProp);
        suretyBean.setOrgId(Long.valueOf(org.getLong("id")));
        suretyBean.setSuretySource(BillSourceEnum.HAND.getValue());
        String bizStatus = SuretyBillHelper.getActDebtBizStatus((DynamicObject)srcBill, (String)entityName);
        suretyBean.setBizStatus(bizStatus);
        this.setCreditLimit(srcBill, creditLimitProp, suretyBean);
        String startDateProp = SuretyHelper.getBizPropName((String)entityName, (String)"debtstartdate");
        String endDateProp = SuretyHelper.getBizPropName((String)entityName, (String)"debtenddate");
        if ("cdm_payablebill_ap_manual".equals(entityName)) {
            DynamicObjectCollection entryEntity = srcBill.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
                suretyBean.setDebtStartDate(((DynamicObject)entryEntity.get(0)).getDate(startDateProp));
                suretyBean.setDebtEndDate(((DynamicObject)entryEntity.get(0)).getDate(endDateProp));
            }
            this.setSuretyEntryBean(srcBill, suretyBean);
        } else {
            suretyBean.setDebtStartDate(srcBill.getDate(startDateProp));
            suretyBean.setDebtEndDate(srcBill.getDate(endDateProp));
        }
        suretyBean.setIntDate(suretyBean.getDebtStartDate());
        if (EmptyUtil.isNoEmpty((Object)suretyBean.getIntDate()) && EmptyUtil.isNoEmpty((Object)suretyBean.getExpireDate())) {
            suretyBean.setTerm(TermHelper.callTermLargeEqualZore((Date)suretyBean.getIntDate(), (Date)suretyBean.getExpireDate()));
        }
        return suretyBean;
    }

    private static void setInvestOrgType(DynamicObject srcBill, SuretyBean suretyBean, String investOrgTypeProp) {
        if (EmptyUtil.isEmpty((String)investOrgTypeProp)) {
            suretyBean.setInvestOrgType(CreditorTypeEnum.FINORG.getFormId());
        } else {
            suretyBean.setInvestOrgType(srcBill.getString(investOrgTypeProp));
        }
    }

    private SuretyBean generateCreditSuretyBean(DynamicObject srcBill) {
        SuretyBean suretyBean = new SuretyBean();
        String entityName = srcBill.getDataEntityType().getName();
        String bizNoProp = SuretyHelper.getBizPropName((String)entityName, (String)"bizno");
        String orgProp = SuretyHelper.getBizPropName((String)entityName, (String)"org");
        String srcBillNo = SuretyHelper.getBizPropName((String)entityName, (String)"billno");
        String finOrgProp = SuretyHelper.getBizPropName((String)entityName, (String)"finorginfo");
        String currencyProp = SuretyHelper.getBizPropName((String)entityName, (String)"currency");
        String amountProp = SuretyHelper.getBizPropName((String)entityName, (String)"amount");
        suretyBean.setSrcBillId(Long.valueOf(srcBill.getLong("id")));
        suretyBean.setSrcBillNo(srcBill.getString(srcBillNo));
        suretyBean.setBizNo(srcBill.getString(bizNoProp));
        if (EmptyUtil.isNoEmpty((DynamicObject)srcBill.getDynamicObject(finOrgProp))) {
            suretyBean.setFinOrgId(Long.valueOf(srcBill.getDynamicObject(finOrgProp).getLong("id")));
            suretyBean.setFinOrgOther(srcBill.getDynamicObject(finOrgProp).getString("name"));
        }
        suretyBean.setInvestOrgType(PartyTypeEnum.bd_finorginfo.getValue());
        suretyBean.setCurrencyId(Long.valueOf(srcBill.getDynamicObject(currencyProp).getLong("id")));
        suretyBean.setAmount(srcBill.getBigDecimal(amountProp));
        suretyBean.setOrgId(Long.valueOf(srcBill.getDynamicObject(orgProp).getLong("id")));
        suretyBean.setCreditSource(BillSourceEnum.HAND.getValue());
        suretyBean.setIntDate(DateUtils.getCurrentDate());
        return suretyBean;
    }

    private void setCreditLimit(DynamicObject srcBill, String creditLimitProp, SuretyBean suretyBean) {
        DynamicObject creditLimit;
        if (!StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)srcBill.getDataEntityType().getName()) && EmptyUtil.isNoEmpty((DynamicObject)(creditLimit = srcBill.getDynamicObject(creditLimitProp)))) {
            suretyBean.setCreditId(Long.valueOf(creditLimit.getLong("id")));
        }
    }

    @Override
    public void confirm(DynamicObject[] dataEntities, String formId) {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)dataEntities[0].getDataEntityType().getName())) {
            this.confirmCreditSurety(dataEntities);
        } else {
            this.confirmDebitSurety(dataEntities, formId);
        }
    }

    @Override
    public Map<Long, String> unConfirmValidate(DynamicObject[] bizBills) {
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>();
        for (DynamicObject bizBill : bizBills) {
            Long bizBillId = bizBill.getLong("id");
            boolean existSurety = SuretyService.existSuretyFromDb(bizBill, true);
            if (!existSurety) continue;
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u4fdd\u8bc1\u91d1\u5355\u636e\u3002", (String)"SuretyService_2", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
        }
        return errorMsgMap;
    }

    @Override
    public Map<Long, String> validateBeforeConfirm(DynamicObject[] bizBills) {
        DynamicObject bizBill = bizBills[0];
        Long bizBillId = bizBill.getLong("id");
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(2);
        boolean existSurety = SuretyService.existSuretyFromDb(bizBill, true);
        if (existSurety) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u751f\u6210\u7684\u4fdd\u8bc1\u91d1\u5355\u636e\u3002", (String)"SuretyService_0", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        String entityName = bizBill.getDataEntityType().getName();
        if ("cdm_payablebill_ap_manual".equals(entityName) || "cdm_payablebill".equals(entityName)) {
            DynamicObject accepterFinOrg;
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)entityName, (String)"id,draftbilltype,acceptercompany,accepterfinorg,entry_surety", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizBill.getLong("id"))});
            String settlementType = payBills[0].getDynamicObject("draftbilltype").getString("settlementtype");
            if ("5".equals(settlementType)) {
                DynamicObject accepterCompany = payBills[0].getDynamicObject("acceptercompany");
                if (EmptyUtil.isEmpty((DynamicObject)accepterCompany)) {
                    errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5f00\u7968\u5b58\u5165\u4fdd\u8bc1\u91d1\u8bf7\u5148\u586b\u5199\u627f\u5151\u4eba\u5168\u79f0\u3002", (String)"SuretyService_4", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
                    return errorMsgMap;
                }
            } else if ("6".equals(settlementType) && EmptyUtil.isEmpty((DynamicObject)(accepterFinOrg = payBills[0].getDynamicObject("accepterfinorg")))) {
                errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5f00\u7968\u5b58\u5165\u4fdd\u8bc1\u91d1\u8bf7\u5148\u586b\u5199\u627f\u5151\u4eba\u5168\u79f0\u3002", (String)"SuretyService_4", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
                return errorMsgMap;
            }
        } else if ("lc_lettercredit".equals(entityName)) {
            DynamicObject letterCredit = QueryServiceHelper.queryOne((String)entityName, (String)"id,guarantee,promisrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizBill.getLong("id"))});
            String guaWay = letterCredit.getString("guarantee");
            List guaWayList = Arrays.stream(guaWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
            BigDecimal proMisRate = letterCredit.getBigDecimal("promisrate");
            if (!guaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) || EmptyUtil.isEmpty((BigDecimal)proMisRate) || proMisRate.compareTo(Constants.ZERO) == 0) {
                errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u53ea\u6709\u62c5\u4fdd\u65b9\u5f0f\u5305\u542b\u4fdd\u8bc1\u91d1\uff0c\u4e14\u4fdd\u8bc1\u91d1\u6bd4\u4f8b\u5927\u4e8e0\uff0c\u624d\u5141\u8bb8\u5b58\u5165\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyService_6", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
                return errorMsgMap;
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<Long, String> validateBeforeGenerate(DynamicObject[] bizBills) {
        Map<Long, String> suretyExist = this.isSuretyExist(bizBills);
        if (EmptyUtil.isNoEmpty(suretyExist)) {
            return suretyExist;
        }
        return Collections.emptyMap();
    }

    private Map<Long, String> isSuretyExist(DynamicObject[] bizBills) {
        DynamicObject suretyBill;
        DynamicObject bizBill = bizBills[0];
        Long bizBillId = bizBill.getLong("id");
        DynamicObjectCollection suretyEntry = bizBill.getDynamicObjectCollection("entry_surety");
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(2);
        if (suretyEntry.size() > 1) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u53ea\u80fd\u5173\u8054\u4e00\u7b14\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyService_3", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyEntry)) {
            return Collections.emptyMap();
        }
        DynamicObject dynamicObject = ((DynamicObject)suretyEntry.get(0)).getDynamicObject("suretybill");
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return Collections.emptyMap();
        }
        Object pkValue = dynamicObject.getPkValue();
        if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)bizBill.getDataEntityType().getName())) {
            boolean exists;
            QFilter qFilter = new QFilter("id", "=", pkValue).and("entry_credit", "is not null", null).and(String.join((CharSequence)".", "entry_credit", "creditbillid", "isclose"), "=", (Object)false);
            if (EmptyUtil.isNoEmpty((Long)bizBillId)) {
                qFilter.and("entry_credit.creditbillid", "!=", (Object)bizBillId);
            }
            if (exists = QueryServiceHelper.exists((String)"fbd_suretybill", (QFilter[])new QFilter[]{qFilter})) {
                errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u989d\u5ea6\u4fdd\u8bc1\u91d1\u5df2\u88ab\u5176\u5b83\u5355\u636e\u5173\u8054\uff0c\u8bf7\u66f4\u6362\u3002", (String)"SuretyService_1", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
                return errorMsgMap;
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)}))) && SuretyBizStatusEnum.SURETY_END.getValue().equals(suretyBill.getString("bizstatus"))) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u8be5\u7b14\u4fdd\u8bc1\u91d1\u5df2\u5168\u90e8\u5b58\u51fa\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u3002", (String)"SuretyService_5", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public void cancelLink(DynamicObject[] bizBills) {
        SuretyHelper.cancelSuretiesLink((DynamicObject[])bizBills);
    }

    @Override
    public Map<Long, BigDecimal> calIntForCdm(List<SuretyEntryIntInfo> paramList) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(10);
        if (EmptyUtil.isEmpty(paramList)) {
            return result;
        }
        Set suretyBillIds = paramList.stream().map(s -> s.getSuretyBillId()).collect(Collectors.toSet());
        DynamicObject[] suretyBillArr = TmcDataServiceHelper.load((Object[])suretyBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fbd_suretybill"));
        Map<Long, DynamicObject> suretyBillMap = Arrays.stream(suretyBillArr).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (SuretyEntryIntInfo param : paramList) {
            IntBillInfo intBill = SuretyIntCalcHelper.callInt((DynamicObject)suretyBillMap.get(param.getSuretyBillId()), (Date)param.getEndDate(), (BigDecimal)param.getRepayAmt());
            if (intBill == null) continue;
            result.put(param.getSuretyBillId(), intBill.getAmount());
        }
        return result;
    }

    @Override
    public boolean getIsInterestRepay(Long suretyBillId) {
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (String)"fbd_suretybill", (String)"revenueway");
        return EmptyUtil.isNoEmpty((DynamicObject)suretyBill) && RevenueWayEnum.NOREVENUE.getValue().equals(suretyBill.getString("revenueway"));
    }

    @Override
    public void writeBackPayBill(String entityName, String entityNo, String srcBillNo) {
        QFilter qFilter;
        Object[] releaseBills;
        DynamicObject srcEntity = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)entityNo)});
        DynamicObject payBill = TmcBotpHelper.getTargetBill((String)entityName, (Object)srcEntity.getPkValue(), (String)"cas_paybill");
        if (EmptyUtil.isNoEmpty((DynamicObject)payBill) && EmptyUtil.isNoEmpty((Object[])(releaseBills = TmcDataServiceHelper.load((String)"fbd_suretyreleasebill", (String)"id,entry", (QFilter[])(qFilter = new QFilter("entry.debtbillno", "=", (Object)srcBillNo)).toArray())))) {
            for (Object releaseBill : releaseBills) {
                DynamicObjectCollection entrys = releaseBill.getDynamicObjectCollection("entry");
                this.writeBackPayBillEntry(entrys, srcBillNo, payBill);
            }
            TmcDataServiceHelper.save((DynamicObject[])releaseBills);
        }
    }

    @Override
    public void updateDebtStatus(SuretyDebtEntryStatusInfo param) {
        String selectProps = "entry,entry.debtbillid,entry.debttype,entry.suretystatus";
        QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)param.getId());
        qFilter.and("entry.debttype", "=", (Object)param.getEntityName());
        DynamicObject[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)selectProps, (QFilter[])qFilter.toArray());
        logger.info("debtbillid : " + param.getId() + "\u53ef\u66f4\u65b0\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u636e\uff1a" + suretyBills.length + "\u6761\u8bb0\u5f55");
        this.doUpdateDebtStatus(suretyBills, param);
        DynamicObject[] suretyReleaseBills = TmcDataServiceHelper.load((String)"fbd_suretyreleasebill", (String)selectProps, (QFilter[])qFilter.toArray());
        logger.info("debtbillid : " + param.getId() + "\u53ef\u66f4\u65b0\u4fdd\u8bc1\u91d1\u5b58\u51fa\u5355\u636e\uff1a" + suretyReleaseBills.length + "\u6761\u8bb0\u5f55");
        this.doUpdateDebtStatus(suretyReleaseBills, param);
    }

    private void doUpdateDebtStatus(DynamicObject[] bizBills, SuretyDebtEntryStatusInfo param) {
        String debtStatus = this.transferDebtStatus(param);
        for (DynamicObject bizBill : bizBills) {
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long debtBillId = entry.getLong("debtbillid");
                String debtType = entry.getString("debttype");
                if (!debtType.equals(param.getEntityName()) || !debtBillId.equals(param.getId())) continue;
                entry.set("suretystatus", (Object)debtStatus);
            }
        }
        TmcDataServiceHelper.save((DynamicObject[])bizBills);
    }

    private String transferDebtStatus(SuretyDebtEntryStatusInfo param) {
        String draftStatus;
        String debtStatus = SuretyStatusEnum.GUARANTING.getValue();
        if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(param.getEntityName()) && "done_close".equals(param.getBizStatus())) {
            debtStatus = SuretyStatusEnum.SETTLED.getValue();
        } else if (DebtBillTypeEnum.CDM_PAYABLEBILL.getValue().equals(param.getEntityName())) {
            String draftStatus2 = param.getBizStatus();
            if ("payoffed".equals(draftStatus2) || "sendback".equals(draftStatus2)) {
                debtStatus = SuretyStatusEnum.SETTLED.getValue();
            }
        } else if (DebtBillTypeEnum.GM_LETTEROFGUARANTEE.getValue().equals(param.getEntityName()) && ("cancelled".equals(draftStatus = param.getBizStatus()) || "claimed".equals(draftStatus))) {
            debtStatus = SuretyStatusEnum.SETTLED.getValue();
        }
        logger.info("\u8f6c\u6362\u503a\u52a1\u5355\u636e\u72b6\u6001--->> \u8f6c\u6362\u524d\u72b6\u6001\uff1a" + param.getBizStatus() + ", \u8f6c\u6362\u540e\u72b6\u6001\uff1a" + debtStatus);
        return debtStatus;
    }

    private void writeBackPayBillEntry(DynamicObjectCollection entrys, String srcBillNo, DynamicObject payBill) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        for (DynamicObject entry : entrys) {
            String debtBillNo = entry.getString("debtbillno");
            if (!srcBillNo.equals(debtBillNo)) continue;
            entry.set("paybill", payBill.getPkValue());
        }
    }

    public static void saveSurety(List<SuretyBean> suretyList) {
        ArrayList<DynamicObject> suretyDOList = new ArrayList<DynamicObject>(suretyList.size());
        for (SuretyBean suretyBean : suretyList) {
            if (EmptyUtil.isNoEmpty((Long)suretyBean.getSuretyBillId())) {
                DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBean.getSuretyBillId(), (String)"fbd_suretybill");
                SuretyService.newEntry(suretyBean, suretyBill);
                suretyDOList.add(suretyBill);
                continue;
            }
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"fbd_suretybill");
            newDO.set("org", (Object)suretyBean.getOrgId());
            newDO.set("finorginfo", (Object)suretyBean.getFinOrgId());
            newDO.set("investorgtype", (Object)suretyBean.getInvestOrgType());
            newDO.set("finorgother", (Object)suretyBean.getFinOrgOther());
            newDO.set("surplusamount", (Object)suretyBean.getSurplusAmount());
            newDO.set("settleaccount", (Object)suretyBean.getSettleAccountId());
            newDO.set("currency", (Object)suretyBean.getCurrencyId());
            newDO.set("amount", (Object)suretyBean.getAmount());
            newDO.set("intdate", (Object)suretyBean.getIntDate());
            newDO.set("term", (Object)suretyBean.getTerm());
            newDO.set("expiredate", (Object)suretyBean.getExpireDate());
            newDO.set("basis", (Object)BasisEnum.Actual_360.getValue());
            newDO.set("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
            newDO.set("bizdate", (Object)DateUtils.truncateDate((Date)new Date()));
            newDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            newDO.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDO.set("enable", (Object)false);
            SuretyService.newEntry(suretyBean, newDO);
            suretyDOList.add(newDO);
        }
        if (EmptyUtil.isNoEmpty(suretyDOList)) {
            SaveServiceHelper.save((DynamicObject[])suretyDOList.toArray(new DynamicObject[0]));
        }
    }

    public static void saveSuretyCredit(List<SuretyBean> suretyList) {
        ArrayList<DynamicObject> suretyDOList = new ArrayList<DynamicObject>(suretyList.size());
        for (SuretyBean suretyBean : suretyList) {
            if (EmptyUtil.isNoEmpty((Long)suretyBean.getSuretyBillId())) {
                DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBean.getSuretyBillId(), (String)"fbd_suretybill");
                SuretyService.newEntryCredit(suretyBean, suretyBill);
                suretyDOList.add(suretyBill);
                continue;
            }
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"fbd_suretybill");
            newDO.set("org", (Object)suretyBean.getOrgId());
            newDO.set("finorginfo", (Object)suretyBean.getFinOrgId());
            newDO.set("investorgtype", (Object)suretyBean.getInvestOrgType());
            newDO.set("finorgother", (Object)suretyBean.getFinOrgOther());
            newDO.set("surplusamount", (Object)suretyBean.getSurplusAmount());
            newDO.set("settleaccount", (Object)suretyBean.getSettleAccountId());
            newDO.set("currency", (Object)suretyBean.getCurrencyId());
            newDO.set("amount", (Object)suretyBean.getAmount());
            newDO.set("intdate", (Object)suretyBean.getIntDate());
            newDO.set("term", (Object)suretyBean.getTerm());
            newDO.set("expiredate", (Object)suretyBean.getExpireDate());
            newDO.set("basis", (Object)BasisEnum.Actual_360.getValue());
            newDO.set("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
            newDO.set("bizdate", (Object)DateUtils.truncateDate((Date)new Date()));
            newDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            newDO.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDO.set("enable", (Object)false);
            SuretyService.newEntryCredit(suretyBean, newDO);
            suretyDOList.add(newDO);
        }
        if (EmptyUtil.isNoEmpty(suretyDOList)) {
            SaveServiceHelper.save((DynamicObject[])suretyDOList.toArray(new DynamicObject[0]));
        }
    }

    private static void newEntry(SuretyBean suretyBean, DynamicObject suretyBill) {
        if (suretyBean.getSrcBillType().equals("cdm_payablebill_ap_manual") && suretyBean.isMultiEntry()) {
            SuretyService.setMultiEntry(suretyBean, suretyBill);
        } else {
            SuretyService.setSingleEntry(suretyBean, suretyBill);
        }
    }

    private static void setMultiEntry(SuretyBean suretyBean, DynamicObject suretyBill) {
        DynamicObjectCollection entry = suretyBill.getDynamicObjectCollection("entry");
        for (SuretyEntryBean suretyEntryBean : suretyBean.getSuretyEntries()) {
            DynamicObject row = entry.addNew();
            row.set("debttype", (Object)suretyEntryBean.getSrcBillType());
            row.set("debtbillno", (Object)suretyEntryBean.getSrcBillNo());
            row.set("bizno", (Object)suretyEntryBean.getBizNo());
            row.set("debtbillid", (Object)suretyEntryBean.getSrcBillId());
            row.set("counterparty", (Object)suretyEntryBean.getDebtFinOrgId());
            row.set("debtcurrency", (Object)suretyEntryBean.getDebtCurrencyId());
            row.set("debtamt", (Object)suretyEntryBean.getDebtAmount());
            row.set("debtstartdate", (Object)suretyEntryBean.getDebtStartDate());
            row.set("debtenddate", (Object)suretyEntryBean.getDebtEndDate());
            row.set("suretysource", (Object)suretyEntryBean.getSuretySource());
            row.set("suretystatus", (Object)suretyEntryBean.getBizStatus());
            row.set("applybillid", (Object)suretyEntryBean.getApplyBillId());
            row.set("applybillno", (Object)suretyEntryBean.getApplyBillNo());
            row.set("suretyamount", (Object)suretyEntryBean.getSuretyAmount());
            row.set("credit", (Object)suretyEntryBean.getCreditId());
            row.set("creditcurrency", (Object)suretyEntryBean.getCreditCurrencyId());
            row.set("creditamount", (Object)suretyEntryBean.getCreditAmt());
        }
    }

    private static void setSingleEntry(SuretyBean suretyBean, DynamicObject suretyBill) {
        DynamicObject debitEntry;
        DynamicObjectCollection entry = suretyBill.getDynamicObjectCollection("entry");
        List<Object> debitEntries = new ArrayList(1);
        if (suretyBean.getSrcBillType().equals("cdm_payablebill") && EmptyUtil.isNoEmpty((Long)suretyBean.getBizBillSrcId())) {
            debitEntries = entry.stream().filter(d -> d.getLong("applybillid") == suretyBean.getBizBillSrcId().longValue()).collect(Collectors.toList());
        }
        if (EmptyUtil.isNoEmpty(debitEntries)) {
            debitEntry = (DynamicObject)debitEntries.get(0);
        } else {
            debitEntry = entry.addNew();
            debitEntry.set("debtcurrency", (Object)suretyBean.getDebtCurrencyId());
            debitEntry.set("suretysource", (Object)suretyBean.getSuretySource());
            debitEntry.set("suretystatus", (Object)suretyBean.getBizStatus());
        }
        debitEntry.set("debttype", (Object)suretyBean.getSrcBillType());
        debitEntry.set("debtbillno", (Object)suretyBean.getSrcBillNo());
        debitEntry.set("bizno", (Object)suretyBean.getBizNo());
        debitEntry.set("debtbillid", (Object)suretyBean.getSrcBillId());
        debitEntry.set("counterparty", (Object)suretyBean.getDebtFinOrgId());
        debitEntry.set("debtstartdate", (Object)suretyBean.getDebtStartDate());
        debitEntry.set("debtenddate", (Object)suretyBean.getDebtEndDate());
        debitEntry.set("debtamt", (Object)suretyBean.getDebtAmount());
        debitEntry.set("suretyamount", (Object)suretyBean.getSuretyMoney());
        if (EmptyUtil.isNoEmpty((Long)suretyBean.getCreditId())) {
            debitEntry.set("credit", (Object)suretyBean.getCreditId());
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("creditlimit", "=", (Object)suretyBean.getCreditId())).and(new QFilter("sourcebillno", "=", (Object)suretyBean.getSrcBillNo()));
            DynamicObject creditUse = TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"currency,realamt", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                debitEntry.set("creditcurrency", creditUse.getDynamicObject("currency").getPkValue());
                debitEntry.set("creditamount", (Object)creditUse.getBigDecimal("realamt"));
            }
        }
    }

    private static void newEntryCredit(SuretyBean suretyBean, DynamicObject suretyBill) {
        DynamicObjectCollection entry = suretyBill.getDynamicObjectCollection("entry_credit");
        DynamicObject row = entry.addNew();
        row.set("creditbillid", (Object)suretyBean.getSrcBillId());
        row.set("creditsource", (Object)suretyBean.getCreditSource());
    }

    private void confirmDebitSurety(DynamicObject[] dataEntities, String formId) {
        DynamicObject srcBill = dataEntities[0];
        String debitType = SuretyService.getDebitType(formId, srcBill);
        Long bizId = srcBill.getLong("id");
        QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)bizId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"org,billno,billstatus,enable,bizstatus", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)bizId, (String)srcBill.getDataEntityType().getName());
            this.confirmDebitSuretyBill(bizBill, debitType);
            suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"org,billno,billstatus,enable,bizstatus", (QFilter[])new QFilter[]{qFilter});
        }
        for (Object suretyBill : suretyBills) {
            if (suretyBill.getBoolean("enable")) continue;
            suretyBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fbd_suretybill", (DynamicObject)suretyBill, (String)suretyBill.getDynamicObject("org").getString("id"), (String)""));
            suretyBill.set("enable", (Object)true);
            suretyBill.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_ING.getValue());
        }
        TmcDataServiceHelper.save((DynamicObject[])suretyBills);
    }

    private static String getDebitType(String formId, DynamicObject srcBill) {
        return EmptyUtil.isEmpty((String)formId) ? srcBill.getDataEntityType().getName() : formId;
    }

    private void confirmCreditSurety(DynamicObject[] dataEntities) {
        String entityName = dataEntities[0].getDataEntityType().getName();
        Long bizId = dataEntities[0].getLong("id");
        QFilter qFilter = new QFilter("entry_credit.creditbillid", "=", (Object)bizId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)SURETY_PROP, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)bizId, (String)entityName);
            this.confirmSuretyCreditBill(bizBill);
            suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)SURETY_PROP, (QFilter[])new QFilter[]{qFilter});
        }
        for (Object suretyBill : suretyBills) {
            if (suretyBill.getBoolean("enable")) continue;
            suretyBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fbd_suretybill", (DynamicObject)suretyBill, (String)suretyBill.getDynamicObject("org").getString("id"), (String)""));
            suretyBill.set("enable", (Object)true);
            suretyBill.set("bizstatus", (Object)SuretyBizStatusEnum.SURETY_ING.getValue());
        }
        TmcDataServiceHelper.save((DynamicObject[])suretyBills);
    }

    private static boolean existSuretyFromDb(DynamicObject bizBill, boolean enable) {
        if (EmptyUtil.isEmpty((DynamicObject)bizBill)) {
            return false;
        }
        Long bizBillId = bizBill.getLong("id");
        if (EmptyUtil.isEmpty((Long)bizBillId)) {
            return false;
        }
        QFilter idFilter = new QFilter("enable", "=", (Object)enable);
        if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)bizBill.getDataEntityType().getName())) {
            idFilter.and("entry_credit.creditbillid", "=", (Object)bizBillId);
            return TmcDataServiceHelper.exists((String)"fbd_suretybill", (QFilter[])idFilter.toArray());
        }
        idFilter = new QFilter("entry.debtbillid", "=", (Object)bizBillId);
        boolean hasExists = TmcDataServiceHelper.exists((String)"fbd_suretybill", (QFilter[])idFilter.toArray());
        if (!hasExists) {
            idFilter = new QFilter("id", "=", (Object)bizBillId);
            DynamicObject payableBill = QueryServiceHelper.queryOne((String)"cdm_payablebill", (String)"sourcebillid", (QFilter[])new QFilter[]{idFilter});
            if (EmptyUtil.isEmpty((DynamicObject)payableBill)) {
                return false;
            }
            Long entryId = payableBill.getLong("sourcebillid");
            idFilter = new QFilter("entryentity.id", "=", (Object)entryId);
            DynamicObject payableBillApply = QueryServiceHelper.queryOne((String)"cdm_payablebill_ap_manual", (String)"id", (QFilter[])new QFilter[]{idFilter});
            if (EmptyUtil.isEmpty((DynamicObject)payableBillApply)) {
                return false;
            }
            idFilter = new QFilter("entry.debtbillid", "=", (Object)payableBillApply.getLong("id"));
            idFilter.and("enable", "=", (Object)enable);
            hasExists = TmcDataServiceHelper.exists((String)"fbd_suretybill", (QFilter[])idFilter.toArray());
        }
        return hasExists;
    }

    static {
        APPROVE_BILL_LIST.add("lc_lettercredit");
        APPROVE_BILL_LIST.add("cdm_payablebill");
        APPROVE_BILL_LIST.add("gm_letterofguarantee");
        APPROVE_BILL_LIST.add("cdm_payablebill_ap_manual");
        APPROVE_BILL_LIST.add("cfm_creditlimit");
        APPROVE_BILL_LIST.add("cfm_loancontractbill");
        APPROVE_BILL_LIST.add("fl_leasecontractbill");
    }
}

