/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class IntermediaryOrgUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(IntermediaryOrgUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                result.setLog("start upgrade IntermediaryOrgUpgradeService");
                this.bondPlanUpgrade();
                result.setLog("end upgrade IntermediaryOrgUpgradeService");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
                logger.info(result.getErrorInfo());
            }
        }
        return result;
    }

    private void bondPlanUpgrade() {
        String querySqlInit;
        DataSet underWriterInit;
        HashSet<Object> funderWriterIds = new HashSet<Object>(16);
        String querySql = "select funderwriterid from t_cfm_loancontractbill_uw where funderwriterid is not null and funderwriterid > 0";
        DataSet underWriter = DB.queryDataSet((String)"upgradeWorkLoanContract", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (!underWriter.isEmpty()) {
            for (Row row : underWriter) {
                Long funderWriterId = row.getLong("funderwriterid");
                funderWriterIds.add(funderWriterId);
            }
        }
        if (!(underWriterInit = DB.queryDataSet((String)"upgradeWorkLoanContractInit", (DBRoute)DBRouteConst.TMC, (String)(querySqlInit = "select funderwriterid from t_cfm_initbill_uw where funderwriterid is not null and funderwriterid > 0"))).isEmpty()) {
            for (Row row : underWriterInit) {
                Long funderWriterId = row.getLong("funderwriterid");
                funderWriterIds.add(funderWriterId);
            }
        }
        if (funderWriterIds.isEmpty()) {
            return;
        }
        StringJoiner sj = new StringJoiner(",");
        funderWriterIds.forEach(v -> sj.add(v.toString()));
        querySql = String.format("select A.fid fid,A.fnumber fnumber,B.fname fname,B.fpkid fpkid from t_bd_finorginfo A left join t_bd_finorginfo_l B on A.fid = B.fid and flocaleid = 'zh_CN' where A.fid in (%s)", sj.toString());
        DataSet finOrgInfos = DB.queryDataSet((String)"queryFinOrg", (DBRoute)DBRouteConst.SYS, (String)querySql);
        HashMap<Long, String> finMap = new HashMap<Long, String>(16);
        for (Row row : finOrgInfos) {
            Long fid = row.getLong("fid");
            String fnumber = row.getString("fnumber");
            String fname = row.getString("fname");
            String string = row.getString("fpkid");
            StringBuilder finBuilder = new StringBuilder();
            finBuilder.append(fnumber).append(",").append(fname).append(",").append(string);
            finMap.put(fid, finBuilder.toString());
        }
        DynamicObjectCollection ratingAgencyIds = QueryServiceHelper.query((String)"tbd_ratingagency", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", finMap.keySet())});
        Map idToRatingAgency = ratingAgencyIds.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (a, b) -> a));
        ArrayList<Object[]> upgradeData1 = new ArrayList<Object[]>(finMap.size());
        ArrayList<Object[]> upgradeData2 = new ArrayList<Object[]>(finMap.size());
        for (Map.Entry entry : finMap.entrySet()) {
            Long fid = (Long)entry.getKey();
            if (idToRatingAgency.get(fid) != null) continue;
            String s = (String)entry.getValue();
            String[] finInfo = s.split(",");
            Object[] params1 = new Object[]{fid, "C", fid, "finorg_" + finInfo[0], "underwriter", finInfo[1], fid, "1"};
            upgradeData1.add(params1);
            Object[] params2 = new Object[]{finInfo[2], fid, "zh_CN", finInfo[1]};
            upgradeData2.add(params2);
        }
        String insertSQL = "insert into t_tbd_ratingagency(fid, fstatus, fmasterid, fnumber, forgtype, fname, funderwritername, fenable) values(?, ?, ?, ?, ?, ?, ?, ?)";
        if (upgradeData1.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)insertSQL, upgradeData1);
        }
        String string = "insert into t_tbd_ratingagency_l(fpkid, fid, flocaleid, fname) values(?, ?, ?, ?)";
        if (upgradeData2.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)string, upgradeData2);
        }
    }
}

