/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.helper.IntSegmentHelper;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class SuretyHelper {
    private static final String CREDIT_ID_PROP = String.join((CharSequence)".", "entry_credit", "creditbillid");
    private static final String DEBIT_ID_PROP = String.join((CharSequence)".", "entry", "debtbillid") + "," + String.join((CharSequence)".", "entry", "debttype");
    private static final List<String> rewriteBill = Arrays.asList("cfm_creditlimit", "lc_lettercredit");
    public static final BigDecimal RATE_MAX = BigDecimal.valueOf(Math.pow(10.0, 13.0));

    private SuretyHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static IntBillInfo calcReleaseIntNew(DynamicObject releaseBill) {
        DynamicObject suretyBillF7 = releaseBill.getDynamicObject("suretybill");
        Date startDate = SuretyIntCalcHelper.getBeginIntDate(suretyBillF7);
        Date releaseDate = releaseBill.getDate("releasedate");
        if (releaseDate.compareTo(startDate) <= 0) {
            return SuretyHelper.buildEmptyIntBill();
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = SuretyHelper.getBizBill(releaseBill);
        request.setBizBill(bizBill);
        Set<RateInfo> rateSet = SuretyHelper.getRateList(releaseBill, bizBill);
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return SuretyHelper.buildEmptyIntBill();
        }
        SuretyHelper.calOverDatePartInt(releaseBill, bizBill, request, stragety, intBillInfo);
        SuretyHelper.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    private static void calOverDatePartInt(DynamicObject releaseBill, BizBillInfo bizBill, IntCalRequest request, IIntCallStragety stragety, IntBillInfo intBillInfo) {
        DynamicObject suretyBillF7 = releaseBill.getDynamicObject("suretybill");
        Date expireDate = suretyBillF7.getDate("expiredate");
        Date redeemDate = releaseBill.getDate("releasedate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && redeemDate.compareTo(expireDate) > 0) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
            bizBill.setBeginDate(expireDate);
            bizBill.setEndDate(redeemDate);
            HashSet<RateInfo> set = new HashSet<RateInfo>(2);
            SuretyHelper.addElementForSet(set, expireDate, releaseBill.getBigDecimal("demandrate"));
            request.setRateList(set);
            IntBillInfo overDateIntBill = stragety.callInt(request);
            if (overDateIntBill == null) {
                return;
            }
            intBillInfo.setEndDate(bizBill.getEndDate());
            intBillInfo.getDetails().addAll(overDateIntBill.getDetails());
            intBillInfo.setAmount(intBillInfo.getAmount().add(overDateIntBill.getAmount()));
        }
    }

    private static IntBillInfo buildEmptyIntBill() {
        IntBillInfo intBillInfo = new IntBillInfo();
        intBillInfo.setAmount(BigDecimal.ZERO);
        return intBillInfo;
    }

    private static BizBillInfo getBizBill(DynamicObject releaseBill) {
        BizBillInfo bizBill = new BizBillInfo();
        DynamicObject suretyBillF7 = releaseBill.getDynamicObject("suretybill");
        DynamicObject productFactory = suretyBillF7.getDynamicObject("productfactory");
        bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"fbd_investmodel_surety");
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
            IntCalMethodEnum intCalMethod = IntCalMethodEnum.valueOf((String)productFactory.getString("intcalmethod"));
            bizBill.setIntCalMethod(intCalMethod);
            String intheadtailrule = productFactory.getString("intheadtailrule");
            bizBill.setHtRule(IntHTRuleEnum.valueOf((String)intheadtailrule));
        }
        Date startDate = SuretyIntCalcHelper.getBeginIntDate(suretyBillF7);
        bizBill.setBeginDate(startDate);
        bizBill.setEndDate(releaseBill.getDate("releasedate"));
        bizBill.setBasis(BasisEnum.getEnum((String)suretyBillF7.getString("basis")));
        bizBill.setLoanAmount(releaseBill.getBigDecimal("amount"));
        bizBill.setCurrencyId(releaseBill.getDynamicObject("currency").getLong("id"));
        return bizBill;
    }

    private static Set<RateInfo> getRateList(DynamicObject releaseBill, BizBillInfo bizBill) {
        Set<RateInfo> set = new HashSet<RateInfo>(8);
        DynamicObject suretyBillF7 = releaseBill.getDynamicObject("suretybill");
        Date expireDate = suretyBillF7.getDate("expiredate");
        String intType = suretyBillF7.getString("interesttype");
        Date startDate = SuretyIntCalcHelper.getBeginIntDate(suretyBillF7);
        Date releaseDate = releaseBill.getDate("releasedate");
        if (EmptyUtil.isEmpty((Object)expireDate) || releaseDate.compareTo(expireDate) < 0) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
            SuretyHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("demandrate"));
        } else if (releaseDate.compareTo(expireDate) == 0) {
            if (InterestTypeEnum.isFixed((String)intType)) {
                SuretyHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("interestrate"));
            } else {
                set = SuretyHelper.getRateInfoWhenFloat(suretyBillF7, startDate, bizBill.getEndDate());
            }
        } else {
            bizBill.setEndDate(expireDate);
            if (InterestTypeEnum.isFixed((String)intType)) {
                SuretyHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("interestrate"));
            } else {
                set = SuretyHelper.getRateInfoWhenFloat(suretyBillF7, startDate, bizBill.getEndDate());
            }
        }
        return set;
    }

    private static void addElementForSet(Set<RateInfo> set, Date startDate, BigDecimal rate) {
        RateInfo rateInfo = new RateInfo();
        rateInfo.setEffectiveDate(startDate);
        rateInfo.setRate(rate);
        set.add(rateInfo);
    }

    private static Set<RateInfo> getRateInfoWhenFloat(DynamicObject deposit, Date beginDate, Date endDate) {
        String referRateNumber = Optional.ofNullable(deposit.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
        Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)beginDate, (Date)endDate);
        if (CollectionUtils.isEmpty((Map)rateDateVal)) {
            throw SuretyHelper.refferRateNotExistException(referRateNumber, beginDate, endDate);
        }
        String rateSign = deposit.getString("ratesign");
        BigDecimal rateFloatPoint = deposit.getBigDecimal("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>(rateDateVal.size());
        for (Map.Entry entry : rateDateVal.entrySet()) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)entry.getKey());
            info.setRate(((BigDecimal)entry.getValue()).add(rateFloat));
            rateSet.add(info);
        }
        return rateSet;
    }

    private static KDBizException refferRateNotExistException(String referRateNumber, Date beginDate, Date endDate) {
        if (StringUtils.isEmpty((CharSequence)referRateNumber)) {
            return SuretyHelper.refferRateNotExistException();
        }
        return new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u53c2\u8003\u5229\u7387%1$s\u5728%2$s\u81f3%3$s\u7684\u6570\u636e\u3002", (String)"SuretyHelper_2", (String)"tmc-fbd-common", (Object[])new Object[0]), referRateNumber, DateUtils.formatString((Date)beginDate, (String)"yyyy/MM/dd"), DateUtils.formatString((Date)endDate, (String)"yyyy/MM/dd")));
    }

    @Deprecated
    public static IntBillInfo calcReleaseInt(DynamicObject releaseBill) {
        Date releaseDate;
        Date startDate;
        Triple<Date, Date, Integer> dateTriple;
        IntBillInfo intBillInfo = new IntBillInfo();
        DynamicObject suretyBillF7 = releaseBill.getDynamicObject("suretybill");
        if (EmptyUtil.isEmpty((DynamicObject)suretyBillF7)) {
            intBillInfo.setAmount(BigDecimal.ZERO);
            intBillInfo.setDetails(Collections.emptyList());
            return intBillInfo;
        }
        DynamicObject productFactory = suretyBillF7.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"fbd_investmodel_surety");
        }
        if ((Integer)(dateTriple = SuretyHelper.reCalBeginEndDate(startDate = SuretyIntCalcHelper.getBeginIntDate(suretyBillF7), releaseDate = releaseBill.getDate("releasedate"), productFactory)).getRight() <= 0) {
            intBillInfo.setAmount(BigDecimal.ZERO);
            intBillInfo.setDetails(Collections.emptyList());
            return intBillInfo;
        }
        intBillInfo.setBizDate((Date)dateTriple.getLeft());
        intBillInfo.setBeginDate((Date)dateTriple.getLeft());
        intBillInfo.setEndDate((Date)dateTriple.getMiddle());
        RoundingMode roundMode = SuretyHelper.buildRoundingMode(productFactory);
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)suretyBillF7.getString("basis")));
        List<IntBillDetailInfo> detailInfos = SuretyHelper.buildIntDetailList(suretyBillF7, releaseBill, productFactory, dateTriple, yearDay, roundMode);
        intBillInfo.setDetails(detailInfos);
        BigDecimal totalAmt = detailInfos.stream().map(IntBillDetailInfo::getAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        intBillInfo.setAmount(totalAmt);
        SuretyHelper.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    private static List<IntBillDetailInfo> buildIntDetailList(DynamicObject suretyBillF7, DynamicObject releaseBill, DynamicObject productFactory, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode) {
        List<IntBillDetailInfo> detailInfos = new ArrayList<IntBillDetailInfo>();
        Date expireDate = suretyBillF7.getDate("expiredate");
        String intType = suretyBillF7.getString("interesttype");
        Date startDate = SuretyIntCalcHelper.getBeginIntDate(suretyBillF7);
        Date releaseDate = releaseBill.getDate("releasedate");
        if (EmptyUtil.isEmpty((Object)expireDate) || releaseDate.compareTo(expireDate) < 0) {
            IntBillDetailInfo detailInfo = SuretyHelper.buildSingleIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode, false);
            detailInfos.add(detailInfo);
        } else if (releaseDate.compareTo(expireDate) == 0) {
            if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
                IntBillDetailInfo detailInfo = SuretyHelper.buildSingleIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode, true);
                detailInfos.add(detailInfo);
            } else {
                detailInfos = SuretyHelper.buildListIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode);
            }
        } else if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
            dateTriple = SuretyHelper.reCalBeginEndDate(startDate, expireDate, productFactory);
            if ((Integer)dateTriple.getRight() > 0) {
                IntBillDetailInfo detailInfo1 = SuretyHelper.buildSingleIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode, true);
                detailInfos.add(detailInfo1);
            }
            if ((Integer)(dateTriple = SuretyHelper.reCalBeginEndDate(expireDate, releaseDate, productFactory)).getRight() > 0) {
                IntBillDetailInfo detailInfo2 = SuretyHelper.buildSingleIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode, false);
                detailInfos.add(detailInfo2);
            }
        } else {
            dateTriple = SuretyHelper.reCalBeginEndDate(startDate, expireDate, productFactory);
            if ((Integer)dateTriple.getRight() > 0) {
                detailInfos = SuretyHelper.buildListIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode);
            }
            if ((Integer)(dateTriple = SuretyHelper.reCalBeginEndDate(expireDate, releaseDate, productFactory)).getRight() > 0) {
                IntBillDetailInfo detailInfo = SuretyHelper.buildSingleIntBillDetailInfo(releaseBill, dateTriple, yearDay, roundMode, false);
                detailInfos.add(detailInfo);
            }
        }
        return detailInfos;
    }

    public static List<IntBillDetailInfo> buildListIntBillDetailInfo(DynamicObject releaseBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode) {
        DynamicObject suretyBillF7 = releaseBill.getDynamicObject("suretybill");
        String referRateNumber = Optional.ofNullable(suretyBillF7.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
        Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)((Date)dateTriple.getLeft()), (Date)((Date)dateTriple.getMiddle()));
        if (EmptyUtil.isEmpty((Object)rateDateVal)) {
            throw SuretyHelper.refferRateNotExistException();
        }
        String rateSign = suretyBillF7.getString("ratesign");
        BigDecimal rateFloatPoint = suretyBillF7.getBigDecimal("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        TreeMap referRateTree = new TreeMap(Date::compareTo);
        referRateTree.putAll(rateDateVal);
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>(referRateTree.size());
        for (Map.Entry entry : referRateTree.entrySet()) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)entry.getKey());
            info.setRate(((BigDecimal)entry.getValue()).add(rateFloat));
            rateSet.add(info);
        }
        List<IntBillDetailInfo> intDetailInfo = SuretyHelper.getSubRate(rateSet, (Date)dateTriple.getLeft(), (Date)dateTriple.getMiddle());
        BigDecimal releaseAmount = releaseBill.getBigDecimal("amount");
        intDetailInfo.forEach(r -> {
            r.setBasisDay(yearDay);
            r.setPrinciple(releaseAmount);
            r.setAmount(releaseAmount.multiply(r.getRate().divide(Constants.ONE_HUNDRED, 6, roundMode)).multiply(BigDecimal.valueOf(r.getDays())).divide(BigDecimal.valueOf(yearDay), 6, roundMode));
        });
        return intDetailInfo;
    }

    public static IntBillDetailInfo buildSingleIntBillDetailInfo(DynamicObject releaseBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode, boolean useFixedInt) {
        IntBillDetailInfo detailInfo = new IntBillDetailInfo();
        detailInfo.setBeginDate((Date)dateTriple.getLeft());
        detailInfo.setEndDate((Date)dateTriple.getMiddle());
        detailInfo.setDays(((Integer)dateTriple.getRight()).intValue());
        detailInfo.setBasisDay(yearDay);
        BigDecimal releaseAmount = releaseBill.getBigDecimal("amount");
        detailInfo.setPrinciple(releaseAmount);
        BigDecimal useInt = useFixedInt ? (EmptyUtil.isNoEmpty((BigDecimal)releaseBill.getBigDecimal("interestrate")) ? releaseBill.getBigDecimal("interestrate") : releaseBill.getBigDecimal("demandrate")) : releaseBill.getBigDecimal("demandrate");
        detailInfo.setRate(useInt);
        BigDecimal rateAmount = releaseAmount.multiply(useInt.divide(Constants.ONE_HUNDRED, 6, roundMode)).multiply(BigDecimal.valueOf(((Integer)dateTriple.getRight()).intValue())).divide(BigDecimal.valueOf(yearDay), 6, roundMode);
        detailInfo.setAmount(rateAmount);
        return detailInfo;
    }

    private static Triple<Date, Date, Integer> reCalBeginEndDate(Date startDate, Date endDate, DynamicObject productFactory) {
        IntHTRuleEnum intHTRuleEnum = Optional.ofNullable(productFactory).filter(r -> "cash".equals(r.getString("profittype"))).map(r -> IntHTRuleEnum.valueOf((String)r.getString("intheadtailrule"))).orElse(IntHTRuleEnum.headnotail);
        switch (intHTRuleEnum) {
            case headnotail: {
                endDate = DateUtils.getLastDay((Date)endDate, (int)1);
                break;
            }
            case noheadnotail: {
                startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                endDate = DateUtils.getLastDay((Date)endDate, (int)1);
                break;
            }
            case noheadtail: {
                startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                break;
            }
        }
        return Triple.of((Object)startDate, (Object)endDate, (Object)DateUtils.getDiffDays((Date)startDate, (Date)endDate));
    }

    public static RoundingMode buildRoundingMode(DynamicObject productFactory) {
        RoundingMode roundMode = RoundingMode.HALF_UP;
        String intRoundRule = Optional.ofNullable(productFactory).map(r -> r.getString("introundrule")).orElse("");
        if (StringUtils.equals((CharSequence)RoundRuleEnum.give.getValue(), (CharSequence)intRoundRule)) {
            roundMode = RoundingMode.FLOOR;
        } else if (StringUtils.equals((CharSequence)RoundRuleEnum.carry.getValue(), (CharSequence)intRoundRule)) {
            roundMode = RoundingMode.CEILING;
        }
        return roundMode;
    }

    public static List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        List detailList = IntSegmentHelper.getSubRate(rateList, (Date)beginDate, (Date)endDate);
        return IntSegmentHelper.orderAGenEndDateAndDays((List)detailList, (Date)endDate);
    }

    public static KDBizException refferRateNotExistException() {
        return new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"SuretyHelper_0", (String)"tmc-fbd-common", (Object[])new Object[0]));
    }

    private static void validateIntMaxValue(IntBillInfo intBillInfo) {
        if (intBillInfo.getAmount().compareTo(RATE_MAX) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d4b\u7b97\u672a\u6765\u6536\u76ca\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuretyHelper_1", (String)"tmc-fbd-common", (Object[])new Object[0]));
        }
    }

    public static void showEntry(IFormView view, IDataModel model) {
        DynamicObject investVarieties = model.getDataEntity().getDynamicObject("investvarieties");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)model.getEntryEntity("entry_credit")) || EmptyUtil.isNoEmpty((DynamicObject)investVarieties) && investVarieties.getBoolean("islimitsurety")) {
            view.setVisible(Boolean.valueOf(false), new String[]{"fs_debtinfo"});
            view.setVisible(Boolean.valueOf(true), new String[]{"fs_creditinfo"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"fs_creditinfo"});
            view.setVisible(Boolean.valueOf(true), new String[]{"fs_debtinfo"});
        }
    }

    public static void writeBackIsSurety(DynamicObject suretyBill, Map<String, List<Long>> isSuretyOnMap, Map<String, List<Long>> isSuretyOffMap) {
        if (suretyBill.getDynamicObject("investvarieties").getBoolean("islimitsurety")) {
            SuretyHelper.writeBackCreditLimitIsSurety(suretyBill, isSuretyOnMap, isSuretyOffMap);
        } else {
            SuretyHelper.writeBackDebitIsSurety(suretyBill, isSuretyOnMap, isSuretyOffMap);
        }
        SuretyHelper.removeNotWriteBack(isSuretyOnMap);
        SuretyHelper.removeNotWriteBack(isSuretyOffMap);
    }

    public static void removeNotWriteBack(Map<String, List<Long>> map) {
        map.keySet().removeIf(k -> !rewriteBill.contains(k));
    }

    public static void writeBackToDB(Map<String, List<Long>> isSuretyOnMap, Map<String, List<Long>> isSuretyOffMap) {
        SuretyHelper.rewriteBackIsSuretyToDB(isSuretyOnMap, true);
        SuretyHelper.rewriteBackIsSuretyToDB(isSuretyOffMap, false);
    }

    public static void writeBackToBizBill(DynamicObject[] dynamicObjects, boolean suretyInputFlag) {
        ArrayList<DynamicObject> payableApplyBillList = new ArrayList<DynamicObject>(8);
        ArrayList<Object> payableBillList = new ArrayList<Object>(8);
        for (DynamicObject data : dynamicObjects) {
            DynamicObject[] payableApplyBills;
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entry");
            Set payableApplyBillIds = entrys.stream().filter(e -> EmptyUtil.equals((CharSequence)e.getString("debttype"), (CharSequence)"cdm_payablebill_ap_manual")).map(o -> o.getLong("debtbillid")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", payableApplyBillIds);
            for (DynamicObject payableApplyBill : payableApplyBills = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"entryentity,entryentity.suretyinput,entryentity.entry_suretyamount", (QFilter[])qFilter.toArray())) {
                DynamicObjectCollection entryEntity = payableApplyBill.getDynamicObjectCollection("entryentity");
                entryEntity.stream().filter(e -> EmptyUtil.isNoEmpty((Object)e.get("entry_suretyamount"))).forEach(d -> d.set("suretyinput", (Object)suretyInputFlag));
                payableApplyBillList.add(payableApplyBill);
            }
            Set payableBillIds = entrys.stream().filter(e -> EmptyUtil.equals((CharSequence)e.getString("debttype"), (CharSequence)"cdm_payablebill")).map(o -> o.getLong("debtbillid")).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", payableBillIds);
            Object[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"suretyinput,suretymoney", (QFilter[])filter.toArray());
            if (EmptyUtil.isEmpty((Object[])payableBills)) continue;
            Arrays.stream(payableBills).forEach(d -> d.set("suretyinput", (Object)suretyInputFlag));
            payableBillList.addAll(Arrays.asList(payableBills));
        }
        if (!EmptyUtil.isEmpty(payableApplyBillList)) {
            SaveServiceHelper.save((DynamicObject[])payableApplyBillList.toArray(new DynamicObject[0]));
        }
        if (!EmptyUtil.isEmpty(payableBillList)) {
            SaveServiceHelper.save((DynamicObject[])payableBillList.toArray(new DynamicObject[0]));
        }
    }

    private static void writeBackCreditLimitIsSurety(DynamicObject suretyBill, Map<String, List<Long>> isSuretyOnMap, Map<String, List<Long>> isSuretyOffMap) {
        DynamicObjectCollection credits = suretyBill.getDynamicObjectCollection("entry_credit");
        Map<Long, String> creditMap = credits.stream().collect(Collectors.toMap(d -> d.getDynamicObject("creditbillid").getLong("id"), d -> "cfm_creditlimit"));
        DynamicObjectCollection creditInDbs = QueryServiceHelper.query((String)"fbd_suretybill", (String)CREDIT_ID_PROP, (QFilter[])new QFilter[]{new QFilter("id", "=", suretyBill.getPkValue())});
        Map<Long, String> creditInDbMap = creditInDbs.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong(String.join((CharSequence)".", "entry_credit", "creditbillid")))).collect(Collectors.toMap(d -> d.getLong(String.join((CharSequence)".", "entry_credit", "creditbillid")), e -> "cfm_creditlimit"));
        SuretyHelper.compareAndPopulateMap(creditMap, creditInDbMap, isSuretyOnMap);
        SuretyHelper.compareAndPopulateMap(creditInDbMap, creditMap, isSuretyOffMap);
    }

    private static void writeBackDebitIsSurety(DynamicObject suretyBill, Map<String, List<Long>> isSuretyOnMap, Map<String, List<Long>> isSuretyOffMap) {
        DynamicObjectCollection debits = suretyBill.getDynamicObjectCollection("entry");
        Map<Long, String> debitMap = debits.stream().collect(Collectors.toMap(d -> d.getLong("debtbillid"), e -> e.getString("debttype"), (key1, key2) -> key1));
        DynamicObjectCollection debitInDbs = QueryServiceHelper.query((String)"fbd_suretybill", (String)DEBIT_ID_PROP, (QFilter[])new QFilter[]{new QFilter("id", "=", suretyBill.getPkValue())});
        Map<Long, String> debitInDbMap = debitInDbs.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong(String.join((CharSequence)".", "entry", "debtbillid")))).collect(Collectors.toMap(d -> d.getLong(String.join((CharSequence)".", "entry", "debtbillid")), e -> e.getString(String.join((CharSequence)".", "entry", "debttype")), (key1, key2) -> key1));
        SuretyHelper.compareAndPopulateMap(debitMap, debitInDbMap, isSuretyOnMap);
        SuretyHelper.compareAndPopulateMap(debitInDbMap, debitMap, isSuretyOffMap);
    }

    private static void compareAndPopulateMap(Map<Long, String> source, Map<Long, String> target, Map<String, List<Long>> resultMap) {
        for (Map.Entry<Long, String> entry : source.entrySet()) {
            Long key = entry.getKey();
            String value = entry.getValue();
            if (target.containsKey(key) && target.get(key).equals(value)) continue;
            resultMap.computeIfAbsent(value, k -> new ArrayList()).add(key);
        }
    }

    private static void rewriteBackIsSuretyToDB(Map<String, List<Long>> idAndTypeMap, Boolean isSurety) {
        if (idAndTypeMap.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(idAndTypeMap.size());
        for (Map.Entry<String, List<Long>> entry : idAndTypeMap.entrySet()) {
            DynamicObject[] load = TmcDataServiceHelper.load((String)entry.getKey(), (String)"issurety", (QFilter[])new QFilter[]{new QFilter("id", "in", idAndTypeMap.get(entry.getKey()))});
            saveList.addAll(Arrays.asList(load));
        }
        saveList.stream().forEach(d -> d.set("issurety", (Object)isSurety));
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
    }
}

