/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BDUtil {
    private static String selectFields = "id,org.id org,bookstype.id bookstype,curperiod.id curperiod,curperiod.begindate begindate,curperiod.enddate enddate,startperiod.id startperiod,accounttable.id accounttable,periodtype.id periodtype,defaultvouchertype.id defaultvouchertype,basecurrency.id basecurrency,exratetable.id exratetable,bookstype.accounttype accounttype,isbizunit";
    public static final int PRODUCT_CODE_STANDARD = 1;
    public static final int PRODUCT_CODE_GALAXY = 2;
    public static final String INDUSTRY_GALAXY = "Galaxy";
    public static final String FILED_INDUSTRY = "industry";
    public static final String ENTITY_LIC = "lic_license";

    public static DynamicObject getBookFromAccSys(long accorg) {
        QFilter h = new QFilter("org", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        return BDUtil.getBookFromAccSys(selectFields, new QFilter[]{k, h});
    }

    public static DynamicObject getBookFromAccSys(String selectField, QFilter[] qf) {
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectField, (QFilter[])qf);
        return accountBooksInfo;
    }

    public static DynamicObjectCollection getBizOrgFromAccSys(Long accorg) {
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        QFilter j = new QFilter("toorg", "=", (Object)accorg);
        DynamicObjectCollection bizOrgInfo = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg,toorg,typerelation,typerelation.fromtype orgtype,id", (QFilter[])new QFilter[]{j, k});
        return bizOrgInfo;
    }

    @Deprecated
    public static QFilter getAcctOrgFilter(String orgType) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List orgIds = PermissionServiceHelper.getUserOrgs((long)userId);
        QFilter orgId = new QFilter("id", "in", (Object)orgIds);
        QFilter isScc = new QFilter(orgType, "=", (Object)"1");
        return orgId.and(isScc);
    }

    public static DynamicObject getBookInfoByAccSys(long accSysId, long accorg, long bookstypeid) {
        Long[] bookId = BDUtil.getEntryIdFromAccSys(accSysId, false);
        QFilter j = new QFilter("id", "in", (Object)bookId);
        QFilter h = new QFilter("org", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype", "=", (Object)bookstypeid);
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{j, k, h});
        return accountBooksInfo;
    }

    public static Long[] getEntryIdFromAccSys(long id, boolean isBizEntry) {
        DynamicObject accSys = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_accsys");
        DynamicObjectCollection collection = null;
        String key = "";
        if (isBizEntry) {
            collection = accSys.getDynamicObjectCollection("orgentry");
            key = "orgentryid";
        } else {
            collection = accSys.getDynamicObjectCollection("entryentity");
            key = "bookid";
        }
        int size = collection.size();
        Long[] idArr = new Long[size];
        for (int i = 0; i < size; ++i) {
            idArr[i] = ((DynamicObject)collection.get(i)).getLong(key);
        }
        return idArr;
    }

    public static boolean isBizUnit(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,isbizunit", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static DynamicObject getBookFromAccSys(long accorg, String selectField) {
        QFilter h = new QFilter("org", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        return BDUtil.getBookFromAccSys(selectField, new QFilter[]{k, h});
    }

    public static List<Long> getAllBizUnit(List<Long> orgIds, QFilter qFilter) {
        ArrayList<Long> bizUnitIds = new ArrayList<Long>();
        List subOrgIds = OrgServiceHelper.getAllSubordinateOrgs((String)"10", orgIds, (boolean)true);
        QFilter qisbizunit = new QFilter("isbizunit", "=", (Object)"1");
        if (qFilter != null) {
            qisbizunit.and(qFilter);
        }
        DynamicObjectCollection accountbooks = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,org.id", (QFilter[])new QFilter[]{qisbizunit});
        for (DynamicObject book : accountbooks) {
            if (!subOrgIds.contains(book.getLong("org.id"))) continue;
            bizUnitIds.add(book.getLong("org.id"));
        }
        return bizUnitIds;
    }

    public static String isRepetition(DynamicObject dynamic, Map<String, String> map) {
        StringBuilder error = new StringBuilder();
        Boolean checknumber = BaseDataServiceHelper.chectDuplicate((String)dynamic.getDataEntityType().getName(), map, (Long)dynamic.getLong("createorg.id"), (Long)dynamic.getLong("id"));
        error.append(checknumber != false ? ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"BDUtil_0", (String)"tmc-fbd-common", (Object[])new Object[0]) : "");
        return error.toString();
    }

    public static HashMap<Long, DynamicObject> getDynamicDatas(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject object = extendedDataEntity.getDataEntity();
            long id = object.getLong("id");
            map.put(id, object);
        }
        return map;
    }

    public static HashMap<Long, DynamicObject> getDynamicDatas(DynamicObject[] dyos) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        for (DynamicObject dyo : dyos) {
            long id = dyo.getLong("id");
            map.put(id, dyo);
        }
        return map;
    }

    public static String convertListToStringSqlResult(List l) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            Object item = l.get(i);
            result.append(String.valueOf(item));
            if (i + 1 == l.size()) continue;
            result.append(',');
        }
        if (result.length() == 0) {
            return "''";
        }
        return result.toString();
    }

    public static DynamicObject getOrgInfo(Object useorgId) {
        QFilter q1 = new QFilter("org", "=", useorgId);
        QFilter q2 = new QFilter("view", "=", (Object)10);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent,isleaf", (QFilter[])new QFilter[]{q1, q2});
        return org;
    }

    public static List<Long> getAllSuperiorOrgIds(Object useorgId, boolean isIncludeCurOrg) {
        long orgid = Long.parseLong(String.valueOf(useorgId));
        ArrayList<Long> ids = new ArrayList<Long>();
        String longnumber = null;
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", useorgId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, (String)"longnumber", (int)1);){
            for (Row row : dataSet) {
                longnumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isNotBlank(longnumber)) {
            ArrayList<String> longnumbers = new ArrayList<String>();
            String[] ls = longnumber.split("!");
            for (int i = 0; i < ls.length; ++i) {
                String pernum = ls[i];
                if (longnumbers.isEmpty()) {
                    longnumbers.add(pernum);
                    continue;
                }
                longnumbers.add((String)longnumbers.get(longnumbers.size() - 1) + "!" + pernum);
            }
            if (longnumbers.size() != 1) {
                QFilter f4 = new QFilter("longnumber", "in", longnumbers);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, f4}, (String)"level");){
                    for (Row row : dataSet) {
                        ids.add(row.getLong("org"));
                    }
                }
            }
        }
        if (isIncludeCurOrg) {
            if (!ids.contains(orgid)) {
                ids.add(orgid);
            }
        } else if (ids.contains(orgid)) {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                long id = (Long)it.next();
                if (id != orgid) continue;
                it.remove();
            }
        }
        return ids;
    }

    public static List<Long> getAllSubordinateOrgs(Object useorgId, boolean isIncludeCurOrg) {
        long orgid = Long.parseLong(String.valueOf(useorgId));
        ArrayList<Long> ids = new ArrayList<Long>();
        String longnumber = null;
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", useorgId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, (String)"longnumber");){
            for (Row row : dataSet) {
                longnumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isNotBlank(longnumber)) {
            QFilter f4 = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])new QFilter[]{f2, f4}, (String)"level");
            Object object = null;
            try {
                for (Row row : dataSet) {
                    ids.add(row.getLong("org"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        if (isIncludeCurOrg) {
            if (!ids.contains(orgid)) {
                ids.add(orgid);
            }
        } else if (ids.contains(orgid)) {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                long id = (Long)it.next();
                if (id != orgid) continue;
                it.remove();
            }
        }
        return ids;
    }

    public static List<Long> getKeyFieldIdsInEntry(DynamicObjectCollection entry, String keyFieldName) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject d : entry) {
            DynamicObject item = d.getDynamicObject(keyFieldName);
            if (item == null) continue;
            ids.add(item.getLong("id"));
        }
        return ids;
    }

    public static int getRunModeCode() {
        Log log = LogFactory.getLog((String)"kd.fi.bd.util.BDUtil");
        try {
            QFilter filterGalaxy = new QFilter(FILED_INDUSTRY, "=", (Object)INDUSTRY_GALAXY);
            return QueryServiceHelper.exists((String)ENTITY_LIC, (QFilter[])new QFilter[]{filterGalaxy}) ? 2 : 1;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8bb8\u53ef\u5b57\u6bb5INDUSTRY \u83b7\u53d6\u5f53\u524d\u7684\u4ea7\u54c1\u7801\u6709\u8bef\uff01: ", (Throwable)e);
            return 1;
        }
    }

    public static void fixAccountAssgrp() {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", null, null, (int)-1);
        DynamicObject[] accts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        ArrayList<Long> asstactitems = new ArrayList<Long>();
        for (DynamicObject acct : accts) {
            int i;
            DynamicObjectCollection entry = acct.getDynamicObjectCollection("checkitementry");
            for (i = 0; i < entry.size(); ++i) {
                DynamicObject asstactitem = ((DynamicObject)entry.get(i)).getDynamicObject("asstactitem");
                if (asstactitem == null) continue;
                long asstactitemId = asstactitem.getLong("id");
                if (asstactitems.contains(asstactitemId)) {
                    indexs.add(i);
                    continue;
                }
                asstactitems.add(asstactitemId);
            }
            for (i = indexs.size(); i > 0; --i) {
                int t = (Integer)indexs.get(i - 1);
                entry.remove(t);
            }
            indexs.clear();
            asstactitems.clear();
        }
        SaveServiceHelper.save((DynamicObject[])accts);
    }

    public static void assgrpFilter(List<QFilter> filters) {
        filters.add(new QFilter("flexid", "=", (Object)2));
        Iterator<QFilter> filterIter = filters.iterator();
        Long orgId = 0L;
        while (filterIter.hasNext()) {
            QFilter qFilter = filterIter.next();
            if (!"createorg.id".equals(qFilter.getProperty())) continue;
            orgId = Long.valueOf(qFilter.getValue().toString());
            filterIter.remove();
        }
        List<Long> orgIds = BDUtil.getAllSuperiorOrgIdsOrderByLevel(orgId);
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (orgIds != null && !orgIds.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", orgIds).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        } else {
            filters.add(allCtrl);
        }
    }

    private static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgid == 0L) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", (Object)orgid);
        String longNumber = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi-bd.BDUtil", (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString("longnumber");
            }
        }
        if (null == longNumber || longNumber.indexOf("!") == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi-bd.BDUtil", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        if (!ids.contains(orgid)) {
            ids.add(orgid);
        }
        return ids;
    }
}

