/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.common.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CompanySysUtil {
    private static Comparator<Object> CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return CompanySysUtil.getAllOrgByViewId(orgViewSchemaId, null);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.tmc.fbd.formplugin.companysys.CompanySysViewEdit.getAllOrgByViewId()", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        return orgMap.values().stream().collect(Collectors.groupingBy(t -> t.getOrDefault("parentid", "")));
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        CompanySysUtil.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if (Long.valueOf(0L).equals(Long.valueOf(orgid)) || StringUtils.isEmpty((String)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentLongNumber + "!" + orgid);
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(parentLevel + 1));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            CompanySysUtil.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        CompanySysUtil.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            Collections.sort(nodes, (node1, node2) -> CHINA_COMPARATOR.compare(node1.getText(), node2.getText()));
        }
    }

    public static TreeNode getTreeNodeById(String nodeId, TreeNode unitTreeNode) {
        int j = unitTreeNode.getNodeLevel(nodeId, 0);
        return unitTreeNode.getTreeNode(nodeId, j);
    }

    public static List<TreeNode> buildTreeNodeByList(TreeNode parentTreeNode, List<Map<String, Object>> leftNodes) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(leftNodes.size());
        HashMap parentData = (HashMap)parentTreeNode.getData();
        for (Map<String, Object> treeNode : leftNodes) {
            if (parentTreeNode.getId().equals(treeNode.get("id"))) continue;
            TreeNode childrenTree = new TreeNode();
            childrenTree.setParentid(parentTreeNode.getId());
            childrenTree.setId((String)treeNode.get("id"));
            childrenTree.setText((String)treeNode.get("text"));
            childrenTree.setIsOpened(false);
            String longnumber = (String)treeNode.get("longnumber");
            childrenTree.setLongNumber(parentTreeNode.getLongNumber() + "!" + CompanySysUtil.getLastLongNum(longnumber));
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "1");
            int level = Integer.parseInt((String)parentData.get("level")) + 1;
            childDataMap.put("level", String.valueOf(level));
            childDataMap.put("fullname", parentTreeNode.getText() + "_" + treeNode.get("text"));
            childrenTree.setData(childDataMap);
            treeNodes.add(childrenTree);
        }
        return treeNodes;
    }

    public static Long getDefaultViewSchemaInfoId() {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id", (QFilter[])CompanySysUtil.getDefaultViewSchemaQFilter());
        return coll == null ? 0L : ((DynamicObject)coll.get(0)).getLong("id");
    }

    public static QFilter[] getDefaultViewSchemaQFilter() {
        QFilter f = new QFilter("isdefault", "=", (Object)"1");
        QFilter qf = new QFilter("treetype", "=", (Object)"08");
        return new QFilter[]{f, qf};
    }

    public static String getLastLongNum(String longNumber) {
        String[] splitArr = longNumber.split("!");
        return splitArr[splitArr.length - 1];
    }
}

