/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.oppservice.feedetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailBillUnAuditService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(FeeDetailBillUnAuditService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("payamt");
        sic.add("entry");
        sic.add("entry.feedetailamt");
        sic.add("entry.producttype");
        sic.add("entry.feeratio");
        sic.add("entry.srcbillno");
        sic.add("entry.srcbillid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject info : dataEntities) {
            this.forfeitTotalFeeAmtDeal(info);
        }
    }

    private void forfeitTotalFeeAmtDeal(DynamicObject info) {
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> idObjBillMaps = entrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("producttype")) && EmptyUtil.isNoEmpty((Long)o.getLong("srcbillid")) && EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("feedetailamt")) && ProductTypeEnum.LC_FORFAIT == ProductTypeEnum.getEnumByValue((String)o.getDynamicObject("producttype").getString("number"))).collect(Collectors.groupingBy(o -> o.getLong("srcbillid")));
        Map<Long, BigDecimal> idAmtMap = idObjBillMaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> ((List)o.getValue()).stream().map(o2 -> o2.getBigDecimal("feedetailamt")).reduce(BigDecimal::add).get()));
        if (EmptyUtil.isNoEmpty(idAmtMap)) {
            DynamicObject[] forfaitBills;
            for (DynamicObject forfaitBill : forfaitBills = TmcDataServiceHelper.load((Object[])idAmtMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ProductTypeEnum.LC_FORFAIT.getEntity()))) {
                BigDecimal feeAmt = idAmtMap.get(forfaitBill.getLong("id"));
                BigDecimal totalFeeAmount = forfaitBill.getBigDecimal("totalfeeamount").add(feeAmt.negate());
                forfaitBill.set("totalfeeamount", (Object)totalFeeAmount);
                BigDecimal buyoutAmount = forfaitBill.getBigDecimal("buyoutamount");
                if (BigDecimal.ZERO.compareTo(buyoutAmount) < 0) {
                    int diffDays;
                    BigDecimal withAmount = forfaitBill.getBigDecimal("withholdinterestamount");
                    BigDecimal recnetAmount = buyoutAmount.subtract(totalFeeAmount).subtract(withAmount);
                    forfaitBill.set("recnetamount", (Object)recnetAmount);
                    BigDecimal comprehenSiveCost = buyoutAmount.subtract(recnetAmount);
                    forfaitBill.set("comprehensivecost", (Object)comprehenSiveCost);
                    Date valiDdate = forfaitBill.getDate("validdate");
                    Date endDate = forfaitBill.getDate("enddate");
                    BigDecimal costRate = BigDecimal.ZERO;
                    if (valiDdate != null && endDate != null && (diffDays = DateUtils.getDiffDays((Date)valiDdate, (Date)endDate) - 1) > 0) {
                        costRate = comprehenSiveCost.divide(buyoutAmount, 10, RoundingMode.HALF_UP).divide(new BigDecimal(diffDays), 10, RoundingMode.HALF_UP).multiply(new BigDecimal(36000));
                    }
                    forfaitBill.set("comprehensivecostrate", (Object)costRate);
                    continue;
                }
                forfaitBill.set("recnetamount", (Object)BigDecimal.ZERO);
                forfaitBill.set("comprehensivecostrate", (Object)BigDecimal.ZERO);
            }
            SaveServiceHelper.save((DynamicObject[])forfaitBills);
        }
    }
}

