/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.oppservice.feedetail;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbd.common.helper.BusinessHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class FeeDetailSettleOpService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(FeeDetailSettleOpService.class);

    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("payamt");
        lst.add("issettle");
        lst.add("billstatus");
        lst.add("billno");
        lst.add("paybill");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<Object> fee2recs;
        List<Object> fee2Pays = Arrays.stream(dataEntities).filter(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("payamt")) < 0).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (!fee2Pays.isEmpty()) {
            this.push2RecOrPaybill("push2pay", fee2Pays);
        }
        if (!(fee2recs = Arrays.stream(dataEntities).filter(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("payamt")) > 0).map(DataEntityBase::getPkValue).collect(Collectors.toList())).isEmpty()) {
            this.push2RecOrPaybill("push2rec", fee2recs);
        }
    }

    private void push2RecOrPaybill(String opkey, List<Object> groupDatas) {
        LOGGER.info("\u4e0b\u63a8" + opkey + "\u6b3e\u5355\u5f00\u59cb-->\u4e0b\u63a8\u7684ids-->" + groupDatas);
        TmcOperateServiceHelper.execOperate((String)opkey, (String)"cfm_feebill", (Object[])groupDatas.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
        LOGGER.info("\u4e0b\u63a8\u6536\u4ed8\u6b3e\u5355\u7ed3\u675f-->" + opkey);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject info : dataEntities) {
            BusinessHelper.delPushRecPayBill((DynamicObject)info);
        }
    }
}

