/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("payamt");
        sic.add("amountrate");
        sic.add("entry");
        sic.add("entry.feedetailamt");
        sic.add("entry.producttype");
        sic.add("entry.feeratio");
        sic.add("entry.srcbillno");
        sic.add("entry.srcbillid");
        sic.add("entry.creditno");
        sic.add("entry.arrisubno");
        sic.add("entry.srcstatus");
        sic.add("appsource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) continue;
            BigDecimal entryRates = entrys.stream().filter(v -> !FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(v.getString("srcstatus"))).map(v -> v.getBigDecimal("feeratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (new BigDecimal("100").compareTo(entryRates) < 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u8d39\u7528\u660e\u7ec6\u627f\u62c5\u6bd4\u4f8b\u5408\u8ba1\u5fc5\u987b\u5c0f\u4e8e100\u3002", (String)"FeeDetailSaveValidator_03", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (!"cdm".equals(info.getString("appsource"))) {
                if (entrys.stream().anyMatch(e -> EmptyUtil.isEmpty((String)e.getString("producttype")))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveValidator_08", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                if (entrys.stream().anyMatch(e -> EmptyUtil.isEmpty((String)e.getString("srcbillno")))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailSaveValidator_09", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
            }
            this.importSaveVolidate(dataEntity, entrys);
        }
    }

    private void importSaveVolidate(ExtendedDataEntity dataEntity, DynamicObjectCollection entrys) {
        DynamicObject feeEntry;
        DynamicObject productType;
        Iterator iterator = entrys.iterator();
        while (iterator.hasNext() && !EmptyUtil.isEmpty((DynamicObject)(productType = (feeEntry = (DynamicObject)iterator.next()).getDynamicObject("producttype")))) {
            DynamicObjectCollection bizBills;
            QFilter qFilter;
            ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumByValue((String)productType.getString("number"));
            if (!EmptyUtil.isNoEmpty((Object)productTypeEnum)) continue;
            String productName = productTypeEnum.getName();
            String entityName = productTypeEnum.getEntity();
            String srcBillNo = feeEntry.getString("srcbillno");
            String creditNo = feeEntry.getString("creditno");
            if (EmptyUtil.isNoEmpty((String)srcBillNo)) {
                qFilter = new QFilter("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)entityName)) ? "number" : "billno", "=", (Object)srcBillNo);
                bizBills = QueryServiceHelper.query((String)entityName, (String)("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)entityName)) ? "id,status" : "id,billstatus"), (QFilter[])qFilter.toArray());
                if (EmptyUtil.isEmpty((DynamicObjectCollection)bizBills)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u53f7:%1$s\u5728\u4ea7\u54c1\u7c7b\u578b[%2$s]\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"FeeDetailSaveValidator_04", (String)"tmc-fbd-business", (Object[])new Object[0]), srcBillNo, productName));
                } else if (!BillStatusEnum.AUDIT.getValue().equals(((DynamicObject)bizBills.get(0)).getString("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)entityName)) ? "status" : "billstatus"))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u53f7:%1$s\u5728\u4ea7\u54c1\u7c7b\u578b[%2$s]\u4e2d\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"FeeDetailSaveValidator_05", (String)"tmc-fbd-business", (Object[])new Object[0]), srcBillNo, productName));
                }
            }
            if (!EmptyUtil.isNoEmpty((String)creditNo) || !entityName.startsWith("lc_")) continue;
            qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter = ProductTypeEnum.LC_ARRIVAL.getEntity().equals(entityName) || ProductTypeEnum.LC_PRESENT.getEntity().equals(entityName) || ProductTypeEnum.LC_FORFAIT.getEntity().equals(entityName) ? qFilter.and(new QFilter("lettercredit.number", "=", (Object)creditNo)) : qFilter.and(new QFilter("creditno", "=", (Object)creditNo));
            bizBills = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)bizBills)) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7:%1$s\u5728\u4ea7\u54c1\u7c7b\u578b[%2$s]\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"FeeDetailSaveValidator_06", (String)"tmc-fbd-business", (Object[])new Object[0]), creditNo, productName));
        }
    }
}

