/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailSettleOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("issettle");
        sic.add("billstatus");
        sic.add("entry");
        sic.add("entry.producttype");
        sic.add("entry.feeratio");
        sic.add("entry.srcbillno");
        sic.add("entry.srcbillid");
        sic.add("entry.srcstatus");
        sic.add("entry.feedetailamt");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject info = dataEntity.getDataEntity();
            if (info.getBoolean("issettle")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6ca1\u6709\u8fdb\u884c\u7ed3\u7b97\u7684\u8d39\u7528\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"FeeDetailSettleOpValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5ba1\u6838\u540e\u7684\u8d39\u7528\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FeeDetailSettleOpValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            BigDecimal headAmt = info.getBigDecimal("payamt");
            BigDecimal entryAmts = entrys.stream().filter(v -> !FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(v.getString("srcstatus"))).map(v -> v.getBigDecimal("feedetailamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (entrys.size() > 0 && headAmt.compareTo(entryAmts) != 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u91d1\u989d\u7684\u5408\u8ba1\u4e0d\u7b49\u4e8e\u8d39\u7528\u91d1\u989d\uff0c\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u5148\u5173\u8054\u4e1a\u52a1\u5355\u636e\u3002", (String)"FeeDetailSettleOpValidator_5", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            for (DynamicObject feeEntry : entrys) {
                ProductTypeEnum productTypeEnum;
                DynamicObject producttype = feeEntry.getDynamicObject("producttype");
                if (EmptyUtil.isEmpty((DynamicObject)producttype) || ProductTypeEnum.LC_ARRIVAL != (productTypeEnum = ProductTypeEnum.getEnumByValue((String)producttype.getString("number"))) && ProductTypeEnum.LC_PRESENT != productTypeEnum) continue;
                Long srcBillId = feeEntry.getLong("srcbillid");
                QFilter filter = new QFilter("id", "=", (Object)srcBillId);
                if (ProductTypeEnum.LC_ARRIVAL == productTypeEnum) {
                    filter.and(new QFilter("arrivalstatus", "in", Arrays.asList("arrival_confirm", "arrival_pay")));
                } else {
                    filter.and(new QFilter("arrivalstatus", "in", Arrays.asList("present_confirm", "present_reciect")));
                }
                if (TmcDataServiceHelper.exists((String)productTypeEnum.getEntity(), (QFilter[])filter.toArray())) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u8d39\u7528\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u672a\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u7ed3\u7b97\u3002", (String)"FeeDetailSettleOpValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
        }
    }
}

