/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public class FeeDetailSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List s = super.getSelector();
        s.add("sharetype");
        s.add("entry");
        s.add("entry.producttype");
        s.add("entry.srcbillid");
        return s;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObjectCollection feeDetails;
            DynamicObject info = dataEntity.getDataEntity();
            String shareType = info.getString("sharetype");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            HashSet<Long> feeBillIds = new HashSet<Long>();
            String feeShareEntryName = "bdim_costshare";
            for (DynamicObject entry : entrys) {
                DynamicObject productType = entry.getDynamicObject("producttype");
                if (EmptyUtil.isEmpty((DynamicObject)productType)) continue;
                ProductTypeEnum productEnum = ProductTypeEnum.getEnumByValue((String)productType.getString("number"));
                String formId = productEnum.getFormId();
                if (ShareTypeEnum.NOTSHARE.getValue().equals(shareType)) continue;
                if ("cfm_loanbill_bond".equals(formId) || "cfm_loanbill_b_l".equals(formId)) {
                    if ("cfm_loanbill_b_l".equals(formId)) {
                        feeShareEntryName = "cfm_loanfeeshare";
                    }
                    feeBillIds.add(entry.getLong("srcbillid"));
                }
                String appSource = TmcBusinessBaseHelper.getAppSource((String)productEnum.getFormId());
                if (TmcAppEnum.CFM.getValue().equals(appSource) && !ProductTypeEnum.LOANBILL_B_L.getId().equals(productType.getString("id"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u644a\u9500\u65b9\u5f0f\u4e3a\u5b9e\u9645\u5229\u7387\u6cd5\u6216\u76f4\u7ebf\u6cd5\u65f6\uff0c\u4ea7\u54c1\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u94f6\u884c\u501f\u6b3e\u501f\u636e\u3002", (String)"FeeBatchInputSaveValidator_05", (String)"tmc-fbd-business", (Object[])new Object[0]));
                    continue;
                }
                if (!"bdim".equals(appSource) || ProductTypeEnum.LOANBILL_BOND.getId().equals(productType.getString("id"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u644a\u9500\u65b9\u5f0f\u4e3a\u5b9e\u9645\u5229\u7387\u6cd5\u6216\u76f4\u7ebf\u6cd5\u65f6\uff0c\u4ea7\u54c1\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u503a\u5238\u53d1\u884c\u3002", (String)"FeeBatchInputSaveValidator_06", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (feeBillIds.size() <= 0) continue;
            DynamicObjectCollection bondBills = QueryServiceHelper.query((String)feeShareEntryName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", feeBillIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bondBills)) {
                String validataMsg = ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5904\u7406%s\u4e0b\u6e38\u7684\u94f6\u884c\u63d0\u6b3e\u8d39\u7528\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u644a\u9500\u7684\u8d39\u7528\u3002", (String)"FeeBatchInputSaveValidator_03", (String)"tmc-fbd-business", (Object[])new Object[0]);
                if ("bdim_costshare".equals(feeShareEntryName)) {
                    validataMsg = ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c%s\u4e0b\u6e38\u7684\u503a\u5238\u6210\u672c\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u644a\u9500\u7684\u8d39\u7528\u3002", (String)"FeeDetailSubmitValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]);
                }
                Set billnos = bondBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
                this.addMessage(dataEntity, String.format(validataMsg, StringUtils.setToString(billnos)));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(feeDetails = QueryServiceHelper.query((String)"cfm_feebill", (String)"sharetype,entry.srcbillno", (QFilter[])new QFilter[]{new QFilter("entry.srcbillid", "in", feeBillIds), new QFilter("sharetype", "not in", (Object)new Object[]{ShareTypeEnum.NOTSHARE.getValue(), shareType})})))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u7684\u644a\u9500\u65b9\u5f0f\u4e0e\u6765\u6e90\u5355\u636e\u53f7%s\u5df2\u6709\u8d39\u7528\u7684\u644a\u9500\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FeeDetailSubmitValidator_3", (String)"tmc-fbd-business", (Object[])new Object[]{((DynamicObject)feeDetails.get(0)).getString("entry.srcbillno")}));
        }
    }
}

