/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.feedetail;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public class FeeDetailUnAuditOpValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("sharetype");
        fields.add("entry.srcstatus");
        return fields;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entrys;
            DynamicObject info = dataEntity.getDataEntity();
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)info.getDataEntityType().getName(), (Long[])new Long[]{info.getLong("id")});
            if (EmptyUtil.isNoEmpty((Object)targetBills) && targetBills.size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u6709\u4e0b\u6e38\u4ed8\u6b3e\u5355\u636e\u3002", (String)"FeeDetailUnAuditOpValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if ("1".equals(info.getString("sharetype"))) {
                entrys = info.getDynamicObjectCollection("entry");
                this.checkFeeCostShare(dataEntity, entrys);
            }
            entrys = info.getDynamicObjectCollection("entry");
            List bizContactRowList = entrys.stream().filter(row -> EmptyUtil.isNoEmpty((String)row.getString("srcstatus"))).collect(Collectors.toList());
            for (DynamicObject row2 : bizContactRowList) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u5df2\u88ab%1$s[%2$s]\u5173\u8054\uff0c\u8bf7\u5148\u89e3\u9664\u5173\u8054\u3002", (String)"FeeDetailUnAuditOpValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]), row2.getDynamicObject("producttype").getString("name"), row2.getString("srcbillno")));
            }
        }
    }

    private void checkFeeCostShare(ExtendedDataEntity dataEntity, DynamicObjectCollection entrys) {
        HashSet<Long> feeBillIds = new HashSet<Long>();
        String feeShareEntryName = "bdim_costshare";
        for (DynamicObject entry : entrys) {
            String formId;
            DynamicObject productType = entry.getDynamicObject("producttype");
            if (EmptyUtil.isEmpty((DynamicObject)productType) || !"cfm_loanbill_bond".equals(formId = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getFormId()) && !"cfm_loanbill_b_l".equals(formId)) continue;
            if ("cfm_loanbill_b_l".equals(formId)) {
                feeShareEntryName = "cfm_loanfeeshare";
            }
            feeBillIds.add(entry.getLong("srcbillid"));
        }
        if (feeBillIds.size() > 0) {
            Object[] bondBills;
            String validataMsg = ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5355%s\u4e0b\u6e38\u7684\u8d39\u7528\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FeeDetailUnAuditOpValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]);
            if ("bdim_costshare".equals(feeShareEntryName)) {
                validataMsg = ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c%s\u4e0b\u6e38\u7684\u503a\u5238\u6210\u672c\u644a\u9500\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FeeDetailUnAuditOpValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]);
            }
            if (EmptyUtil.isNoEmpty((Object[])(bondBills = TmcDataServiceHelper.load((String)feeShareEntryName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", feeBillIds), new QFilter("billstatus", "in", (Object)new Object[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()})})))) {
                Set billnos = Arrays.stream(bondBills).map(o -> o.getString("billno")).collect(Collectors.toSet());
                this.addMessage(dataEntity, String.format(validataMsg, StringUtils.setToString(billnos)));
            }
        }
    }
}

