/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.async;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbd.business.async.AsyncTaskSupport;
import kd.tmc.fbp.common.constant.InvocationTaskVO;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import org.apache.commons.codec.digest.DigestUtils;

public class AsyncInvocationTaskService {
    private static final Log logger = LogFactory.getLog(AsyncInvocationTaskService.class);

    public String submitCrossCloud(String taskJson) {
        InvocationTaskVO iv = (InvocationTaskVO)JSON.parseObject((String)taskJson, InvocationTaskVO.class);
        RpcResult result = this.submit(iv);
        return JSON.toJSONString((Object)result);
    }

    public String submitAndExecuteOnceCrossCloud(String taskJson) {
        InvocationTaskVO iv = (InvocationTaskVO)JSON.parseObject((String)taskJson, InvocationTaskVO.class);
        RpcResult result = this.submitAndExecuteOnce(iv);
        return JSON.toJSONString((Object)result);
    }

    public RpcResult submit(InvocationTaskVO iv) {
        RpcResult result = new RpcResult();
        if (this.checkIfTaskExist(iv).booleanValue()) {
            return result;
        }
        try {
            this.persit(iv);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.setStatusCode(RpcResultStatusCode.ERROR);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private Boolean checkIfTaskExist(InvocationTaskVO iv) {
        String code = this.getIdentificationCodeOfTask(iv);
        DynamicObjectCollection existingTasks = this.loadTaskByIdentificationCode(code);
        if (existingTasks != null && existingTasks.size() > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public RpcResult submitAndExecuteOnce(InvocationTaskVO iv) {
        RpcResult result = new RpcResult();
        if (this.checkIfTaskExist(iv).booleanValue()) {
            return result;
        }
        iv.setStatus("2");
        Long id = 0L;
        try {
            id = this.persit(iv);
        }
        catch (Exception e) {
            logger.error("Exception happened:", (Throwable)e);
            String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            result.setStatusCode(RpcResultStatusCode.ERROR);
            result.setMessage(exception);
            return result;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fbd_asyncinvocationtask");
        AsyncTaskSupport asyncTaskSupport = new AsyncTaskSupport();
        result = asyncTaskSupport.executeSync(task, false);
        return result;
    }

    private String getIdentificationCodeOfTask(InvocationTaskVO iv) {
        StringBuilder sb = new StringBuilder();
        sb.append(iv.getCloudId()).append(iv.getAppId()).append(iv.getServiceName()).append(iv.getMethodName());
        for (String s : iv.getParams()) {
            sb.append(s);
        }
        String digestVal = DigestUtils.md5Hex((String)sb.toString());
        return digestVal;
    }

    private DynamicObjectCollection loadTaskByIdentificationCode(String code) {
        String selectFields = "id";
        QFilter qC = new QFilter("status", "in", (Object)new String[]{"1", "2"});
        qC.and("identificationcode", "=", (Object)code);
        qC.and(QFilter.of((String)"retrycount < maxretrycount", (Object[])new Object[0]));
        QFilter[] qFilters = new QFilter[]{qC};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fbd_asyncinvocationtask", (String)selectFields, (QFilter[])qFilters);
        return dynamicObjects;
    }

    private Long persit(InvocationTaskVO iv) throws Exception {
        DynamicObject t = BusinessDataServiceHelper.newDynamicObject((String)"fbd_asyncinvocationtask");
        t.set("cloudid", (Object)iv.getCloudId());
        t.set("appid", (Object)iv.getAppId());
        t.set("servicename", (Object)iv.getServiceName());
        t.set("method", (Object)iv.getMethodName());
        DynamicObjectCollection dc = t.getDynamicObjectCollection("parameterentry");
        int i = 0;
        for (String s : iv.getParams()) {
            DynamicObject p = dc.addNew();
            p.set("seq", (Object)i++);
            p.set("pvalue", (Object)s);
        }
        if ("2".equals(iv.getStatus())) {
            t.set("status", (Object)"2");
        } else {
            t.set("status", (Object)"1");
        }
        t.set("timeout", (Object)(iv.getTimoutInSec() <= 0 ? 0 : iv.getTimoutInSec()));
        t.set("maxretrycount", (Object)(iv.getMaxRetryCount() <= 0 ? 10 : iv.getMaxRetryCount()));
        t.set("retryratethreshhold", (Object)iv.getRetryRateThreshhold());
        t.set("createtime", (Object)new Date());
        return AsyncInvocationTaskService.saveToDB(t);
    }

    private static Long saveToDB(DynamicObject ob) throws Exception {
        OperationResult result = new OperationResult();
        Throwable throwable = null;
        try (TXHandle h1 = TX.requiresNew((String)"AsyncInvocationTaskService.saveToDB");){
            try {
                result = SaveServiceHelper.saveOperate((String)"save", (String)"fbd_asyncinvocationtask", (DynamicObject[])new DynamicObject[]{ob}, (OperateOption)OperateOption.create());
            }
            catch (Exception e) {
                h1.markRollback();
                throw e;
            }
            if (result.isSuccess()) {
                List ids = result.getSuccessPkIds();
                Long l = (Long)ids.get(0);
                return l;
            }
            try {
                List errorInfos = result.getAllErrorInfo();
                String errorMessage = "";
                if (errorInfos != null && !errorInfos.isEmpty()) {
                    errorMessage = ((OperateErrorInfo)errorInfos.get(0)).getMessage();
                }
                throw new Exception("Failed to save " + errorMessage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

