/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.lendingmarketrate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbd.business.asytaskhelper.LendingMarketRateWriterBackTaskHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LendingMarketRateSaveOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LendingMarketRateSaveOpService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        String currChangeMarketRateListStr = LendingMarketRateWriterBackTaskHelper.getCurrChangeMarketRate(dataEntities);
        if (!EmptyUtil.isEmpty((String)currChangeMarketRateListStr)) {
            this.operationVariable.put("currChangeMarketRateListStr", currChangeMarketRateListStr);
        }
        for (DynamicObject entity : dataEntities) {
            DynamicObject currency = (DynamicObject)entity.get("currency");
            DynamicObject lendingMarket = (DynamicObject)entity.get("lendingmarket");
            DynamicObject termCategory = (DynamicObject)entity.get("termcategory");
            if (null == lendingMarket || null == currency || null == termCategory) continue;
            String name = lendingMarket.getString("name") + "-" + termCategory.getString("name") + "-" + currency.get("name");
            entity.set("name", (Object)name);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        String currChangeMarketRateList = (String)this.operationVariable.get("currChangeMarketRateListStr");
        if (!EmptyUtil.isEmpty((String)currChangeMarketRateList)) {
            try {
                LendingMarketRateWriterBackTaskHelper.doWriterBackTask(currChangeMarketRateList);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }
}

