/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.pandamenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class PandaMenuRegisteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("enable");
        selectors.add("number");
        selectors.add("schemeentry");
        selectors.add("bizbill");
        selectors.add("billcheck");
        return selectors;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map billMap = this.billToTrip(Arrays.stream(dataEntities)).collect(Collectors.groupingBy(Triple::getLeft, Collectors.toSet()));
        if (CollectionUtils.isEmpty(billMap.keySet())) {
            return;
        }
        List<Triple<String, String, Set<String>>> configList = this.getAllPandaConfig();
        for (Map.Entry one : billMap.entrySet()) {
            String billType = one.getKey();
            Set tripBill = one.getValue();
            Set pandaList = tripBill.stream().map(Triple::getMiddle).collect(Collectors.toSet());
            Set checkList = tripBill.stream().flatMap(t -> ((Set)t.getRight()).stream()).collect(Collectors.toSet());
            Set configChecks = configList.stream().filter(t -> billType.equals(t.getLeft()) && !pandaList.contains(t.getMiddle())).flatMap(t -> ((Set)t.getRight()).stream()).collect(Collectors.toSet());
            checkList.addAll(configChecks);
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)billType, (String)"PandaListCtrl", new ArrayList(checkList));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        Set<String> pandaList = billMap.values().stream().flatMap(t -> t.stream()).map(Triple::getMiddle).collect(Collectors.toSet());
        this.cancelPandaOpp(pandaList, billMap.keySet(), configList);
    }

    private void cancelPandaOpp(Set<String> pandaList, Set<String> billList, List<Triple<String, String, Set<String>>> configList) {
        Set dbBillList = configList.stream().filter(t -> pandaList.contains(t.getMiddle())).map(Triple::getLeft).collect(Collectors.toSet());
        Set diffBill = dbBillList.stream().filter(t -> !billList.contains(t)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(diffBill)) {
            Set resBill = diffBill;
            Set diffHasBill = configList.stream().filter(t -> diffBill.contains(t.getLeft()) && !pandaList.contains(t.getMiddle())).map(Triple::getLeft).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(diffHasBill)) {
                resBill = diffBill.stream().filter(t -> diffHasBill.contains(t)).collect(Collectors.toSet());
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    for (String billType : resBill) {
                        OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)billType, (String)"PandaListCtrl");
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private List<Triple<String, String, Set<String>>> getAllPandaConfig() {
        QFilter filter;
        String props = String.join((CharSequence)",", "number", "schemeentry.bizbill", "schemeentry.billcheck");
        Map objectMap = TmcDataServiceHelper.loadFromCache((String)"fbd_pandamenu", (String)props, (QFilter[])new QFilter[]{filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
        if (Objects.isNull(objectMap) || CollectionUtils.isEmpty(objectMap.keySet())) {
            return Collections.emptyList();
        }
        return this.billToTrip(objectMap.values().stream()).collect(Collectors.toList());
    }

    private Stream<Triple<String, String, Set<String>>> billToTrip(Stream<DynamicObject> stream) {
        return stream.filter(t -> CollectionUtils.isNotEmpty((Collection)t.getDynamicObjectCollection("schemeentry"))).flatMap(t -> t.getDynamicObjectCollection("schemeentry").stream().map(w -> Triple.of((Object)w.getDynamicObject("bizbill").getString("number"), (Object)t.getString("number"), this.toOppList(w.getString("billcheck")))));
    }

    private Set<String> toOppList(String billCheck) {
        return Arrays.stream(StringUtils.split((String)billCheck, (String)",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }
}

