/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.subscribe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tmc.fbd.common.enums.SubscribeStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SubscribeConsumeOppService
extends AbstractTmcBizOppService {
    private static final DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
    private static final Log logger = LogFactory.getLog(SubscribeConsumeOppService.class);
    private static final String FIELDS = "id,number,enable,filter,org,tplscen,recuser,datasource,subscribenum,maxsubscribe,subscribedate,validdate,filter_tag,fixfilter_tag,subfilter_tag,dataorgentry.dorg_number";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DynamicObject[] dataEntities) {
        ArrayList<Pair<DynamicObject, DynamicObject>> logs = new ArrayList<Pair<DynamicObject, DynamicObject>>();
        Set<String> entityNames = Arrays.stream(dataEntities).map(o -> o.getDynamicObject("datasource").getString("id")).collect(Collectors.toSet());
        DynamicObjectCollection subscribeBills = this.queryUserSubscribes(entityNames);
        this.initPool(dataEntities, subscribeBills);
        List ids = subscribeBills.stream().map(o -> String.valueOf(o.getLong("id"))).collect(Collectors.toList());
        Map mutexLockMap = MutexServiceHelper.batchRequest(ids, (String)"fbd_subscribe", (String)"consume");
        try {
            ArrayList<DynamicObject> subScribeRsult = new ArrayList<DynamicObject>();
            Set lockSuccessIds = mutexLockMap.entrySet().stream().filter(o -> (Boolean)o.getValue()).map(o -> (String)o.getKey()).collect(Collectors.toSet());
            for (DynamicObject subscribeBill : subscribeBills) {
                List<DynamicObject> bizBills;
                String subDataSource = subscribeBill.getString("datasource");
                HashSet subScribeOps = new HashSet();
                String subscribeOps = subscribeBill.getString("subscribeop");
                if (EmptyUtil.isNoEmpty((String)subscribeOps)) {
                    subScribeOps.addAll(Arrays.stream(subscribeOps.split(",")).collect(Collectors.toSet()));
                }
                if ((bizBills = Arrays.stream(dataEntities).filter(o -> o.getDynamicObject("datasource").getString("id").equals(subDataSource) && (EmptyUtil.isEmpty((Collection)subScribeOps) || subScribeOps.contains(o.getString("operatekey"))) && o.getInt("operatenum") < 5).collect(Collectors.toList())).size() == 0) continue;
                if (lockSuccessIds.contains(subscribeBill.getString("id"))) {
                    DynamicObject subResult = this.poolConsumeBySubscribe(subscribeBill, bizBills, logs);
                    if (subResult == null) continue;
                    subScribeRsult.add(subResult);
                    continue;
                }
                this.poolConsumeBySubscribefail(subscribeBill, bizBills);
            }
            SaveServiceHelper.save((DynamicObject[])subScribeRsult.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            for (DynamicObject dataEntity : dataEntities) {
                String errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                dataEntity.set("msg_tag", (Object)errorMsg);
                dataEntity.set("msg", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e).substring(0, 255));
            }
            logger.error((Throwable)e);
        }
        finally {
            List subScribeIds = mutexLockMap.entrySet().stream().filter(o -> (Boolean)o.getValue()).map(o -> (String)o.getKey()).collect(Collectors.toList());
            MutexServiceHelper.batchRelease(subScribeIds, (String)"fbd_subscribe", (String)"consume");
        }
        this.dealPoolStatus(dataEntities);
        this.addSubscribeLog(logs);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        SubscribeConsumeOppService.deleteHistoryDatas();
    }

    private void dealPoolStatus(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            long failSum = entrys.stream().filter(o -> SubscribeStatusEnum.isSubFail((String)o.getString("e_subscribestatus"))).count();
            if (failSum == 0L && EmptyUtil.isEmpty((String)dataEntity.getString("msg"))) {
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                    dataEntity.set("issubscribe", (Object)true);
                }
                dataEntity.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            }
            dataEntity.set("operatenum", (Object)(dataEntity.getInt("operatenum") + 1));
            if (dataEntity.getInt("operatenum") < 5) continue;
            dataEntity.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void initPool(DynamicObject[] pools, DynamicObjectCollection subscribeBills) {
        Set subScribeIds = subscribeBills.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject pool : pools) {
            pool.set("msg_tag", (Object)"");
            pool.set("msg", (Object)"");
            DynamicObjectCollection entrys = pool.getDynamicObjectCollection("entryentity");
            Iterator ites = entrys.iterator();
            while (ites.hasNext()) {
                DynamicObject entry = (DynamicObject)ites.next();
                DynamicObject subScribe = entry.getDynamicObject("e_subscribe");
                if (EmptyUtil.isEmpty((DynamicObject)subScribe) || subScribeIds.contains(subScribe.getLong("id")) || !SubscribeStatusEnum.SUBFAIL.getValue().equals(entry.getString("e_subscribestatus"))) continue;
                ites.remove();
            }
        }
    }

    private DynamicObject poolConsumeBySubscribe(DynamicObject subscribeBill, List<DynamicObject> bizBills, List<Pair<DynamicObject, DynamicObject>> logs) {
        DynamicObject subScribe = TmcDataServiceHelper.loadSingle((Object)subscribeBill.getLong("id"), (String)"fbd_subscribe", (String)FIELDS);
        int subscribeNum = subScribe.getInt("subscribenum");
        int maxSubscribeNum = subScribe.getInt("maxsubscribe");
        Date subScribeDate = subScribe.getDate("subscribedate");
        Date validdate = subScribe.getDate("validdate");
        boolean isUpdateSubScribe = false;
        for (DynamicObject bizBill : bizBills) {
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.stream().filter(o -> o.getDynamicObject("e_subscribe").getLong("id") == subscribeBill.getLong("id")).findFirst().orElse(null);
            if (entry != null && SubscribeStatusEnum.isSubSuccess((String)entry.getString("e_subscribestatus"))) continue;
            if (!subScribe.getBoolean("enable") || validdate != null && validdate.compareTo(DateUtils.getDataFormat((Date)new Date(), (boolean)true)) <= 0 || subScribeDate != null && subScribeDate.compareTo(DateUtils.getDataFormat((Date)new Date(), (boolean)false)) > 0) {
                this.setPoolSubEntry(entrys, subscribeBill, SubscribeStatusEnum.NOTSUB.getValue(), String.format("enable is false or date fail,%s-%s", DateUtils.formatString((Date)subScribeDate, (String)"yyyy-MM-dd HH:mm:ss"), DateUtils.formatString((Date)validdate, (String)"yyyy-MM-dd HH:mm:ss")));
                continue;
            }
            if (subscribeNum >= maxSubscribeNum) {
                subScribe.set("enable", (Object)BaseEnableEnum.DISABLE.getValue());
                this.setPoolSubEntry(entrys, subscribeBill, SubscribeStatusEnum.NOTSUB.getValue(), "subscribeNum is over :" + subscribeNum);
                isUpdateSubScribe = true;
                continue;
            }
            boolean checkRes = this.consumeCheck(bizBill, subScribe);
            if (!checkRes) {
                this.setPoolSubEntry(entrys, subScribe, SubscribeStatusEnum.NOTSUB.getValue(), "not mate condition");
                continue;
            }
            logger.info("sendmsg start");
            List<Long> messageUserIds = this.sendMessage(subScribe, bizBill);
            if (messageUserIds == null) {
                this.setPoolSubEntry(entrys, subScribe, SubscribeStatusEnum.SUBFAIL.getValue(), "sendmsg fail");
                continue;
            }
            this.setPoolSubEntry(entrys, subScribe, SubscribeStatusEnum.SUBSUCCESS.getValue(), "");
            logs.add((Pair<DynamicObject, DynamicObject>)Pair.of((Object)bizBill, (Object)subScribe));
            ++subscribeNum;
            isUpdateSubScribe = true;
        }
        subScribe.set("subscribenum", (Object)subscribeNum);
        return isUpdateSubScribe ? subScribe : null;
    }

    private void setPoolSubEntry(DynamicObjectCollection entrys, DynamicObject subscribeBill, String status, String msg) {
        DynamicObject entry = entrys.stream().filter(o -> o.getDynamicObject("e_subscribe").getLong("id") == subscribeBill.getLong("id")).findFirst().orElse(null);
        if (entry == null) {
            DynamicObject newEntry = entrys.addNew();
            DynamicObject subScribe = TmcDataServiceHelper.loadSingleFromCache((Object)subscribeBill.getLong("id"), (String)"fbd_subscribe");
            newEntry.set("e_subscribe", (Object)subScribe);
            newEntry.set("e_subscribestatus", (Object)status);
            newEntry.set("e_msg", (Object)msg);
        } else {
            entry.set("e_msg", (Object)msg);
            entry.set("e_subscribestatus", (Object)status);
        }
    }

    private void poolConsumeBySubscribefail(DynamicObject subscribeBill, List<DynamicObject> bizBills) {
        for (DynamicObject bizBill : bizBills) {
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.stream().filter(o -> o.getDynamicObject("e_subscribe").getLong("id") == subscribeBill.getLong("id")).findFirst().orElse(null);
            if (entry != null && SubscribeStatusEnum.isSubSuccess((String)entry.getString("e_subscribestatus")) || entry != null) continue;
            this.setPoolSubEntry(entrys, subscribeBill, SubscribeStatusEnum.SUBFAIL.getValue(), "mutexlock fail");
        }
    }

    private DynamicObjectCollection queryUserSubscribes(Set<String> entityNames) {
        Date date = DateUtils.getCurrentDate();
        QFilter filter = new QFilter("datasource", "in", entityNames).and("enable", "=", (Object)"1").and("validdate", ">=", (Object)DateUtils.getDataFormat((Date)date, (boolean)true)).and("subscribedate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false));
        return QueryServiceHelper.query((String)"fbd_subscribe", (String)"id,number,subscribeop,datasource", (QFilter[])filter.toArray());
    }

    private boolean consumeCheck(DynamicObject bizBill, DynamicObject subscriber) {
        if (subscriber.getInt("maxsubscribe") == subscriber.getInt("subscribenum")) {
            subscriber.set("enable", (Object)"0");
            return false;
        }
        String entryName = subscriber.getDynamicObject("datasource").getString("number");
        Object billId = bizBill.get("billid");
        QFilter filter = new QFilter("id", "=", billId);
        this.getFilterFromSub(filter, subscriber, entryName);
        return TmcDataServiceHelper.exists((String)entryName, (QFilter[])new QFilter[]{filter});
    }

    private void getFilterFromSub(QFilter filter, DynamicObject subscriber, String entryName) {
        DynamicObjectCollection orgEntrys;
        String filterSubTag;
        String filterFixTag;
        String filterTag = subscriber.getString("filter_tag");
        if (EmptyUtil.isNoEmpty((String)filterTag)) {
            filter.and(this.getFilterFromTag(entryName, filterTag));
        }
        if (EmptyUtil.isNoEmpty((String)(filterFixTag = subscriber.getString("fixfilter_tag")))) {
            filter.and(this.getFilterFromTag(entryName, filterFixTag));
        }
        if (EmptyUtil.isNoEmpty((String)(filterSubTag = subscriber.getString("subfilter_tag")))) {
            filter.and(this.getFilterFromTag(entryName, filterSubTag));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(orgEntrys = subscriber.getDynamicObjectCollection("dataorgentry")))) {
            HashSet orgIds = new HashSet(orgEntrys.size());
            orgEntrys.forEach(o -> orgIds.add(o.getDynamicObject("dorg_number").getPkValue()));
            String mainOrg = EntityMetadataCache.getDataEntityType((String)entryName).getMainOrg();
            if (EmptyUtil.isNoEmpty((String)mainOrg)) {
                filter.and(new QFilter(mainOrg, "in", orgIds));
            }
        }
    }

    private QFilter getFilterFromTag(String entryName, String filterTag) {
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder fb = new FilterBuilder(dataType, condition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    private void addSubscribeLog(List<Pair<DynamicObject, DynamicObject>> logs) {
        ThreadService.execute(() -> {
            ArrayList subLogs = new ArrayList(logs.size());
            logs.forEach(log -> {
                DynamicObject subscriber = (DynamicObject)log.getRight();
                DynamicObject bizBill = (DynamicObject)log.getLeft();
                DynamicObjectCollection recUsers = ((DynamicObject)log.getRight()).getDynamicObjectCollection("recuser");
                DynamicObject subscribeLog = null;
                for (DynamicObject recUser : recUsers) {
                    subscribeLog = TmcDataServiceHelper.newDynamicObject((String)"fbd_subscribe_log");
                    subscribeLog.set("subscriber", (Object)subscriber);
                    subscribeLog.set("recuser", (Object)recUser.getDynamicObject("fbasedataid"));
                    subscribeLog.set("org", (Object)subscriber.getDynamicObject("org"));
                    subscribeLog.set("datasource", (Object)bizBill.getDynamicObject("datasource"));
                    subscribeLog.set("billno", (Object)bizBill.getString("billno"));
                    subscribeLog.set("billid", (Object)bizBill.getLong("billid"));
                    subscribeLog.set("biztime", (Object)DateUtils.getCurrentTime());
                    subLogs.add(subscribeLog);
                }
            });
            SaveServiceHelper.save((DynamicObject[])subLogs.toArray(new DynamicObject[0]));
        }, (TaskType)TaskType.FBD_ADD_SUBSCRIBE_LOG, (RequestContext)RequestContext.get());
    }

    private Set<Long> getSubscribeRecUsers(DynamicObject bill) {
        HashSet<Long> recUserSet = new HashSet<Long>();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if (!SubscribeStatusEnum.isSubSuccess((String)entry.getString("e_subscribestatus"))) continue;
            DynamicObject subScribe = entry.getDynamicObject("e_subscribe");
            DynamicObjectCollection recUsers = subScribe.getDynamicObjectCollection("recuser");
            recUserSet.addAll(recUsers.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
        }
        return recUserSet;
    }

    private List<Long> sendMessage(DynamicObject subscriber, DynamicObject bill) {
        MessageInfo message = new MessageInfo();
        String msg = ResManager.loadKDString((String)"\u8d44\u91d1\u8ba2\u9605", (String)"SubscribeConsumeOppService_0", (String)"tmc-fbd-business", (Object[])new Object[0]);
        message.setTag(msg);
        message.setTplScene(subscriber.getDynamicObject("tplscen").getString("number"));
        DynamicObjectCollection recUsers = subscriber.getDynamicObjectCollection("recuser");
        List<Long> userIds = recUsers.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        Set<Long> subscribeRecUsers = this.getSubscribeRecUsers(bill);
        userIds.removeAll(subscribeRecUsers);
        if (EmptyUtil.isEmpty(userIds)) {
            return userIds;
        }
        message.setUserIds(userIds);
        message.setType("message");
        String dataSource = bill.getDynamicObject("datasource").getString("number");
        message.setEntityNumber(dataSource);
        long billId = bill.getLong("billid");
        if (EmptyUtil.isEmpty((Long)billId)) {
            DynamicObject obj = TmcDataServiceHelper.newDynamicObject((String)dataSource);
            String prop = ((BillEntityType)obj.getDynamicObjectType()).getBillNo();
            bill = TmcDataServiceHelper.loadSingle((String)dataSource, (String)"id", (QFilter[])new QFilter[]{new QFilter(prop, "=", (Object)bill.getString("billno"))});
            billId = bill.getLong("id");
        }
        message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + dataSource + "&pkId=" + billId);
        message.setBizDataId(Long.valueOf(billId));
        message.setTitle(msg);
        message.setContent(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba2\u9605\u65b9\u6848\u3010%s\u3011\u8ba2\u9605\u6210\u529f\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u3002", (String)"SubscribeConsumeOppService_1", (String)"tmc-fbd-business", (Object[])new Object[]{subscriber.getString("number")}));
        long messageId = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        if (EmptyUtil.isNoEmpty((Long)messageId)) {
            return userIds;
        }
        return null;
    }

    private static void deleteHistoryDatas() {
        boolean isConsume = cache.contains("consume");
        if (isConsume) {
            return;
        }
        QFilter filter = new QFilter("createtime", "<=", (Object)DateUtils.getLastMonth((Date)new Date(), (int)2)).and("issubscribe", "=", (Object)true);
        DeleteServiceHelper.delete((String)"fbd_billpool", (QFilter[])new QFilter[]{filter});
        cache.put("consume", (Object)"consume", 86400);
    }
}

