/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.surety;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.DeductTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ReleaseSourceEnum;
import kd.tmc.fbp.common.enums.SuretyReleaseTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyRepayService
extends AbstractTmcBizOppService {
    private static final String LC_CALLBACK_PROPS = "doneamount,todoamount,arrivalstatus";

    public void process(DynamicObject[] suretyEntities) throws KDException {
        if (EmptyUtil.isEmpty((Object[])suretyEntities)) {
            return;
        }
        String returnData = (String)this.getOperationVariable().get("returnDataMap");
        Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
        Map dataMap = (Map)returnMap.get("valueMap");
        Map<Long, DynamicObject> suretyMap = this.getSuretyMap(dataMap);
        if (EmptyUtil.isEmpty(suretyMap)) {
            return;
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            Long suretyBillId = Long.parseLong((String)entry.getKey());
            Map suretyEntryMap = (Map)entry.getValue();
            DynamicObject surety = suretyMap.get(suretyBillId);
            if (EmptyUtil.isEmpty((DynamicObject)surety)) continue;
            DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)surety, (String)"fbd_suretyreleasebill");
            DynamicObject targetBill = targetBills[0];
            SuretyRepayService.setEntryDebtAmt(targetBill, (String)this.getOperationVariable().get("suretyReleaseDebtBillIdStr"));
            boolean isInterestRepay = DeductTypeEnum.INTEREST_REPAY.getValue().equals(this.getOperationVariable().get("repayType"));
            targetBill.set("isrevenue", (Object)isInterestRepay);
            targetBill.set("repaybillid", (Object)Long.parseLong((String)this.getOperationVariable().get("debitId")));
            targetBill.set("repaybilltype", returnMap.get("srcEntity"));
            targetBill.set("repaybillno", returnMap.get("bizno"));
            targetBill.set("finaccount", null);
            targetBill.set("releasedate", (Object)DateUtils.parseDate(suretyEntryMap.get("repaydate")));
            targetBill.set("releasetype", (Object)SuretyRepayService.getReleaseType(suretyEntryMap, surety));
            targetBill.set("amount", suretyEntryMap.get("repayamount"));
            targetBill.set("totalamount", suretyEntryMap.get("repayamount"));
            if (isInterestRepay) {
                targetBill.set("realrevenue", this.getOperationVariable().get("repayIntAmt"));
                targetBill.set("totalamount", (Object)((BigDecimal)suretyEntryMap.get("repayamount")).add(new BigDecimal(String.valueOf(this.getOperationVariable().get("repayIntAmt")))));
            }
            targetBill.set("releasesource", (Object)(isInterestRepay ? ReleaseSourceEnum.INTEREST_REPAY.getValue() : ReleaseSourceEnum.REPAY.getValue()));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"submit", (String)"fbd_suretyreleasebill", (DynamicObject[])targetBills, (OperateOption)operateOption);
            if (!result.isSuccess()) {
                return;
            }
            Object intBillId = result.getSuccessPkIds().toArray()[0];
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"fbd_suretyreleasebill", (Object[])new Object[]{intBillId}, (OperateOption)operateOption);
        }
    }

    private Map<Long, DynamicObject> getSuretyMap(Map<String, Map<String, Object>> dataMap) {
        List collect = dataMap.entrySet().stream().map(e -> Long.parseLong((String)e.getKey())).collect(Collectors.toList());
        DynamicObjectCollection suretyBills = QueryServiceHelper.query((String)"fbd_suretybill", (String)String.join((CharSequence)",", "id", "expiredate"), (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        HashMap<Long, DynamicObject> suretyMap = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject suretyBill : suretyBills) {
            DynamicObject surety = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fbd_suretybill"));
            surety.set("id", (Object)suretyBill.getLong("id"));
            surety.set("expiredate", (Object)suretyBill.getDate("expiredate"));
            suretyMap.put(suretyBill.getLong("id"), surety);
        }
        return suretyMap;
    }

    private static void setEntryDebtAmt(DynamicObject targetBill, String suretyReleaseDebtBillIdStr) {
        DynamicObjectCollection entryCol = targetBill.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> delDebtBills = new ArrayList<DynamicObject>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            String bizType = entry.getString("debttype");
            if ("cdm_payablebill".equals(bizType)) {
                entry.set("repaydebt", (Object)true);
                entry.set("repaydebtamt", (Object)entry.getBigDecimal("debtamt"));
            }
            long debtBillId = entry.getLong("debtbillid");
            if (!EmptyUtil.isNoEmpty((String)suretyReleaseDebtBillIdStr) || debtBillId == Long.parseLong(suretyReleaseDebtBillIdStr)) continue;
            delDebtBills.add(entry);
        }
        entryCol.removeAll(delDebtBills);
    }

    private static String getReleaseType(Map<String, Object> suretyEntry, DynamicObject suretyBill) {
        Date expireDate = suretyBill.getDate("expiredate");
        if (EmptyUtil.isEmpty((Object)expireDate)) {
            return SuretyReleaseTypeEnum.CURRENT.getValue();
        }
        Date repayDate = DateUtils.parseDate((Object)suretyEntry.get("repaydate"));
        if (repayDate.before(expireDate)) {
            return SuretyReleaseTypeEnum.INADVANCE.getValue();
        }
        return SuretyReleaseTypeEnum.EXPIRE.getValue();
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String debitType = (String)this.getOperationVariable().get("debitType");
        Long debitId = Long.parseLong((String)this.getOperationVariable().get("debitId"));
        if (StringUtils.equals((CharSequence)"lc_arrival", (CharSequence)debitType)) {
            this.writeBackLcArrival(debitId);
        }
    }

    private void writeBackLcArrival(Long debitId) {
        DynamicObject[] arrivals = TmcDataServiceHelper.load((String)"lc_arrival", (String)LC_CALLBACK_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)debitId)});
        DynamicObject arrival = arrivals[0];
        String returnData = (String)this.getOperationVariable().get("returnDataMap");
        Map returnMap = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
        Map dataMap = (Map)returnMap.get("valueMap");
        BigDecimal totalRepayAmt = BigDecimal.ZERO;
        for (Map.Entry entry : dataMap.entrySet()) {
            BigDecimal repayIntAmt = EmptyUtil.isEmpty((String)((String)this.getOperationVariable().get("repayIntAmt"))) ? Constants.ZERO : new BigDecimal(String.valueOf(this.getOperationVariable().get("repayIntAmt")));
            totalRepayAmt = totalRepayAmt.add(((BigDecimal)((Map)entry.getValue()).get("repayamount")).add(repayIntAmt));
        }
        arrival.set("doneamount", (Object)arrival.getBigDecimal("doneamount").add(totalRepayAmt));
        arrival.set("todoamount", (Object)arrival.getBigDecimal("todoamount").subtract(totalRepayAmt));
        if (BigDecimal.ZERO.compareTo(arrival.getBigDecimal("todoamount")) == 0) {
            arrival.set("arrivalstatus", (Object)"arrival_pay");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrival});
    }
}

