/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretyappend;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.SuretyStatusEnum;
import kd.tmc.fbd.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyAppendUnAuditService
extends AbstractTmcBizOppService {
    private static final String COMMA_CHAR = ",";
    private static final String PERIOD_CHAR = ".";
    private static final String[] SURETY_BILL_PROP = new String[]{"amount", "appendedamt", "entry", "amount", "surplusamount", String.join((CharSequence)".", "entry", "suretyamount"), String.join((CharSequence)".", "entry", "debtamt"), String.join((CharSequence)".", "entry", "debtbillno"), String.join((CharSequence)".", "entry", "debtbillid"), String.join((CharSequence)".", "entry", "credit"), String.join((CharSequence)".", "entry", "debttype")};

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("org");
        selector.add("currency");
        selector.add("appendamount");
        selector.add("releasecreditamt");
        selector.add("entry");
        selector.add("entry.appendamt");
        selector.add("entry.debtcurrency");
        selector.add("entry.credit");
        selector.add("suretystatus");
        selector.add("debttype");
        selector.add("debtbillid");
        selector.add("debtamt");
        selector.add("amount");
        return selector;
    }

    public void process(DynamicObject[] appendEntities) throws KDException {
        ArrayList<DynamicObject> suretyList = new ArrayList<DynamicObject>(appendEntities.length);
        for (DynamicObject appendBill : appendEntities) {
            Object suretyBillId = appendBill.getDynamicObject("suretybill").getPkValue();
            DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (String)"fbd_suretybill", (String)String.join((CharSequence)COMMA_CHAR, SURETY_BILL_PROP));
            suretyBill.set("amount", (Object)suretyBill.getBigDecimal("amount").subtract(appendBill.getBigDecimal("appendamount")));
            suretyBill.set("appendedamt", (Object)suretyBill.getBigDecimal("appendedamt").subtract(appendBill.getBigDecimal("appendamount")));
            suretyBill.set("surplusamount", (Object)suretyBill.getBigDecimal("surplusamount").subtract(appendBill.getBigDecimal("appendamount")));
            List debtBillEntities = SuretyBillHelper.getWriteBackDebit((String)"append", (DynamicObject)appendBill, (boolean)false);
            SaveServiceHelper.save((DynamicObject[])debtBillEntities.toArray(new DynamicObject[0]));
            Map<Long, BigDecimal> debitBillMap = debtBillEntities.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getBigDecimal("totalsuretymoney")));
            DynamicObjectCollection entryCol = suretyBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryCol) {
                if (!DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(entry.getString("debttype")) || !debitBillMap.containsKey(entry.getLong("debtbillid"))) continue;
                entry.set("suretyamount", (Object)debitBillMap.get(entry.getLong("debtbillid")));
            }
            this.releaseCreditLimit(appendBill);
            appendBill.set("amount", (Object)suretyBill.getBigDecimal("amount"));
            suretyList.add(suretyBill);
        }
        SaveServiceHelper.save((DynamicObject[])suretyList.toArray(new DynamicObject[suretyList.size()]));
    }

    private void releaseCreditLimit(DynamicObject appendBill) {
        Map appendDebitBillMaps = appendBill.getDynamicObjectCollection("entry").stream().filter(o -> SuretyStatusEnum.GUARANTING.getValue().equals(o.getString("suretystatus")) && EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("releasecreditamt"))).collect(Collectors.groupingBy(o -> o.getString("debttype"), Collectors.toList()));
        for (Map.Entry entrySet : appendDebitBillMaps.entrySet()) {
            DynamicObject[] debtBills;
            String debtType = entrySet.getKey();
            List appDebitEntry = entrySet.getValue();
            Map<Long, DynamicObject> appDebitMap = appDebitEntry.stream().collect(Collectors.toMap(k -> k.getLong("debtbillid"), v -> v));
            for (DynamicObject debitBill : debtBills = TmcDataServiceHelper.load((String)ProductTypeEnum.getEnumByFormId((String)debtType).getEntity(), (String)String.join((CharSequence)COMMA_CHAR, "id", "billno"), (QFilter[])new QFilter("id", "in", appDebitMap.keySet()).toArray())) {
                DynamicObject appDebit = appDebitMap.get(debitBill.getLong("id"));
                if (EmptyUtil.isEmpty((DynamicObject)appDebit)) continue;
                DynamicObject credit = appDebit.getDynamicObject("credit");
                BigDecimal releaseAmt = appDebit.getBigDecimal("releasecreditamt");
                if (EmptyUtil.isEmpty((DynamicObject)credit) || EmptyUtil.isEmpty((BigDecimal)releaseAmt)) continue;
                CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)appendBill, (DynamicObject)debitBill, (boolean)false, (BigDecimal)releaseAmt, (Long)appendBill.getLong("id"));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            Long suretyBillId = dataEntity.getDynamicObject("suretybill").getLong("id");
            RevenuePlanCalHelper.calRevenuePlan((Long)suretyBillId, (String)"fbd_suretybill", (Map)this.operationVariable);
        }
    }
}

