/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretypreint;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        selector.add("entrys");
        selector.add("entrys.instenddate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> suretyBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject intPreBill : dataEntities) {
            long sourceBillId = intPreBill.getLong("sourcebillid");
            DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)sourceBillId, (String)"fbd_suretybill", (String)"endpreinstdate");
            DynamicObjectCollection rows = intPreBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)rows)) continue;
            Date endPreIntDate = rows.stream().map(r -> r.getDate("instenddate")).max(Date::compareTo).orElseGet(() -> DateUtils.getNextDay((Date)intPreBill.getDate("prestenddate"), (int)-1));
            suretyBill.set("endpreinstdate", (Object)endPreIntDate);
            suretyBillList.add(suretyBill);
        }
        SaveServiceHelper.save((DynamicObject[])suretyBillList.toArray(new DynamicObject[0]));
    }
}

