/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretypreint;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntBatchUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("entry.intbillid");
        selector.add("entry.intdetailnum");
        selector.add("entry.status");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchPreIntBill : dataEntities) {
            this.doLoanPreInt(batchPreIntBill);
            DynamicObjectCollection entrys = batchPreIntBill.getDynamicObjectCollection("entry");
            entrys.forEach(row -> {
                row.set("intbillid", null);
                row.set("intdetailnum", null);
                row.set("status", (Object)"");
            });
        }
    }

    private void doLoanPreInt(DynamicObject batchPreIntBill) {
        DynamicObjectCollection entrys = batchPreIntBill.getDynamicObjectCollection("entry");
        List preInstIds = entrys.stream().map(v -> v.getLong("intbillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(preInstIds)) {
            String entityName = "fbd_surety_preint";
            DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", preInstIds)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)preInterestBills)) {
                return;
            }
            Object[] auditBillIds = preInterestBills.stream().filter(v -> StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())).map(v -> v.getLong("id")).toArray();
            Object[] submitBillIds = preInterestBills.stream().filter(v -> StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.SUBMIT.getValue())).map(v -> v.getLong("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])auditBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])auditBillIds, (OperateOption)OperateOption.create());
            }
            if (EmptyUtil.isNoEmpty((Object[])submitBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])submitBillIds, (OperateOption)OperateOption.create());
            }
            Object[] preIntBillIds = preInterestBills.stream().map(v -> v.getLong("id")).toArray();
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])preIntBillIds, (OperateOption)OperateOption.create());
        }
    }
}

