/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretypreint;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbd.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> suretyBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject intPreBill : dataEntities) {
            long suretyBillId = intPreBill.getLong("sourcebillid");
            Date lastPayIntDate = this.queryNearestPreEndDate(suretyBillId, intPreBill);
            DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillId, (String)"fbd_suretybill", (String)"endpreinstdate");
            suretyBill.set("endpreinstdate", (Object)lastPayIntDate);
            suretyBillList.add(suretyBill);
        }
        SaveServiceHelper.save((DynamicObject[])suretyBillList.toArray(new DynamicObject[0]));
    }

    private Date queryNearestPreEndDate(long billId, DynamicObject intPreBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)billId);
        qFilter.and("id", "!=", intPreBill.getPkValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        qFilter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        DynamicObjectCollection intPreCols = QueryServiceHelper.query((String)intPreBill.getDataEntityType().getName(), (String)"prestenddate", (QFilter[])qFilter.toArray(), (String)"prestenddate desc");
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)intPreCols) ? DateUtils.getNextDay((Date)((DynamicObject)intPreCols.get(0)).getDate("prestenddate"), (int)-1) : null;
    }
}

