/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretystlint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbd.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntBatchAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("revenuetype");
        selector.add("entry");
        selector.add("entry.status");
        selector.add("entry.startdate");
        selector.add("entry.interestamt");
        selector.add("entry.actualinstamt");
        selector.add("entry.intdetail_tag");
        selector.add("entry.loanbillno");
        selector.add("entry.loanbillid");
        selector.add("entry.enddate");
        selector.add("entry.currency");
        selector.add("entry.intbillid");
        selector.add("entry.intdetailnum");
        selector.add("entry.intcomment");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            batchIntBill.getDynamicObjectCollection("entry").stream().forEach(dyn -> this.auditEntrys((DynamicObject)dyn));
            this.writeBackLoanBill(batchIntBill);
        }
    }

    private void auditEntrys(DynamicObject batchIntBill) {
        OperateOption operateOption = OperateOption.create();
        try {
            Object intBillId = batchIntBill.get("intbillid");
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"fbd_surety_settleint", (Object[])new Object[]{intBillId}, (OperateOption)operateOption);
            batchIntBill.set("status", (Object)"success");
        }
        catch (Exception e) {
            batchIntBill.set("status", (Object)"fail");
            batchIntBill.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u6536\u76ca\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"SuretySettleIntBatchAuditService_1", (String)"tmc-fbd-business", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
        }
    }

    private void writeBackLoanBill(DynamicObject batchIntBill) {
        DynamicObjectCollection entrys = batchIntBill.getDynamicObjectCollection("entry");
        List loanNumbers = entrys.stream().map(v -> v.getString("loanbillno")).collect(Collectors.toList());
        DynamicObject[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"billno,endinstdate", (QFilter[])new QFilter[]{new QFilter("billno", "in", loanNumbers)});
        Map<Object, DynamicObject> suretyBillMap = Arrays.stream(suretyBills).collect(Collectors.toMap(v -> v.getString("billno"), v -> v));
        ArrayList succsesSuretyIdList = new ArrayList(suretyBillMap.size());
        entrys.stream().filter(v -> EmptyUtil.isNoEmpty((String)v.getString("loanbillno"))).forEach(row -> {
            String status = row.getString("status");
            if (!StringUtils.equals((CharSequence)"fail", (CharSequence)status)) {
                String loannum = row.getString("loanbillno");
                DynamicObject suretyBill = (DynamicObject)suretyBillMap.get(loannum);
                suretyBill.set("endinstdate", (Object)row.getDate("enddate"));
                succsesSuretyIdList.add(suretyBill.getLong("id"));
            }
        });
        SaveServiceHelper.save((DynamicObject[])suretyBills);
        if (EmptyUtil.isNoEmpty(succsesSuretyIdList)) {
            succsesSuretyIdList.stream().forEach(d -> RevenuePlanCalHelper.calRevenuePlan((Long)d, (String)"fbd_suretybill", (Map)this.operationVariable));
        }
    }
}

