/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretystlint;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntBatchUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("entry.intbillid");
        selector.add("entry.intdetailnum");
        selector.add("entry.status");
        selector.add("entry.intcomment");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            this.doLoanPreInt(batchIntBill);
            DynamicObjectCollection entrys = batchIntBill.getDynamicObjectCollection("entry");
            entrys.forEach(row -> {
                row.set("intbillid", (Object)0);
                row.set("intdetailnum", (Object)"");
                row.set("status", (Object)"");
                row.set("intcomment", (Object)"");
            });
        }
    }

    private void doLoanPreInt(DynamicObject batchIntBill) {
        DynamicObjectCollection entrys = batchIntBill.getDynamicObjectCollection("entry");
        List settleIntIds = entrys.stream().map(v -> v.getLong("intbillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(settleIntIds)) {
            String entityName = "fbd_surety_settleint";
            DynamicObjectCollection settleIntBills = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", settleIntIds)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)settleIntBills)) {
                return;
            }
            Map statusPkMap = settleIntBills.stream().collect(Collectors.groupingBy(v -> v.getString("billstatus"), Collectors.mapping(v -> v.getLong("id"), Collectors.toSet())));
            Set auditBillIds = statusPkMap.get(BillStatusEnum.AUDIT.getValue());
            Set submitBillIds = statusPkMap.get(BillStatusEnum.SUBMIT.getValue());
            if (EmptyUtil.isNoEmpty(auditBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])auditBillIds.toArray(), (OperateOption)OperateOption.create());
            }
            if (EmptyUtil.isNoEmpty(submitBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])submitBillIds.toArray(), (OperateOption)OperateOption.create());
            }
            Object[] settleIntBillIds = settleIntBills.stream().map(v -> v.getLong("id")).toArray();
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])settleIntBillIds, (OperateOption)OperateOption.create());
        }
    }
}

