/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.oppservice.suretystlint;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("revenuetype");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("predictpreinstamt");
        sic.add("actpreinstamt");
        sic.add("surplusamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            String revenueSort = dataEntity.getString("revenuetype");
            if (RevenueTypeEnum.REVENUE.getValue().equals(revenueSort)) {
                this.createByNormalSave(dataEntity);
                continue;
            }
            this.createByBotpSave(dataEntity);
        }
    }

    private void createByNormalSave(DynamicObject dataEntity) {
        Date endDate;
        Date beginDate;
        IntBillInfo intBill;
        Long sourceBillId = dataEntity.getLong("sourcebillid");
        if (EmptyUtil.isNoEmpty((Long)sourceBillId) && (intBill = SuretyIntCalcHelper.callInt((Long)sourceBillId, (Date)(beginDate = dataEntity.getDate("prestartdate")), (Date)(endDate = dataEntity.getDate("bizdate")))) != null) {
            dataEntity.set("predictpreinstamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                SuretyIntCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
            }
        }
    }

    private void createByBotpSave(DynamicObject dataEntity) {
        dataEntity.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        Long suretyReleaseId = dataEntity.getLong("sourcebillid");
        DynamicObject suretyReleaseBill = TmcDataServiceHelper.loadSingle((Object)suretyReleaseId, (String)"fbd_suretyreleasebill");
        Object suretyBillPk = suretyReleaseBill.getDynamicObject("suretybill").getPkValue();
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyBillPk, (String)"fbd_suretybill", (String)"surplusamount,endinstdate,intdate,productfactory");
        DynamicObject productFactory = suretyBill.getDynamicObject("productfactory");
        Date bizDate = dataEntity.getDate("bizdate");
        dataEntity.set("prestartdate", (Object)SuretyIntCalcHelper.getBeginIntDate((DynamicObject)suretyBill));
        dataEntity.set("prestenddate", (Object)SuretyBillHelper.getEndIntDate((DynamicObject)productFactory, (Date)bizDate));
        dataEntity.set("surplusamount", (Object)suretyBill.getBigDecimal("surplusamount"));
        IntBillInfo intBill = SuretyHelper.calcReleaseIntNew((DynamicObject)suretyReleaseBill);
        if (intBill != null) {
            dataEntity.set("predictpreinstamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                SuretyIntCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
            }
        }
    }
}

