/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.attachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AttachmentTypeSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("number");
        selector.add("entryentity");
        selector.add("attachname");
        selector.add("id");
        selector.add("ismustupload");
        selector.add("atoperatenode");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Map numberAndIdMap = new HashMap(8);
        List numberList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getString("number")).collect(Collectors.toList());
        Object[] attachmentTypeList = TmcDataServiceHelper.load((String)"fbd_attachmenttype", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numberList.toArray())});
        if (EmptyUtil.isNoEmpty((Object[])attachmentTypeList)) {
            numberAndIdMap = Arrays.stream(attachmentTypeList).collect(Collectors.toMap(d -> d.getString("number"), d -> d.getLong("id"), (o1, o2) -> o1, HashMap::new));
        }
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            DynamicObject data = dataEntity2.getDataEntity();
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entries)) {
                this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u6709\u9644\u4ef6\u5206\u7c7b\u4fe1\u606f\u3002", (String)"AttachmentTypeSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            int count = 1;
            for (DynamicObject entry : entries) {
                if (entry.getBoolean("ismustupload") && EmptyUtil.isEmpty((String)entry.getString("atoperatenode"))) {
                    this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u9644\u4ef6\u5206\u7c7b\u4fe1\u606f\u7b2c{0}\u884c\u201c\u5fc5\u4f20\u6821\u9a8c\u8282\u70b9\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachmentTypeSaveValidator_3", (String)"tmc-fbd-business", (Object[])new Object[]{count}));
                }
                ++count;
            }
            List<String> repeatAttachNameList = this.getRepeatAttachNameList(data);
            if (EmptyUtil.isNoEmpty(repeatAttachNameList)) {
                StringBuilder res = new StringBuilder();
                for (int i = 0; i < repeatAttachNameList.size(); ++i) {
                    if (i > 0) {
                        res.append("\uff0c");
                    }
                    res.append(repeatAttachNameList.get(i));
                }
                this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u9644\u4ef6\u5206\u7c7b\u540d\u79f0\uff08{0}\uff09\u91cd\u590d\u3002", (String)"AttachmentTypeSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[]{res.toString()}));
            }
            if (!numberAndIdMap.containsKey(data.getString("number")) || data.getLong("id") == ((Long)numberAndIdMap.get(data.getString("number"))).longValue()) continue;
            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"AttachmentTypeSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[]{data.getString("number")}));
        }
    }

    private List<String> getRepeatAttachNameList(DynamicObject data) {
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
        return entries.stream().map(e -> e.getString("attachname")).collect(Collectors.groupingBy(name -> name)).values().stream().filter(l -> l.size() > 1).map(l -> (String)l.get(0)).collect(Collectors.toList());
    }
}

