/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.companyprop;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CompanyManagePropSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("stockentry");
        selector.add("stockentry.proportion");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            BigDecimal sum;
            DynamicObjectCollection entries;
            DynamicObject data = entity.getDataEntity();
            DynamicObject org = data.getDynamicObject("org");
            QFilter filter = new QFilter("org", "=", org.getPkValue());
            filter.and("id", "!=", data.getPkValue());
            DynamicObject exsitProp = TmcDataServiceHelper.loadSingleFromCache((String)"fbd_company_manageprop", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isNoEmpty((DynamicObject)exsitProp)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u6709\u8d44\u91d1\u7ec4\u7ec7\u7ba1\u7406\u5c5e\u6027\u8bb0\u5f55\uff0c\u7f16\u7801\uff1a%s\u3002", (String)"CompanyManagePropSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]), exsitProp.getString("number")));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(entries = data.getDynamicObjectCollection("stockentry"))) || (sum = entries.stream().map(e -> e.getBigDecimal("proportion")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(Constants.ONE_HUNDRED) <= 0) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u80a1\u6743\u5360\u6bd4\u4e4b\u548c\u5e94\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"CompanyManagePropSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

