/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.compare;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class CompareRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entitytypesrc");
        selector.add("entitytypetar");
        selector.add("entryentityorg");
        selector.add("orgconfig");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            DynamicObject srcType = data.getDynamicObject("entitytypesrc");
            DynamicObject tarType = data.getDynamicObject("entitytypetar");
            if (srcType == null || tarType == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6e90\u5355\u7c7b\u578b\u548c\u76ee\u6807\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CompareRuleSaveValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            if (srcType.getPkValue().equals(tarType.getPkValue())) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6e90\u5355\u7c7b\u578b\u548c\u76ee\u6807\u5355\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"CompareRuleSaveValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            String srcName = srcType.getString("name");
            String tarName = tarType.getString("name");
            boolean isForEntireOrg = data.getBoolean("forentireorg");
            QFilter nonSelfFilter = new QFilter("id", "!=", data.getPkValue());
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter srcTypeFilter = new QFilter("entitytypesrc", "=", srcType.getPkValue());
            QFilter tarTypeFilter = new QFilter("entitytypetar", "=", tarType.getPkValue());
            QFilter forEntireOrgFilter = new QFilter("forentireorg", "=", (Object)(isForEntireOrg ? "1" : "0"));
            if (isForEntireOrg) {
                DynamicObjectCollection duplicateDataList = QueryServiceHelper.query((String)"fbd_comparerule", (String)"id, number", (QFilter[])new QFilter[]{nonSelfFilter, enableFilter, srcTypeFilter, tarTypeFilter, forEntireOrgFilter});
                if (duplicateDataList.size() <= 0) continue;
                DynamicObject duplicateData = (DynamicObject)duplicateDataList.get(0);
                String ruleNumber = duplicateData.getString("number");
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d, \u76ee\u6807\u5355\u201c%2$s\u201d\u7684\u5168\u5c40\u5339\u914d\u89c4\u5219\u5b58\u5728, \u7f16\u7801\u4e3a\u201c%3$s\u201d\u3002", (String)"CompareRuleSaveValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]), srcName, tarName, ruleNumber));
                continue;
            }
            List orgIdList = entity.getDataEntity().getDynamicObjectCollection("entryentityorg").stream().map(o -> o.getDynamicObject("orgconfig").getPkValue()).collect(Collectors.toList());
            String orgEntryProp = "entryentityorg.orgconfig";
            String orgNameProp = orgEntryProp + ".name";
            QFilter orgFilter = new QFilter(orgEntryProp, "in", orgIdList);
            DynamicObjectCollection duplicateDataList = QueryServiceHelper.query((String)"fbd_comparerule", (String)("id, number," + orgNameProp), (QFilter[])new QFilter[]{nonSelfFilter, enableFilter, srcTypeFilter, tarTypeFilter, forEntireOrgFilter, orgFilter});
            for (DynamicObject duplicateEntry : duplicateDataList) {
                String ruleNumber = duplicateEntry.getString("number");
                String orgNumber = duplicateEntry.getString(orgNameProp);
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\uff0c\u76ee\u6807\u5355\u201c%2$s\u201d\uff0c\u7ec4\u7ec7\u201c%3$s\u201d\u7684\u5339\u914d\u89c4\u5219\u5b58\u5728\uff0c\u7f16\u7801\u4e3a\u201c%4$s\u201d\u3002", (String)"CompareRuleSaveValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]), srcName, tarName, orgNumber, ruleNumber));
            }
        }
    }
}

