/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.investvarieties;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InvestVarietiesEnableValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String operateByProduct = (String)this.getOption().getVariables().get("operatebyproduct");
        if (EmptyUtil.isNoEmpty((String)operateByProduct)) {
            return;
        }
        List numbers = Arrays.stream(dataEntity).map(v -> v.getDataEntity().getString("number")).collect(Collectors.toList());
        DynamicObjectCollection products = QueryServiceHelper.query((String)"ifm_ldproduct", (String)"enable,number", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        Map<String, DynamicObject> productMap = products.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject investVarieties = extendedDataEntity.getDataEntity();
            DynamicObject product = productMap.get(investVarieties.getString("number"));
            if (EmptyUtil.isEmpty((DynamicObject)product) || product.getBoolean("enable")) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u6295\u8d44\u54c1\u79cd\u5728\u5185\u90e8\u5b9a\u4ef7\u7684\u5b58\u8d37\u6b3e\u4ea7\u54c1\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"InvestVarietiesEnableValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

