/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.release;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ReleaseSourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Push2RecBillValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("releasesource");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject suretyBill = bill.getDynamicObject("suretybill");
            String releaseSource = bill.getString("releasesource");
            boolean isFinAccountFrozen = suretyBill.getBoolean("isfinaccountfrozen");
            if (ReleaseSourceEnum.isSurety((String)releaseSource) && isFinAccountFrozen) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"[%s]\u4fdd\u8bc1\u91d1\u5b58\u51fa\u6d3b\u671f\u8d26\u6237\u51bb\u7ed3\u4e3a\u662f\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"Push2RecBillValidator_1", (String)"tmc-fbd-business", (Object[])new Object[]{bill.getString("billno")}));
            }
            if (!ReleaseSourceEnum.isRepayAll((String)releaseSource) || isFinAccountFrozen || !EmptyUtil.isEmpty((DynamicObject)suretyBill.getDynamicObject("settleaccount"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"[%s]\u62b5\u6263\u5b58\u51fa\u6d3b\u671f\u8d26\u6237\u51bb\u7ed3\u4e14\u4fdd\u8bc1\u91d1\u8d26\u6237\u4e3a\u7a7a\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"Push2RecBillValidator_2", (String)"tmc-fbd-business", (Object[])new Object[]{bill.getString("billno")}));
        }
    }
}

