/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.release;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReleaseSourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyReleaseSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("suretybill");
        selector.add("surplusamount");
        selector.add("amount");
        selector.add("totalamount");
        selector.add("lastreleasedate");
        selector.add("releasedate");
        selector.add("isrevenue");
        selector.add("realrevenue");
        selector.add("releasetype");
        selector.add("releasesource");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            BigDecimal surplusAmount;
            DynamicObject releaseBill = extendData.getDataEntity();
            DynamicObject suretyF7 = releaseBill.getDynamicObject("suretybill");
            if (EmptyUtil.isEmpty((DynamicObject)suretyF7)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyReleaseSubmitValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            Date releaseDate = releaseBill.getDate("releasedate");
            BigDecimal releaseAmount = releaseBill.getBigDecimal("amount");
            BigDecimal totalAmount = releaseBill.getBigDecimal("totalamount");
            boolean isRevenue = releaseBill.getBoolean("isrevenue");
            if (isRevenue) {
                BigDecimal realRevenue = releaseBill.getBigDecimal("realrevenue");
                BigDecimal sum = releaseAmount.add(realRevenue);
                if (EmptyUtil.isEmpty((BigDecimal)realRevenue)) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9e\u9645\u6536\u76ca\u201d\u3002", (String)"SuretyReleaseSubmitValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                } else if (sum.compareTo(totalAmount) != 0) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u83b7\u53d6\u6536\u76ca\u65f6\uff0c\u5b58\u51fa\u91d1\u989d\u4e0e\u5b9e\u9645\u6536\u76ca\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u5408\u8ba1\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuretyReleaseSubmitValidator_10", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
                DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)suretyF7.getPkValue(), (String)"fbd_suretybill", (String)"endinstdate,intdate");
                Optional.ofNullable(suretyBill.getDate("endinstdate")).ifPresent(endInstDate -> {
                    if (releaseDate.compareTo((Date)endInstDate) <= 0) {
                        this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u65e5\u671f\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0a\u6b21\u7ed3\u606f\u65e5\u3002", (String)"SuretyReleaseSubmitValidator_8", (String)"tmc-fbd-business", (Object[])new Object[0]));
                    }
                });
            } else if (releaseAmount.compareTo(totalAmount) != 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u5408\u8ba1\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuretyReleaseSubmitValidator_11", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("suretybill", "=", suretyF7.getPkValue());
            qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and("id", "!=", releaseBill.getPkValue());
            boolean exists = TmcDataServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])qFilter.toArray());
            if (exists) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5b58\u51fa\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"SuretyReleaseSubmitValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (releaseAmount.compareTo(surplusAmount = releaseBill.getBigDecimal("surplusamount")) > 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u53ef\u5b58\u51fa\u91d1\u989d\u3002", (String)"SuretyReleaseSubmitValidator_4", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            Optional.ofNullable(releaseBill.getDate("lastreleasedate")).ifPresent(lastDate -> {
                if (releaseDate.compareTo((Date)lastDate) < 0) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u65e5\u671f\u9700\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0a\u6b21\u5b58\u51fa\u65f6\u95f4\u3002", (String)"SuretyReleaseSubmitValidator_6", (String)"tmc-fbd-business", (Object[])new Object[0]));
                }
            });
            if (ReleaseSourceEnum.isRepayAll((String)releaseBill.getString("releasesource")) && releaseDate.compareTo(suretyF7.getDate("intdate")) <= 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u65e5\u671f\u9700\u5927\u4e8e\u8d77\u606f\u65e5\u3002", (String)"SuretyReleaseSubmitValidator_7", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            if (!ReleaseSourceEnum.isSurety((String)releaseBill.getString("releasesource")) || releaseDate.compareTo(suretyF7.getDate("intdate")) >= 0) continue;
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u51fa\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u8d77\u606f\u65e5\u3002", (String)"SuretyReleaseSubmitValidator_9", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

