/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.release;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbd.common.enums.FbdEntityEnum;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.helper.BusinessHelper;
import kd.tmc.fbd.common.helper.SuretyReleaseBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ReleaseSourceEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class SuretyReleaseUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("suretybill");
        selector.add("releasesource");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            long releaseBillId;
            DynamicObject releaseBill = extendData.getDataEntity();
            boolean isLastRelease = SuretyReleaseBillHelper.isLastReleaseBill((DynamicObject)releaseBill);
            if (!isLastRelease) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u5b58\u51fa\uff0c\u8bf7\u6309\u7167\u65f6\u95f4\u987a\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"SuretyReleaseUnAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
                return;
            }
            String entityName = releaseBill.getDataEntityType().getName();
            String checkPayBillsMsg = BusinessHelper.checkTargetBill((String)entityName, (Long)(releaseBillId = releaseBill.getLong("id")), (String)FbdEntityEnum.CAS_PAYBILL.getValue());
            if (StringUtils.isNotBlank((CharSequence)checkPayBillsMsg)) {
                this.addErrorMessage(extendData, checkPayBillsMsg);
                return;
            }
            String checkRecBillsMsg = BusinessHelper.checkTargetBill((String)entityName, (Long)releaseBillId, (String)FbdEntityEnum.CAS_RECBILL.getValue());
            if (StringUtils.isNotBlank((CharSequence)checkRecBillsMsg)) {
                this.addErrorMessage(extendData, checkRecBillsMsg);
                return;
            }
            boolean isRevenue = releaseBill.getBoolean("isrevenue");
            if (isRevenue) {
                DynamicObject revBill = TmcBotpHelper.getTargetBill((String)entityName, (Object)releaseBillId, (String)"fbd_surety_settleint");
                String lastRevMsg = SuretyReleaseBillHelper.checkIsLastRevenue((Object)releaseBillId, (DynamicObject)revBill, (String)IntDataSource.SETTLEINT.getValue());
                if (EmptyUtil.isNoEmpty((String)lastRevMsg)) {
                    this.addErrorMessage(extendData, lastRevMsg);
                    return;
                }
            }
            if (!ReleaseSourceEnum.isRepayAll((String)releaseBill.getString("releasesource")) || this.getOption().getVariables().containsKey("ignorerepay")) continue;
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u62b5\u6263\u5b58\u51fa\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyReleaseUnAuditValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

