/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretyappend;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyAppendSubmitValidator
extends AbstractTmcBizOppValidator {
    private static final String PERIOD_CHAR = ".";
    private static final String COMMA_CHAR = ",";
    private static final String SYSTEM_TYPE = "tmc-fbd-business";
    private static final String[] entry_prop = new String[]{String.join((CharSequence)".", "entry", "debtbillno"), String.join((CharSequence)".", "entry", "debtamt")};

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("intdate");
        selector.add("billno");
        selector.add("expiredate");
        selector.add("appendintdate");
        selector.add("suretybill");
        selector.add("entry");
        selector.add("entry.appendamt");
        selector.add("releasecreditamt");
        selector.add("appendamount");
        selector.add("appendflag");
        selector.add("debtbillno");
        selector.add("debtamt");
        selector.add("creditamount");
        selector.add("currency");
        selector.add("credit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity append : dataEntity) {
            if (!this.validateAppendDate(append) || !this.validateAppendAmt(append)) continue;
            this.validateReleaseAmt(append);
        }
    }

    private boolean validateAppendAmt(ExtendedDataEntity append) {
        DynamicObject appendEntity = append.getDataEntity();
        if (appendEntity.getBoolean("appendflag")) {
            return false;
        }
        DynamicObjectCollection appendEntryCol = appendEntity.getDynamicObjectCollection("entry");
        for (int rowIdx = 0; rowIdx < appendEntryCol.size(); ++rowIdx) {
            if (!EmptyUtil.isEmpty((BigDecimal)((DynamicObject)appendEntryCol.get(rowIdx)).getBigDecimal("appendamt"))) continue;
            this.addErrorMessage(append, ResManager.loadKDString((String)"\u503a\u52a1\u4fe1\u606f\u5206\u5f55\u7b2c%s\u884c\u201c\u8ffd\u52a0\u91d1\u989d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyAppendSubmitValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[]{rowIdx + 1}));
        }
        BigDecimal totalAppendAmt = appendEntryCol.stream().filter(f -> EmptyUtil.isNoEmpty((BigDecimal)f.getBigDecimal("appendamt"))).map(e -> e.getBigDecimal("appendamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (totalAppendAmt.compareTo(appendEntity.getBigDecimal("appendamount")) > 0) {
            this.addErrorMessage(append, ResManager.loadKDString((String)"\u503a\u52a1\u4fe1\u606f\u5206\u5f55\u8ffd\u52a0\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8be5\u5355\u636e\u7684\u8ffd\u52a0\u91d1\u989d\u3002", (String)"SuretyAppendSubmitValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateReleaseAmt(ExtendedDataEntity append) {
        DynamicObject appendEntity = append.getDataEntity();
        DynamicObjectCollection debitEntries = appendEntity.getDynamicObjectCollection("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)debitEntries)) {
            return;
        }
        DynamicObjectCollection suretyBill = QueryServiceHelper.query((String)"fbd_suretybill", (String)String.join((CharSequence)COMMA_CHAR, entry_prop), (QFilter[])new QFilter[]{new QFilter("id", "=", appendEntity.getDynamicObject("suretybill").getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyBill)) {
            return;
        }
        for (DynamicObject debitEntry : debitEntries) {
            if (EmptyUtil.isEmpty((DynamicObject)debitEntry.getDynamicObject("credit"))) continue;
            String debitBillNo = debitEntry.getString("debtbillno");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("creditlimit", "=", debitEntry.getDynamicObject("credit").getPkValue())).and(new QFilter("sourcebillno", "=", (Object)debitBillNo));
            DynamicObject creditUse = QueryServiceHelper.queryOne((String)"cfm_credituse", (String)"realamt", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)creditUse)) continue;
            BigDecimal creditAmt = creditUse.getBigDecimal("realamt");
            BigDecimal releaseAmt = debitEntry.getBigDecimal("releasecreditamt");
            if (EmptyUtil.isNoEmpty((BigDecimal)creditAmt) && EmptyUtil.isNoEmpty((BigDecimal)releaseAmt) && releaseAmt.compareTo(creditAmt) > 0) {
                this.addErrorMessage(append, ResManager.loadKDString((String)"\u5355\u636e\uff1a%s \u91ca\u653e\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8be5\u5355\u636e\u7684\u6388\u4fe1\u5360\u7528\u91d1\u989d\u3002", (String)"SuretyAppendSubmitValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[]{debitBillNo}));
                return;
            }
            for (DynamicObject surety : suretyBill) {
                if (!debitBillNo.equals(surety.getString(String.join((CharSequence)PERIOD_CHAR, "entry", "debtbillno"))) || debitEntry.getBigDecimal("debtamt").compareTo(surety.getBigDecimal(String.join((CharSequence)PERIOD_CHAR, "entry", "debtamt"))) == 0) continue;
                this.addErrorMessage(append, ResManager.loadKDString((String)"\u5355\u636e\uff1a%s \u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"SuretyAppendSubmitValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[]{debitBillNo}));
                return;
            }
        }
    }

    private boolean validateAppendDate(ExtendedDataEntity extendData) {
        DynamicObject appendEntity = extendData.getDataEntity();
        String billNO = appendEntity.getString("billno");
        Date appendIntDate = appendEntity.getDate("appendintdate");
        if (EmptyUtil.isEmpty((Object)appendEntity.get("suretybill"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5355\u636e\uff1a%s \u8bf7\u5148\u9009\u62e9\u201c\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u636e\u201d\u3002", (String)"SuretyAppendSubmitValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[]{billNO}));
            return false;
        }
        if (appendIntDate.before(extendData.getDataEntity().getDate("intdate"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5355\u636e\uff1a%s \u8ffd\u52a0\u8d77\u606f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u7684\u8d77\u606f\u65e5\u3002", (String)"SuretyAppendSubmitValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[]{billNO}));
            return false;
        }
        if (EmptyUtil.isNoEmpty((Object)extendData.getDataEntity().getDate("expiredate")) && appendIntDate.after(extendData.getDataEntity().getDate("expiredate"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5355\u636e\uff1a%s \u8ffd\u52a0\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u7684\u5230\u671f\u65e5\u3002", (String)"SuretyAppendSubmitValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[]{billNO}));
            return false;
        }
        return true;
    }
}

