/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class SuretyPreIntBatchUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("entry");
        sid.add("intbillid");
        sid.add("intdetailnum");
        sid.add("loanbillid");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject intRevenue = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = intRevenue.getDynamicObjectCollection("entry");
            List collect = entrys.stream().map(s -> s.getLong("loanbillid")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("entry.loanbillid", "in", collect);
            qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)"fbd_surety_preint_batch", (QFilter[])qFilter.toArray());
            if (!exists) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u7684\u6279\u91cf\u9884\u63d0\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyPreIntBatchUnAuditValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

