/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SuretyPreIntOnWayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("loanbillno");
        sic.add("sourcebillid");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if (this.getOption().getVariables().containsKey("redwriteoffop")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preInterestEntity = dataEntity.getDataEntity();
            Date prestartdate = preInterestEntity.getDate("prestartdate");
            long loanBillId = preInterestEntity.getLong("sourcebillid");
            long preintpk = preInterestEntity.getLong("id");
            String loanBillno = preInterestEntity.getString("loanbillno");
            String datasource = preInterestEntity.getString("datasource");
            List<Pair<String, String>> result = SuretyPreIntOnWayValidator.preIntValidate(prestartdate, loanBillId, preintpk, loanBillno, datasource);
            for (Pair<String, String> p : result) {
                this.addMessage(dataEntity, (String)p.getRight(), "error".equals(p.getLeft()) ? ErrorLevel.Error : ErrorLevel.Warning);
            }
        }
    }

    public static List<Pair<String, String>> preIntValidate(Date startinstdate, Long loanbillId, Long preintpk, String loanbillno, String datasource) {
        QFilter datasourceFilter;
        QFilter loanbillnoFilter;
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        QFilter idFilter = new QFilter("id", "!=", (Object)preintpk);
        QFilter submitStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection submitInterestBills = QueryServiceHelper.query((String)"fbd_surety_preint", (String)"billstatus", (QFilter[])new QFilter[]{idFilter, submitStatusFilter, loanbillnoFilter = new QFilter("sourcebillid", "=", (Object)loanbillId), datasourceFilter = new QFilter("datasource", "=", (Object)datasource)});
        if (submitInterestBills.size() >= 1) {
            results.add((Pair<String, String>)Pair.of((Object)"warm", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4fdd\u8bc1\u91d1\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5229\u606f/\u5229\u606f\u9884\u63d0\u8bb0\u5f55\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"SuretyPreIntOnWayValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0])));
        }
        if (EmptyUtil.isNoEmpty((Object)startinstdate)) {
            Date endlastinstdate;
            QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qfilter.and(new QFilter("loanbillno", "=", (Object)loanbillno));
            qfilter.and(new QFilter("datasource", "=", (Object)datasource));
            qfilter.and(new QFilter("writeoffstatus", "not in", Arrays.asList("writeoff", "red_writeoff")));
            qfilter.and(new QFilter("id", "!=", (Object)preintpk));
            DynamicObjectCollection preintBills = QueryServiceHelper.query((String)"fbd_surety_preint", (String)"prestenddate", (QFilter[])qfilter.toArray(), (String)"prestenddate desc");
            if (EmptyUtil.isNoEmpty((Integer)preintBills.size()) && (endlastinstdate = ((DynamicObject)preintBills.get(0)).getDate("prestenddate")) != null) {
                String endlastinstdateStr;
                String pageStartInstDateStr = DateUtils.formatString((Date)startinstdate, (String)"yyyyMMdd");
                Date newStartInstDate = DateUtils.getNextDay((Date)endlastinstdate, (int)1);
                String newStartInstDateStr = DateUtils.formatString((Date)newStartInstDate, (String)"yyyyMMdd");
                List<String> newStartInstDateVals = Arrays.asList(newStartInstDateStr, endlastinstdateStr = DateUtils.formatString((Date)endlastinstdate, (String)"yyyyMMdd"));
                if (!newStartInstDateVals.contains(pageStartInstDateStr)) {
                    results.add((Pair<String, String>)Pair.of((Object)"error", (Object)ResManager.loadKDString((String)"\u9884\u63d0\u5355\u8d77\u606f\u65e5\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5728\u5355\u636e\u9875\u9762\u786e\u8ba4\u540e\u63d0\u4ea4\u3002", (String)"SuretyPreIntOnWayValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0])));
                }
            }
        }
        return results;
    }
}

