/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbd.business.validate.suretypreint.SuretyPreIntSaveValidator;
import kd.tmc.fbd.common.helper.SuretyIntValidateHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntSubmitValidator
extends SuretyPreIntSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("sourcebillid");
        return sic;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if (this.getOption().getVariables().containsKey("redwriteoffop")) {
            return;
        }
        Map repeatLoanMap = SuretyIntValidateHelper.valiRepeatSubmit((ExtendedDataEntity[])dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long loanBillId;
            DynamicObject preInterestEntity = dataEntity.getDataEntity();
            BigDecimal actualInstAmt = preInterestEntity.getBigDecimal("actpreinstamt");
            if (EmptyUtil.isEmpty((BigDecimal)actualInstAmt)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u9645\u9884\u63d0\u5229\u606f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SuretyPreIntSubmitValidator_00", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (!repeatLoanMap.containsKey(loanBillId = preInterestEntity.getLong("sourcebillid"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4fdd\u8bc1\u91d1\u4e0b\u7684\u5229\u606f/\u5229\u606f\u9884\u63d0\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u63d0\u4ea4\u3002", (String)"SuretyPreIntSubmitValidator_01", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

