/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbd.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("loanbillno");
        sic.add("billstatus");
        sic.add("writeoffstatus");
        sic.add("prestenddate");
        sic.add("chargeinstid");
        sic.add("operatetype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preInstEntity = dataEntity.getDataEntity();
            String billstatus = preInstEntity.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus)) continue;
            if (PreIntOperateTypeEnum.REVERSEINT.getValue().equals(preInstEntity.getString("operatetype"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u9884\u63d0\u5229\u606f\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyPreIntUnAuditValidator_0", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            String writeOffStatus = preInstEntity.getString("writeoffstatus");
            if (WriteOffStatusEnum.WRITEOFF.getValue().equals(writeOffStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u51b2\u9500\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyPreIntUnAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            String loanbillno = preInstEntity.getString("loanbillno");
            QFilter loanbillnoFilter = new QFilter("loanbillno", "=", (Object)loanbillno);
            loanbillnoFilter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue()));
            loanbillnoFilter.and(new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue()));
            loanbillnoFilter.and(new QFilter("datasource", "=", (Object)IntDataSource.PREINT.getValue()));
            DynamicObjectCollection preInterestBills = QueryServiceHelper.query((String)"fbd_surety_preint", (String)"id", (QFilter[])new QFilter[]{loanbillnoFilter}, (String)"prestartdate  desc");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)preInterestBills) || ((DynamicObject)preInterestBills.get(0)).get("id").equals(preInstEntity.getPkValue())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u5229\u606f\u9884\u63d0\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretyPreIntUnAuditValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

