/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretypreint;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyPreIntUnRedWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbillno");
        sic.add("prestartdate");
        sic.add("prestenddate");
        sic.add("billstatus");
        sic.add("operatetype");
        sic.add("writeoffpreintbillid");
        sic.add("writeoffstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject preIntBill = dataEntity.getDataEntity();
            if (!PreIntOperateTypeEnum.REVERSEINT.getValue().equals(preIntBill.getString("operatetype"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u5229\u606f\u624d\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"SuretyPreIntUnRedWriteOffValidator_01", (String)"tmc-fbd-business", (Object[])new Object[0]));
                continue;
            }
            QFilter preQF = new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue());
            preQF.and("datasource", "=", (Object)IntDataSource.PREINT.getValue());
            preQF.and(new QFilter("loanbillno", "=", (Object)preIntBill.getString("loanbillno")));
            DynamicObjectCollection redPrebills = QueryServiceHelper.query((String)preIntBill.getDataEntityType().getName(), (String)"id,prestenddate", (QFilter[])preQF.toArray(), (String)"prestenddate desc");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)redPrebills) || ((DynamicObject)redPrebills.get(0)).get("id").equals(preIntBill.getPkValue())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540e\u7eed\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u5229\u606f\u7684\u9884\u63d0\u5355\u4e0d\u80fd\u53cd\u51b2\u9500\u3002", (String)"SuretyPreIntUnRedWriteOffValidator_02", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

