/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretystlint;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntPushRecValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuetype");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extData : extendedDataEntities) {
            QFilter filter;
            DynamicObjectCollection recBills;
            Object[] targetBillIds;
            DynamicObject releaseBill;
            DynamicObject revenueBill = extData.getDataEntity();
            String revenueType = revenueBill.getString("revenuetype");
            if (RevenueTypeEnum.RELEASE_REV.getValue().equals(revenueType) && EmptyUtil.isNoEmpty((DynamicObject)(releaseBill = TmcBotpHelper.getSourceBill((String)"fbd_surety_settleint", (Object)revenueBill.getPkValue(), (String)"fbd_suretyreleasebill"))) && releaseBill.getBoolean("isrevenue")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u51fa\u5355\u5f00\u542f\u83b7\u53d6\u6536\u76ca\u65f6\uff0c\u6536\u76ca\u5355\u4e0d\u5141\u8bb8\u4e0b\u63a8\u6536\u6b3e\u5355\u3002", (String)"SuretySettleIntPushRecValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (!BillStatusEnum.isAudit((String)revenueBill.getString("billstatus"))) {
                this.addErrorMessage(extData, String.format(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"SuretySettleIntPushRecValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]), new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object[])(targetBillIds = TmcBotpHelper.getTargetBillIds((String)revenueBill.getDataEntityType().getName(), (Object)revenueBill.getLong("id"), (String)"cas_recbill"))) || (recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"billno", (QFilter[])(filter = new QFilter("id", "in", (Object)targetBillIds).and("billstatus", "not in", Arrays.asList("G", "F"))).toArray())).isEmpty() && !revenueBill.getBoolean("ispushrec")) continue;
            String billNos = recBills.stream().map(p -> p.getString("billno")).collect(Collectors.joining(","));
            this.addMessage(extData, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u6709\u4e0b\u6e38\u6536\u6b3e\u5904\u7406\u5355\u636e[%s]\u3002", (String)"SuretySettleIntPushRecValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]), billNos));
        }
    }
}

