/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.business.validate.suretystlint;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.helper.SuretyReleaseBillHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretySettleIntUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("revenuetype");
        sid.add("sourcebillid");
        sid.add("id");
        sid.add("billno");
        sid.add("prestenddate");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject targetBill;
            Long sourceBillId;
            String checkRev;
            DynamicObject revenue = dataEntity.getDataEntity();
            String revenueType = revenue.getString("revenuetype");
            if (RevenueTypeEnum.RELEASE_REV.getValue().equals(revenueType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u51fa\u6536\u76ca\u7c7b\u578b\u7684\u6536\u76ca\u5355\u636e\u6b64\u5904\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SuretySettleIntUnAuditValidator_1", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)(checkRev = SuretyReleaseBillHelper.checkIsLastRevenue((Object)(sourceBillId = Long.valueOf(revenue.getLong("sourcebillid"))), (DynamicObject)revenue, (String)IntDataSource.SETTLEINT.getValue())))) {
                this.addErrorMessage(dataEntity, checkRev);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(targetBill = TmcBotpHelper.getTargetBill((String)"fbd_surety_settleint", (Object)revenue.getPkValue(), (String)"cas_recbill")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u6536\u6b3e\u5355\u5173\u8054\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u505a\u53cd\u5ba1\u6838\u3002", (String)"SuretySettleIntUnAuditValidator_2", (String)"tmc-fbd-business", (Object[])new Object[0]));
            }
            Date endInstDate = revenue.getDate("prestenddate");
            QFilter idFilter = new QFilter("id", "=", (Object)sourceBillId);
            DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)String.join((CharSequence)",", "lastreleasedate", "bizstatus"), (QFilter[])idFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)suretyBill) || !SuretyBizStatusEnum.SURETY_PART.getValue().equals(suretyBill.getString("bizstatus")) && !SuretyBizStatusEnum.SURETY_END.getValue().equals(suretyBill.getString("bizstatus")) || endInstDate.compareTo(suretyBill.getDate("lastreleasedate")) >= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u662f\u5df2\u5b58\u51fa\u6216\u8005\u90e8\u5206\u5b58\u51fa\u65f6\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u5b58\u51fa\u65e5\u671f\u4e4b\u524d\u7684\u6536\u76ca\u5355\u3002", (String)"SuretySettleIntUnAuditValidator_3", (String)"tmc-fbd-business", (Object[])new Object[0]));
        }
    }
}

