/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.bd;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOpLogShowHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcBaseDataEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(TmcBaseDataEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvi();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            IBillModel model = (IBillModel)this.getModel();
            if (model.getProperty("company") != null && this.getView().getControl("company") != null) {
                DynamicObject currentOrg;
                List orgs;
                String orgIds;
                if (this.getView().getFormShowParameter().getCustomParams().containsKey("selectedFilterOrgs") && EmptyUtil.isNoEmpty((String)(orgIds = (String)this.getView().getFormShowParameter().getCustomParams().get("selectedFilterOrgs"))) && (orgs = (List)JSON.parseObject((String)orgIds, List.class)) != null && orgs.size() == 1) {
                    this.getModel().setValue("company", orgs.get(0));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(currentOrg = (DynamicObject)this.getModel().getValue("company"))) && !currentOrg.getBoolean("fisbankroll")) {
                    this.getModel().setValue("company", null);
                }
                if (EmptyUtil.isEmpty((DynamicObject)currentOrg)) {
                    String appId = this.getView().getFormShowParameter().getAppId();
                    currentOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                    this.getModel().setValue("company", currentOrg.getPkValue());
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)currentOrg) && model.getProperty("openorg") != null && this.getView().getControl("openorg") != null) {
                    DynamicObject accountOrg = TmcOrgDataHelper.getAccountOrgByFundsOrg((DynamicObject)currentOrg);
                    if (!EmptyUtil.isEmpty((DynamicObject)accountOrg)) {
                        this.getModel().setValue("openorg", accountOrg.getPkValue());
                    } else {
                        this.getModel().setValue("openorg", null);
                    }
                }
            }
            if (model.getProperty("status") == null) {
                model.setValue("status", (Object)BillStatusEnum.SAVE.getValue());
            }
            if (model.getProperty("enable") == null) {
                model.setValue("enable", (Object)BaseEnableEnum.ENABLE.getValue());
            }
        }
        catch (Exception error) {
            logger.error("TmcBaseDataEdit.afterCreateNewData error: \n", (Throwable)error);
        }
    }

    protected void initControlEvi() {
        BasedataEdit openorg;
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                String appId = this.getView().getFormShowParameter().getAppId();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                showParameter.setCustomParam("range", (Object)orgIdSet);
            });
        }
        if (this.getModel().getProperty("openorg") != null && (openorg = (BasedataEdit)this.getControl("openorg")) != null) {
            openorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                String appId = this.getView().getFormShowParameter().getAppId();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                showParameter.setCustomParam("range", (Object)orgIdSet);
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barlog": {
                Object number = this.getModel().getValue("number");
                FormShowParameter showPara = TmcOpLogShowHelper.create((String)this.getModel().getDataEntityType().getAppId(), (String)this.getModel().getDataEntityType().getName(), (Object)number);
                this.getView().showForm(showPara);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "company": {
                DynamicObject currentOrg = (DynamicObject)this.getModel().getValue("company");
                if (this.getView().getControl("openorg") == null || !EmptyUtil.isNoEmpty((DynamicObject)currentOrg)) break;
                DynamicObject accountOrg = TmcOrgDataHelper.getAccountOrgByFundsOrg((DynamicObject)currentOrg);
                if (!EmptyUtil.isEmpty((DynamicObject)accountOrg)) {
                    this.getModel().setValue("openorg", accountOrg.getPkValue());
                    break;
                }
                this.getModel().setValue("openorg", null);
                break;
            }
        }
    }

    protected String getDataEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    protected String getPermissionItem() {
        return "47156aff000000ac";
    }
}

