/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.bill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TmcBaseBillList
extends AbstractTmcBillBaseList {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isOpenByHyperlink()) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            e.setQFilters(qFilters);
        } else if (EmptyUtil.isNoEmpty((String)this.getPrimaryOrgId())) {
            QFilter filter2;
            List filters = e.getQFilters();
            this.initSelectCurrentOrg(filters);
            for (QFilter filter2 : filters) {
                if (!filter2.getProperty().equals(this.getPrimaryOrgId())) continue;
                return;
            }
            String mainOrg = EntityMetadataCache.getDataEntityType((String)this.getDataEntityName()).getMainOrg();
            if (EmptyUtil.isEmpty((String)mainOrg) && (filter2 = this.initFilterForAuthorizedOrg()) != null) {
                e.setMainOrgQFilter(filter2);
            }
        }
    }

    private void initSelectCurrentOrg(List<QFilter> filters) {
        List<Long> selOrgs = new ArrayList<Long>();
        if (filters != null && filters.size() > 0) {
            for (QFilter filter : filters) {
                if (!filter.getProperty().equals(this.getPrimaryOrgId())) continue;
                if (filter.getValue() instanceof Long) {
                    selOrgs.add((Long)filter.getValue());
                    break;
                }
                if (!(filter.getValue() instanceof List)) break;
                selOrgs = (List)filter.getValue();
                break;
            }
        }
        this.getPageCache().put("selectedFilterOrgs", JSON.toJSONString(selOrgs));
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().getCustomParams().put("selectedFilterOrgs", this.getPageCache().get("selectedFilterOrgs"));
        super.beforeShowBill(e);
    }

    private QFilter initFilterForAuthorizedOrg() {
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityId = this.getDataEntityName();
        if ("bd_accountbanks".equals(entityId) && !"cas".equals(appId) && !"am".equals(appId)) {
            appId = null;
        }
        if (EmptyUtil.isNoEmpty((String)appId)) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)entityId, (String)this.getPermissionItem());
            return new QFilter(this.getPrimaryOrgId(), "in", (Object)orgIdList);
        }
        return null;
    }

    protected String getPrimaryOrgId() {
        return "company.id";
    }

    private boolean isOpenByHyperlink() {
        Boolean isDefaultOpen = (Boolean)this.getView().getFormShowParameter().getCustomParam("isopenbyhyperlink");
        if (isDefaultOpen != null) {
            return isDefaultOpen;
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_operlog": {
                this.OnlineQueryClick();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Long selectedId;
        super.afterDoOperation(args);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("showlog".equals(operateKey) && EmptyUtil.isNoEmpty((Long)(selectedId = this.getSelectedId()))) {
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ListSelectedRow selectedRow = selectedRows.get(0);
            String billNo = selectedRow.getBillNo();
            ListShowParameter sp = ShowFormHelper.createShowListForm((String)"bei_banklog", (boolean)false);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            sp.getOpenStyle().setInlineStyleCss(null);
            sp.setFormId("bos_list");
            sp.getListFilterParameter().setFilter(new QFilter("entryentity.e_billnumber", "=", (Object)billNo).and(new QFilter("entryentity.e_billtype", "=", (Object)billList.getEntityId())));
            sp.getCustomParams().put("trackBillNo", billNo);
            this.getView().showForm((FormShowParameter)sp);
        }
    }

    private void OnlineQueryClick() {
        List<Long> idList = this.getSelectedIdList();
        this.showOnLineQueryFrm(idList);
    }

    private void showOnLineQueryFrm(List<Long> idList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("tmc_operationlog");
        parameter.getCustomParams().put("biz_obj", idList);
        this.getView().showForm(parameter);
    }
}

