/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractCreditLimitEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String CREDITLIMIT = "creditlimit";
    protected static final String CREDITAMT = "creditamt";
    protected static final String CREDITRATE = "creditrate";
    protected static final String CREDITCHOOSE = "CREDITCHOOSE";

    public void registerListener(EventObject e) {
        for (String prop : this.getCreditlimiFieldMap().keySet()) {
            BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl(prop);
            if (!EmptyUtil.isNoEmpty((Object)creditLimitEdit)) continue;
            creditLimitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject creditLimit;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (("submit".equals(op.getOperateKey()) || "save".equals(op.getOperateKey())) && EmptyUtil.isNoEmpty((DynamicObject)(creditLimit = (DynamicObject)this.getModel().getValue(CREDITLIMIT))) && this.getPageCache().get(CREDITCHOOSE) == null) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("id"))) {
                this.getModel().setValue("id", (Object)DBServiceHelper.genGlobalLongId());
            }
            QFilter filter = new QFilter(CREDITLIMIT, "=", creditLimit.getPkValue());
            filter.and(new QFilter("sourcebillid", "=", this.getModel().getValue("id")));
            boolean isExist = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])filter.toArray());
            if (!isExist || this.isSubmitReCreate()) {
                CreditLimitUseBean useBean = this.getCreditLimitUseInfo(CREDITLIMIT);
                useBean.setPreOccupy(Boolean.valueOf("save".equals(op.getOperateKey())));
                useBean.setCreditLimitNo(creditLimit.getString("number"));
                CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        String prop = e.getActionId();
        if (this.getCreditlimiFieldMap().containsKey(prop) && (returnData = e.getReturnData()) instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            String entry = this.getCreditlimiFieldMap().get(prop);
            if (EmptyUtil.isNoEmpty((String)entry)) {
                int currIdx = this.getModel().getEntryCurrentRowIndex(entry);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)prop, null, (int)currIdx);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)prop, (Object)res.getCreditLimitId(), (int)currIdx);
                Optional.ofNullable(this.getCreditUseAmtField()).ifPresent(amtField -> TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)amtField, (Object)res.getExchangeAmt(), (int)currIdx));
                Optional.ofNullable(this.getCreditUseCurrencyField()).ifPresent(currencyField -> TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)currencyField, (Object)res.getTargetCurrencyId(), (int)currIdx));
            } else {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)prop, null);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)prop, (Object)res.getCreditLimitId());
                Optional.ofNullable(this.getCreditUseAmtField()).ifPresent(amtField -> TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)amtField, (Object)res.getExchangeAmt()));
                Optional.ofNullable(this.getCreditUseCurrencyField()).ifPresent(currencyField -> TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)currencyField, (Object)res.getTargetCurrencyId()));
            }
            this.getPageCache().put(CREDITAMT, String.valueOf(res.getRealBizAmt()));
            this.getPageCache().put(CREDITRATE, String.valueOf(res.getTransScale()));
            this.getPageCache().put(CREDITCHOOSE, CREDITCHOOSE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "creditlimit": {
                Object creditLimit = this.getModel().getValue(CREDITLIMIT);
                if (creditLimit != null) break;
                this.getPageCache().remove(CREDITCHOOSE);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.getCreditlimiFieldMap().containsKey(key)) {
            String sourceMethod = evt.getSourceMethod();
            if ("getLookUpList".equals(sourceMethod) || "setItemByNumber".equals(sourceMethod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6253\u5f00\u5217\u8868\u9009\u62e9\u3002", (String)"AbstractCreditLimitEditPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                this.getModel().setValue(key, null);
                return;
            }
            this.creditLimitF7Evt(evt);
        }
    }

    protected void creditLimitF7Evt(BeforeF7SelectEvent evt) {
        String prop = evt.getProperty().getName();
        if (!this.checkCreditlimitParams()) {
            evt.setCancel(true);
            return;
        }
        CreditLimitUseBean creditLimitUse = this.getCreditLimitUseInfo(prop);
        FormShowParameter sp = evt.getFormShowParameter();
        sp.setCustomParam("KEY_F7PARAM", (Object)creditLimitUse);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, prop));
    }

    protected CreditLimitUseBean getCreditLimitUseInfo(String fieldF7) {
        Object orgObj;
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id.equals(0L)) {
            id = DB.genLongId((String)this.getModel().getDataEntityType().getName());
            this.getModel().setValue("id", (Object)id);
        }
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(id);
        useBean.setEntityName(this.getModel().getDataEntityType().getName());
        useBean.setCreditFinType(this.creditType());
        if (this.getEntityName() != null) {
            useBean.setEntityName(this.getEntityName());
        }
        if ((orgObj = this.getValueFromPropertys("org", fieldF7)) instanceof DynamicObject) {
            useBean.setOrgId(Long.valueOf(((DynamicObject)orgObj).getLong("id")));
        } else {
            useBean.setOrgId(Long.valueOf(Long.parseLong(String.valueOf(orgObj))));
        }
        IDataEntityProperty finorgProp = this.getModel().getProperty(this.getBizPropertys().get("finorg"));
        if ("Long".equals(finorgProp.getPropertyType().getSimpleName())) {
            useBean.setFinOrgId((Long)this.getValueFromPropertys("finorg", fieldF7));
        } else {
            DynamicObject finorg = (DynamicObject)this.getValueFromPropertys("finorg", fieldF7);
            useBean.setFinOrgId(Long.valueOf(finorg != null ? (Long)finorg.getPkValue() : 0L));
        }
        DynamicObject currency = (DynamicObject)this.getValueFromPropertys("currency", fieldF7);
        useBean.setCurrencyId(Long.valueOf(currency != null ? (Long)currency.getPkValue() : 0L));
        useBean.setCreditTypeId(this.getCreditTypeId());
        useBean.setCreditVariety(this.getCreditVariety());
        useBean.setPreOccupy(Boolean.valueOf(this.isPreOccupy()));
        useBean.setSourceBillId(this.getSourceBillId());
        useBean.setSourceType(this.getSourceType());
        useBean.setSourceBillEntryId(this.getSourceBillEntryId(fieldF7, id));
        useBean.setStartDate((Date)this.getValueFromPropertys("startDate", fieldF7));
        useBean.setEndDate((Date)this.getValueFromPropertys("endDate", fieldF7));
        useBean.setMaxAmt(this.getAmount());
        useBean.setCreditRatio(this.setCreditRatio());
        useBean.setBizAmt(this.getAmount());
        if (this.getPageCache().getAll().containsKey(CREDITRATE)) {
            useBean.setRealScale(new BigDecimal(this.getPageCache().get(CREDITRATE)));
        }
        String entry = this.getCreditlimiFieldMap().get(fieldF7);
        DynamicObject creditLimit = null;
        if (EmptyUtil.isNoEmpty((String)entry)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
            creditLimit = (DynamicObject)this.getModel().getValue(fieldF7, entryCurrentRowIndex);
        } else {
            creditLimit = (DynamicObject)this.getModel().getValue(fieldF7);
        }
        useBean.setCreditLimitId(creditLimit != null ? Long.valueOf(creditLimit.getLong("id")) : null);
        return useBean;
    }

    private Object getValueFromPropertys(String prop, String fieldF7) {
        String entry = this.getCreditlimiFieldMap().get(fieldF7);
        String bizProp = this.getBizPropertys().get(prop);
        if (EmptyUtil.isEmpty((String)bizProp)) {
            return null;
        }
        if (EmptyUtil.isNoEmpty((String)entry) && this.getEntryFields().contains(bizProp)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
            return this.getModel().getValue(bizProp, entryCurrentRowIndex);
        }
        return this.getModel().getValue(bizProp);
    }

    protected void setCreditUseFields() {
        if (EmptyUtil.isEmpty((String)this.getCreditUseAmtField())) {
            return;
        }
        Long id = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        DynamicObjectCollection creditUses = this.loadCreditUse(id);
        if (creditUses == null || creditUses.size() == 0) {
            creditUses = this.loadCreditUse(this.getCreditUseSrcBillId());
        }
        if (creditUses == null || creditUses.size() == 0) {
            return;
        }
        DynamicObject creditUse = (DynamicObject)creditUses.get(0);
        if (id.equals(creditUse.getLong("sourcebillentryid"))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getCreditUseAmtField(), (Object)creditUse.getBigDecimal("realamt"));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getCreditUseCurrencyField(), (Object)creditUse.get("currency"));
        } else {
            this.entryCreditUse(creditUses);
        }
    }

    private void entryCreditUse(DynamicObjectCollection creditUses) {
        Map<String, String> creditEntryMap = this.getCreditlimiFieldMap();
        if (creditEntryMap == null || creditEntryMap.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> entryIdUseMap = creditUses.stream().collect(Collectors.toMap(cr -> cr.getLong("sourcebillentryid"), cr -> cr, (v1, v2) -> v2));
        for (Map.Entry<String, String> mapEntry : creditEntryMap.entrySet()) {
            String entryName = mapEntry.getValue();
            if (EmptyUtil.isEmpty((String)entryName)) continue;
            DynamicObjectCollection creditEntry = this.getModel().getEntryEntity(entryName);
            int rowCount = creditEntry.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject row = (DynamicObject)creditEntry.get(i);
                DynamicObject creditEntryUse = entryIdUseMap.get(row.getLong("id"));
                if (EmptyUtil.isEmpty((DynamicObject)creditEntryUse)) continue;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getCreditUseAmtField(), (Object)creditEntryUse.getBigDecimal("realamt"), (int)i);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)this.getCreditUseCurrencyField(), (Object)creditEntryUse.get("currency"), (int)i);
            }
        }
    }

    private boolean isEntry(String fieldF7) {
        String entry = this.getCreditlimiFieldMap().get(fieldF7);
        return EmptyUtil.isNoEmpty((String)entry);
    }

    protected Long getSourceBillEntryId(String fieldF7, Long id) {
        if (this.isEntry(fieldF7)) {
            String entry = this.getCreditlimiFieldMap().get(fieldF7);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(entry, entryCurrentRowIndex);
            if (EmptyUtil.isEmpty((Object)rowEntity.getPkValue())) {
                id = DB.genLongId((String)this.getModel().getDataEntityType().getName());
                rowEntity.set("id", (Object)id);
                return id;
            }
            return rowEntity.getLong("id");
        }
        return id;
    }

    protected abstract Map<String, String> getBizPropertys();

    protected abstract Long getCreditTypeId();

    protected Long getSourceBillId() {
        return null;
    }

    protected String getSourceType() {
        return null;
    }

    protected String getCreditVariety() {
        return null;
    }

    protected abstract BigDecimal setCreditRatio();

    protected abstract BigDecimal getAmount();

    public boolean isPreOccupy() {
        return false;
    }

    public boolean isSubmitReCreate() {
        return false;
    }

    public boolean checkCreditlimitParams() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{this.getBizPropertys().get("org"), this.getBizPropertys().get("finorg"), this.getBizPropertys().get("currency"), this.getBizPropertys().get("amount")});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isDataChange = this.getModel().getDataChanged();
        this.initCreditLimitData();
        this.setCreditUseFields();
        this.getModel().setDataChanged(isDataChange);
    }

    protected void initCreditLimitData() {
        QFilter filter;
        DynamicObject creditUseBill;
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue(CREDITLIMIT);
        Long letterCreditId = this.getCreditUseSrcBillId();
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit) && EmptyUtil.isNoEmpty((Long)letterCreditId) && EmptyUtil.isNoEmpty((DynamicObject)(creditUseBill = TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"creditrate,realamt,bizcurrency", (QFilter[])(filter = new QFilter("sourcebillid", "=", (Object)letterCreditId)).toArray())))) {
            BigDecimal creditRate = creditUseBill.getBigDecimal(CREDITRATE);
            BigDecimal creditAmt = creditUseBill.getBigDecimal("realamt");
            this.getPageCache().put(CREDITAMT, String.valueOf(creditAmt));
            this.getPageCache().put(CREDITRATE, String.valueOf(creditRate));
        }
    }

    protected String getEntityName() {
        return null;
    }

    protected Map<String, String> getCreditlimiFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(1);
        fieldMap.put(CREDITLIMIT, "");
        return fieldMap;
    }

    protected Set<String> getEntryFields() {
        return new HashSet<String>();
    }

    protected String creditType() {
        return CreditFinTypeEnum.FINORG.getValue();
    }

    protected String getCreditUseAmtField() {
        return null;
    }

    protected String getCreditUseCurrencyField() {
        return null;
    }

    protected Long getCreditUseSrcBillId() {
        return null;
    }

    private DynamicObjectCollection loadCreditUse(Long sourceBillId) {
        if (EmptyUtil.isEmpty((Long)sourceBillId)) {
            return null;
        }
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId).and(new QFilter("isrelease", "=", (Object)"0")).and(new QFilter("creditlimit.isclose", "=", (Object)"0"));
        return QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])new QFilter[]{qFilter});
    }
}

