/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcLicenseControlPlugin
extends AbstractFormPlugin {
    private static final Map<String, List> licenseGroup = new HashMap<String, List>(){
        {
            this.put("PRO", Arrays.asList("cfm", "creditm"));
            this.put("PRO_BEI", Collections.singletonList("bei"));
        }
    };

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (this.isRequestCheckLicense(e)) {
            this.checkLicense(e);
        }
    }

    private void checkLicense(PreOpenFormEventArgs e) {
        String appId = e.getFormShowParameter().getAppId();
        if (EmptyUtil.isEmpty((String)appId)) {
            appId = "creditm";
        }
        Long userId = RequestContext.get().getCurrUserId();
        String version = LicenseServiceHelper.getProductVersion();
        if ("4.0".equals(version)) {
            String formId = this.getFormId(e);
            String bizObjId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
            LicenseCheckResult checkResult = LicenseServiceHelper.checkByAppAndBizObj((String)appId, (String)bizObjId, (Long)userId);
            e.setCancel(checkResult.getHasLicense() == false);
            e.setCancelMessage(checkResult.getMsg());
        }
    }

    private String getLicenseGroup(String appId) {
        Object[] group = licenseGroup.entrySet().stream().filter(e -> ((List)e.getValue()).contains(appId)).map(Map.Entry::getKey).toArray();
        if (EmptyUtil.isEmpty((Object[])group)) {
            return "PRO";
        }
        return (String)group[0];
    }

    private String getFormId(PreOpenFormEventArgs e) {
        if (e.getSource() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)e.getSource();
            return parameter.getBillFormId();
        }
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        return parameter.getFormId();
    }

    private boolean isRequestCheckLicense(PreOpenFormEventArgs e) {
        return e.getSource() instanceof ListShowParameter;
    }
}

