/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcSelectFieldListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String FormId_SelectField = "tmc_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectNodeType = "selectNodeType";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    private static final String CacheKey_SelectedNodeIds = "nodeids";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                String selectNodeType = this.getSelectNodeType();
                if (currNodeId.contains(",")) {
                    String[] split = currNodeId.split(",");
                    boolean isLeafNode = split[1].contains(".");
                    if (!isLeafNode && "leafNode".equals(selectNodeType)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u53f6\u5b50\u8282\u70b9\u6570\u636e\u3002", (String)"TmcSelectFieldListPlugin_01", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (isLeafNode && "noLeafNode".equals(selectNodeType)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u975e\u53f6\u5b50\u8282\u70b9\u6570\u636e\u3002", (String)"TmcSelectFieldListPlugin_02", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put("nodeids", currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put("nodeids", cacheNodeIds);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        this.setNodeId(rootNode);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        ((TreeNode)rootNode.getChildren().get(0)).getChildren();
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
            String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
            if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
                this.getPageCache().put("nodeids", cacheNodeIds);
                String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (String nodeId : arr) {
                    TreeNode node = rootNode.getTreeNode(nodeId, 5);
                    if (node == null) continue;
                    selectedNodes.add(node);
                }
                if (selectedNodes.size() > 0) {
                    tree.checkNodes(selectedNodes);
                }
            }
        }
    }

    private void setNodeId(TreeNode treeNode) {
        String parentName = treeNode.getText() + ".";
        if (EmptyUtil.isEmpty((String)treeNode.getParentid())) {
            treeNode.setId("0");
            parentName = "";
        } else {
            treeNode.setId(treeNode.getId() + "," + treeNode.getText());
        }
        List childNodes = treeNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)childNodes)) {
            for (TreeNode childNode : childNodes) {
                if (!CollectionUtils.isEmpty((Collection)childNode.getChildren())) {
                    this.setNodeId(childNode);
                    continue;
                }
                childNode.setId(childNode.getId() + "," + parentName + childNode.getText());
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"SelectFieldList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    private String getSelectNodeType() {
        Object selectNodeType = this.getView().getFormShowParameter().getCustomParam(CustParamKey_SelectNodeType);
        return EmptyUtil.isEmpty((Object)selectNodeType) ? "all" : (String)selectNodeType;
    }
}

