/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TmcTradeFilterPlugin
extends AbstractTmcBillBaseList {
    protected List<Object> selectedOrgIdList = new ArrayList<Object>();
    protected List<Object> selectedAcctIdList = new ArrayList<Object>();
    protected List<Object> selectedBankIdList = new ArrayList<Object>();
    protected List<Object> selectFinancialTypeIdList = new ArrayList<Object>(10);
    protected List<ComboItem> existFinancialTypeList = new ArrayList<ComboItem>(10);
    protected DynamicObjectCollection accountBanks;
    private FilterContainerInitArgs initArgs;
    private boolean isClickSearch = true;
    private static final Log LOGGER = LogFactory.getLog(TmcTradeFilterPlugin.class);

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        ControlFilters controlFilters = view.getControlFilters();
        List companyIds = controlFilters.getFilter("company.id");
        List newCompanyIds = companyIds.stream().filter(id -> !"".equals(id)).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
        List bankCateIds = controlFilters.getFilter("bank.bank_cate.id");
        List newBankCateIds = bankCateIds.stream().filter(id -> !"".equals(id)).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
        if ("accountbank.id".equals(fieldName)) {
            QFilter typeQfilter;
            DynamicObject finorgTypes;
            String selectFinancialTypeId;
            FilterContainer filterContainer = (FilterContainer)this.initArgs.getFilterContainerInitEvent().getSource();
            String entityTypeName = filterContainer.getEntityType().getName();
            if (newCompanyIds.size() > 0) {
                if ("bei_betransdetail_imp".equals(entityTypeName)) {
                    args.getQfilters().add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", newCompanyIds, (boolean)true));
                } else {
                    args.getQfilters().add(new QFilter("company.id", "in", newCompanyIds));
                }
            }
            if (newBankCateIds.size() > 0) {
                DynamicObject acountBankTempDO = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank.id", "in", newBankCateIds)});
                if (EmptyUtil.isNoEmpty((DynamicObject)acountBankTempDO)) {
                    args.getQfilters().add(new QFilter("bank.id", "in", newBankCateIds));
                } else {
                    args.getQfilters().add(new QFilter("bank.bank_cate.id", "in", newBankCateIds));
                }
            }
            if ((selectFinancialTypeId = this.getPageCache().get("selectFinancialTypeId")) != null && (finorgTypes = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (String)"id,number", (QFilter[])new QFilter[]{typeQfilter = new QFilter("id", "=", (Object)Long.valueOf(selectFinancialTypeId))})) != null) {
                String finorgTypeNumber = finorgTypes.getString("number");
                args.getQfilters().add(new QFilter("bank.finorgtype.number", "=", (Object)finorgTypeNumber));
            }
            args.getQfilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        } else if ("bank.id".equals(fieldName)) {
            args.getQfilters().add(VisibleVirtualAcctHelper.notVirtualBankQf());
        } else if ("bank.bank_cate.id".equals(fieldName)) {
            FilterContainer filterContainer = (FilterContainer)this.initArgs.getFilterContainerInitEvent().getSource();
            String entityTypeName = filterContainer.getEntityType().getName();
            if ("bei_bankbalance".equals(entityTypeName) || "bei_transdetail".equals(entityTypeName) || "bei_elecreceipt".equals(entityTypeName) || "bei_transdetail_error".equals(entityTypeName)) {
                String orgId = this.getPageCache().get("company.id");
                String selectFinancialTypeId = this.getPageCache().get("selectFinancialTypeId");
                if (selectFinancialTypeId != null) {
                    DynamicObject finorgtype = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(selectFinancialTypeId)).toArray());
                    if (finorgtype != null) {
                        String finorgTypeNumber = finorgtype.getString("number");
                        if (finorgTypeNumber.equals(FinOrgTypeEnum.BANK.getNumber())) {
                            List<QFilter> bankFilters;
                            if (orgId != null) {
                                bankFilters = this.getAccountBankFilterByOrgId(Collections.singletonList(Long.valueOf(orgId)));
                            } else {
                                List<Long> allOrgIdList = this.getAllOrgIdList(this.initArgs);
                                List<Object> queryList = allOrgIdList.stream().map(e -> e).collect(Collectors.toList());
                                bankFilters = this.getAccountBankFilterByOrgId(queryList);
                            }
                            bankFilters.add(QFilter.isNotNull((String)"bank"));
                            List cateIds = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"bank", (QFilter[])bankFilters.toArray(new QFilter[0])).values().stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("bank"))).map(t -> t.getDynamicObject("bank.bank_cate")).filter(EmptyUtil::isNoEmpty).map(t -> t.getLong("id")).collect(Collectors.toList());
                            args.getQfilters().add(new QFilter("id", "in", cateIds));
                        } else if (finorgTypeNumber.equals(FinOrgTypeEnum.TRDPARTPAY.getNumber()) || finorgTypeNumber.equals(FinOrgTypeEnum.FINCOMP.getNumber()) || finorgTypeNumber.equals(FinOrgTypeEnum.CLEARINGHOUSE.getNumber())) {
                            args.setRefEntityId("bd_finorginfo");
                            ArrayList<QFilter> qfiltersAccount = new ArrayList<QFilter>(10);
                            qfiltersAccount.add(new QFilter("finorgtype", "=", (Object)Long.valueOf(selectFinancialTypeId)));
                            Map finorgInfos = BusinessDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"name,id", (QFilter[])qfiltersAccount.toArray(new QFilter[0]));
                            List finorgInfoIds = finorgInfos.values().stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                            ArrayList<QFilter> accBankQfilter = new ArrayList<QFilter>(10);
                            if (orgId != null && !"".equals(orgId)) {
                                accBankQfilter.add(new QFilter("company.id", "in", Collections.singletonList(Long.valueOf(orgId))));
                            }
                            accBankQfilter.add(new QFilter("bank", "in", finorgInfoIds));
                            accBankQfilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                            Map accBanks = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,bank.id", (QFilter[])accBankQfilter.toArray(new QFilter[0]));
                            List cateIds = accBanks.values().stream().map(e -> e.getLong("bank.id")).collect(Collectors.toList());
                            args.getQfilters().add(new QFilter("id", "in", cateIds));
                        }
                    }
                } else {
                    List<QFilter> bankFilters = this.getAccountBankFilterByOrgId(Collections.singletonList(Long.valueOf(orgId)));
                    bankFilters.add(QFilter.isNotNull((String)"bank"));
                    List cateIds = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"bank", (QFilter[])bankFilters.toArray(new QFilter[0])).values().stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("bank"))).map(t -> t.getDynamicObject("bank.bank_cate")).filter(EmptyUtil::isNoEmpty).map(t -> t.getLong("id")).collect(Collectors.toList());
                    args.getQfilters().add(new QFilter("id", "in", cateIds));
                }
            }
        } else if ("financialtype.id".equals(fieldName)) {
            List typeId = this.existFinancialTypeList.stream().map(v -> Long.valueOf(v.getValue())).collect(Collectors.toList());
            args.getQfilters().add(new QFilter("id", "in", typeId));
        }
    }

    private List<QFilter> getAccountBankFilterByOrgId(List<Object> orgIds) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        if (!EmptyUtil.isEmpty(orgIds)) {
            qfilters.add(new QFilter("company.id", "in", orgIds));
        }
        qfilters.add(new QFilter("bank.finorgtype.number", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getNumber()));
        qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        return qfilters;
    }

    public void setFilter(SetFilterEvent e) {
        LOGGER.info("TmcTradeFilterPlugin\u53d8\u66f4\u524d: " + e.getQFilters().toString());
        for (QFilter qFilter : e.getQFilters()) {
            if ("bank.bank_cate.id".equals(qFilter.getProperty()) && !this.checkFinancialTypeIsBank(qFilter)) {
                qFilter.__setProperty("bank.id");
            }
            List nests = qFilter.getNests(true);
            nests.forEach(n -> {
                if ("bank.bank_cate.id".equals(n.getFilter().getProperty()) && !this.checkFinancialTypeIsBank(qFilter)) {
                    n.getFilter().__setProperty("bank.id");
                }
            });
        }
        String entityTypeId = ((BillList)e.getSource()).getEntityId();
        if ("bei_bankbalance".equals(entityTypeId) || "bei_transdetail".equals(entityTypeId) || "bei_elecreceipt".equals(entityTypeId) || "bei_transdetail_error".equals(entityTypeId)) {
            e.getQFilters().forEach(v -> {
                this.updateProperty((QFilter)v);
                List nests = v.getNests(true);
                nests.forEach(n -> this.updateProperty(n.getFilter()));
            });
        }
        e.getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctToBillQf());
        LOGGER.info("TmcTradeFilterPlugin\u53d8\u66f4\u540e: " + e.getQFilters().toString());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            this.cacheCommonFilter(this.getPageCache(), args.getSearchClickEvent());
        }
        this.filterContainerInit(this.initArgs);
        this.updateValueByCurrentCommon(args);
        this.buildFilterContainer(this.initArgs);
    }

    private void updateValueByCurrentCommon(FilterContainerSearchClickArgs args) {
        if (null == args.getCurrentCommonFilter() || args.getCurrentCommonFilter().isEmpty()) {
            return;
        }
        String currentFieldName = (String)((List)args.getCurrentCommonFilter().get("FieldName")).get(0);
        List customfilter = (List)args.getFilterValues().get("customfilter");
        Iterator iterator = customfilter.iterator();
        if (StringUtils.equalsIgnoreCase((CharSequence)"financialtype.id", (CharSequence)currentFieldName) || StringUtils.equalsIgnoreCase((CharSequence)"bank.bank_cate.id", (CharSequence)currentFieldName)) {
            while (iterator.hasNext()) {
                Map next = (Map)iterator.next();
                List fieldNameList = (List)next.get("FieldName");
                List valueList = (List)next.get("Value");
                if (!EmptyUtil.isNoEmpty((Object)fieldNameList) || !EmptyUtil.isNoEmpty((Object)valueList)) continue;
                String fieldName = String.valueOf(fieldNameList.get(0));
                if (StringUtils.equalsIgnoreCase((CharSequence)"financialtype.id", (CharSequence)currentFieldName) && (fieldName.equals("bank.bank_cate.id") || fieldName.equals("accountbank.id"))) {
                    valueList.clear();
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)"bank.bank_cate.id", (CharSequence)currentFieldName) || !fieldName.equals("accountbank.id")) continue;
                valueList.clear();
            }
        }
    }

    private void cacheCommonFilter(IPageCache pageCache, SearchClickEvent searchClickEvent) {
        if (pageCache != null && searchClickEvent.getFilterValues() != null) {
            this.selectedOrgIdList.clear();
            this.selectedAcctIdList.clear();
            pageCache.remove("company.id");
            Map orgFilter = null;
            Map acctFilter = null;
            boolean bankChange = false;
            List customfilter = (List)searchClickEvent.getFilterValues().get("customfilter");
            if (customfilter != null) {
                for (Map filteritem : customfilter) {
                    String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                    List item = (List)filteritem.get("Value");
                    if (fieldName.startsWith("company")) {
                        orgFilter = filteritem;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        String fieldValue = item.get(0).toString();
                        pageCache.put(fieldName, fieldValue);
                        this.selectedOrgIdList = item;
                        continue;
                    }
                    if (fieldName.startsWith("accountbank") || fieldName.startsWith("accountcash")) {
                        acctFilter = filteritem;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        this.selectedAcctIdList = item;
                        continue;
                    }
                    if (fieldName.startsWith("bank") && !"bankpaystate".equals(fieldName)) {
                        bankChange = true;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        this.selectedBankIdList = item;
                        continue;
                    }
                    if (!fieldName.startsWith("financialtype") || item.isEmpty() || "".equals(item.get(0))) continue;
                    this.selectFinancialTypeIdList.clear();
                    this.selectFinancialTypeIdList.add(Long.valueOf((String)item.get(0)));
                    pageCache.put("selectFinancialTypeId", (String)item.get(0));
                }
                if (orgFilter == null) {
                    if (this.getCachedOrgList() != null) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList(null);
                } else {
                    List<Object> cacheOrgList = this.getCachedOrgList();
                    if (cacheOrgList == null || !cacheOrgList.equals(orgFilter.get("Value"))) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList((List)orgFilter.get("Value"));
                }
                if (bankChange) {
                    pageCache.put("selectedBankIdList", SerializationUtils.toJsonString(this.selectedBankIdList));
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        this.cacheFirstSelectedOrg(args);
        FilterContainer filterContainer = (FilterContainer)args.getFilterContainerInitEvent().getSource();
        String entityTypeName = filterContainer.getEntityType().getName();
        if ("bei_bankbalance".equals(entityTypeName) || "bei_transdetail".equals(entityTypeName) || "bei_elecreceipt".equals(entityTypeName) || "bei_transdetail_error".equals(entityTypeName)) {
            this.initFinorgType(args);
        }
        if (!this.isClickSearch) {
            this.buildFilterContainer(args);
        }
    }

    private void initFinorgType(FilterContainerInitArgs args) {
        List queryOrgIdList = this.selectedOrgIdList.stream().map(e -> Long.valueOf(String.valueOf(e))).collect(Collectors.toList());
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List clearAcct;
            List finAcct;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("financialtype.name")) continue;
            List items = commonFilterColumn.getComboItems();
            Optional<ComboItem> bankItem = items.stream().filter(e -> e.getValue().equals("615763944224700416")).findFirst();
            Optional<ComboItem> settlementItem = items.stream().filter(e -> e.getValue().equals("615764075489639424")).findFirst();
            Optional<ComboItem> threeItem = items.stream().filter(e -> e.getValue().equals("622211932153277440")).findFirst();
            Optional<ComboItem> fiItem = items.stream().filter(e -> e.getValue().equals("630840871381746688")).findFirst();
            List<Object> filterItems = new ArrayList<ComboItem>(10);
            if (bankItem.isPresent()) {
                filterItems.add(bankItem.get());
            }
            if (settlementItem.isPresent()) {
                filterItems.add(settlementItem.get());
            }
            if (threeItem.isPresent()) {
                filterItems.add(threeItem.get());
            }
            if (fiItem.isPresent()) {
                filterItems.add(fiItem.get());
            }
            ArrayList<QFilter> accountBankFilter = new ArrayList<QFilter>(10);
            if (queryOrgIdList.size() > 0) {
                accountBankFilter.add(new QFilter("company.id", "in", queryOrgIdList));
            }
            accountBankFilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            DynamicObjectCollection trdpartpayBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank.finorgtype.number", (QFilter[])accountBankFilter.toArray(new QFilter[0]));
            List threeAcct = trdpartpayBanks.stream().filter(e -> FinOrgTypeEnum.TRDPARTPAY.getNumber().equals(e.getString("bank.finorgtype.number"))).collect(Collectors.toList());
            if (threeAcct.size() == 0) {
                filterItems = filterItems.stream().filter(e -> !e.getValue().equals("622211932153277440")).collect(Collectors.toList());
            }
            if ((finAcct = trdpartpayBanks.stream().filter(e -> FinOrgTypeEnum.FINCOMP.getNumber().equals(e.getString("bank.finorgtype.number"))).collect(Collectors.toList())).size() == 0) {
                filterItems = filterItems.stream().filter(e -> !e.getValue().equals("630840871381746688")).collect(Collectors.toList());
            }
            if ((clearAcct = trdpartpayBanks.stream().filter(e -> FinOrgTypeEnum.CLEARINGHOUSE.getNumber().equals(e.getString("bank.finorgtype.number"))).collect(Collectors.toList())).size() == 0) {
                filterItems = filterItems.stream().filter(e -> !e.getValue().equals("615764075489639424")).collect(Collectors.toList());
            }
            if (this.getPageCache().get("selectFinancialTypeId") == null) {
                this.selectFinancialTypeIdList.add(Long.valueOf(((ComboItem)filterItems.get(0)).getValue()));
                this.getPageCache().put("selectFinancialTypeId", ((ComboItem)filterItems.get(0)).getValue());
            }
            List comboItems = commonFilterColumn.getComboItems();
            comboItems.clear();
            commonFilterColumn.setComboItems(filterItems);
            commonFilterColumn.setDefaultValue(((ComboItem)filterItems.get(0)).getValue());
            this.existFinancialTypeList = filterItems;
        }
    }

    protected void buildFilterContainer(FilterContainerInitArgs args) {
        if (this.selectedOrgIdList.size() < 1) {
            this.selectedOrgIdList.addAll(this.getAllOrgIdList(args));
        }
        this.initAccountBanks(this.selectedOrgIdList);
        List<ComboItem> acctItems = this.initAcctItemsList();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List listcomitem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith("company.") && this.selectedOrgIdList.size() != 0 && this.selectedOrgIdList.get(0) != null) {
                commonFilterColumn.setDefaultValue(this.selectedOrgIdList.get(0).toString());
            }
            if (fieldName.equals("financialtype.name")) {
                commonFilterColumn.setComboItems(this.existFinancialTypeList);
                if (this.selectFinancialTypeIdList.size() > 0) {
                    commonFilterColumn.setDefaultValue(String.valueOf(this.selectFinancialTypeIdList.get(0)));
                }
            }
            if (StringUtils.equals((CharSequence)"bank.bank_cate.name", (CharSequence)fieldName)) {
                List<ComboItem> bankItems = this.initBankItemsList();
                List listcomitem2 = commonFilterColumn.getComboItems();
                listcomitem2.clear();
                commonFilterColumn.setComboItems(bankItems);
                commonFilterColumn.setDefValue(bankItems.size() > 0 ? bankItems.get(0).getValue() : "");
            }
            if (fieldName.startsWith("accountbank.bankaccountnumber")) {
                listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                commonFilterColumn.setComboItems(acctItems);
                commonFilterColumn.setDefValue(acctItems.get(0).getValue());
            }
            if (!fieldName.startsWith("accountcash.")) continue;
            listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(acctItems);
            commonFilterColumn.setDefValue(acctItems.get(0).getValue());
        }
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        if (this.getPageCache().get("isPageOpen") == null) {
            this.isClickSearch = false;
            this.getPageCache().put("isPageOpen", "true");
            String firstOrgId = null;
            if (this.isDefaultOpen()) {
                for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                    List orgItems;
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    if (!fieldName.startsWith("company.") || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
                    String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                    firstOrgId = orgItems.stream().map(ComboItem::getValue).filter(value -> value.equals(loginOrg)).findFirst().orElse(null);
                    if (firstOrgId != null) continue;
                    List defaultVals = commonFilterColumn.getDefaultValues();
                    if (defaultVals != null && defaultVals.size() > 0) {
                        firstOrgId = (String)defaultVals.get(0);
                        continue;
                    }
                    firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
                }
            } else if (this.getView().getFormShowParameter().getCustomParam("company.id") != null) {
                firstOrgId = this.getView().getFormShowParameter().getCustomParam("company.id").toString();
            }
            if (!StringUtils.isEmpty(firstOrgId)) {
                this.selectedOrgIdList.add(firstOrgId);
            }
            this.cacheSelectedOrgIdList(this.selectedOrgIdList);
            this.getPageCache().put("company.id", firstOrgId);
        }
    }

    private List<Long> getAllOrgIdList(FilterContainerInitArgs args) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("company.")) continue;
            boolean isLimit = false;
            List<Object> objects = this.getPageFilterColumnCache(fieldName);
            if (EmptyUtil.isNoEmpty(objects) && "".equals(objects.get(0))) {
                isLimit = true;
            }
            if (isLimit) {
                String appId = this.getView().getFormShowParameter().getAppId();
                List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getDataEntityName(), (String)"47150e89000000ac");
                orgIdList.addAll(comIdList);
                continue;
            }
            List orgItems = commonFilterColumn.getComboItems();
            for (ComboItem item : orgItems) {
                if ("".equals(item.getValue())) continue;
                orgIdList.add(Long.valueOf(item.getValue()));
            }
        }
        return orgIdList;
    }

    protected List<ComboItem> initAcctItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(10);
        if (this.accountBanks != null && this.accountBanks.size() > 0) {
            for (DynamicObject cashAcct : this.accountBanks) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TmcTradeFilterPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    protected List<ComboItem> initBankItemsList() {
        if (this.initArgs == null) {
            return this.changeBankItemsListOriginal();
        }
        FilterContainer filterContainer = (FilterContainer)this.initArgs.getFilterContainerInitEvent().getSource();
        String entityTypeName = filterContainer.getEntityType().getName();
        if ("bei_bankbalance".equals(entityTypeName) || "bei_transdetail".equals(entityTypeName) || "bei_elecreceipt".equals(entityTypeName) || "bei_transdetail_error".equals(entityTypeName)) {
            return this.changeBankItemsListNew();
        }
        return this.changeBankItemsListOriginal();
    }

    protected List<ComboItem> changeBankItemsListOriginal() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(10);
        if (this.accountBanks != null && this.accountBanks.size() > 0) {
            for (DynamicObject cashAcct : this.accountBanks) {
                ComboItem item;
                if (!EmptyUtil.isEmpty((Object)cashAcct.get("bank.bank_cate.name"))) {
                    item = new ComboItem();
                    String cateName = cashAcct.getString("bank.bank_cate.name");
                    if (!EmptyUtil.isNoEmpty((String)cateName)) continue;
                    item.setCaption(new LocaleString(cateName));
                    item.setValue(cashAcct.getString("bank.bank_cate.id"));
                    if (acctItems.contains(item)) continue;
                    acctItems.add(item);
                    continue;
                }
                item = new ComboItem();
                String bankName = cashAcct.getString("bank.name");
                if (!EmptyUtil.isNoEmpty((String)bankName)) continue;
                item.setCaption(new LocaleString(bankName));
                item.setValue(cashAcct.getString("bank.id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TmcTradeFilterPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    protected List<ComboItem> changeBankItemsListNew() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(10);
        ArrayList<QFilter> qfiltersAccount = new ArrayList<QFilter>(10);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        DynamicObjectCollection finorgTypes = null;
        if (this.selectFinancialTypeIdList != null && this.selectFinancialTypeIdList.size() > 0) {
            qfiltersAccount.add(new QFilter("finorgtype", "in", this.selectFinancialTypeIdList));
            QFilter typeQfilter = new QFilter("id", "in", this.selectFinancialTypeIdList);
            typeQfilter.and(new QFilter("enable", "=", (Object)"1"));
            finorgTypes = QueryServiceHelper.query((String)"bd_finorgtype", (String)"id,number", (QFilter[])typeQfilter.toArray());
        }
        if (finorgTypes != null && finorgTypes.size() > 0) {
            String finorgTypeNumber = ((DynamicObject)finorgTypes.get(0)).getString("number");
            List queryOrgIdList = this.selectedOrgIdList.stream().map(e -> Long.valueOf(String.valueOf(e))).collect(Collectors.toList());
            if (finorgTypeNumber.equals(FinOrgTypeEnum.BANK.getNumber())) {
                if (queryOrgIdList.size() > 0) {
                    qfilters.add(new QFilter("company.id", "in", queryOrgIdList));
                }
                qfilters.add(new QFilter("bank.finorgtype.number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()));
                qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBankAcct", (String)"bd_accountbanks", (String)"bank.bank_cate.id,bank.bank_cate.name", (QFilter[])qfilters.toArray(new QFilter[0]), null);){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        if (!EmptyUtil.isNoEmpty((String)row.getString("bank.bank_cate.id")) || !EmptyUtil.isNoEmpty((String)row.getString("bank.bank_cate.name"))) continue;
                        ComboItem item = new ComboItem();
                        item.setCaption(new LocaleString(row.getString("bank.bank_cate.name")));
                        item.setValue(row.getString("bank.bank_cate.id"));
                        if (acctItems.contains(item)) continue;
                        acctItems.add(item);
                    }
                }
            } else if (finorgTypeNumber.equals(FinOrgTypeEnum.TRDPARTPAY.getNumber()) || finorgTypeNumber.equals(FinOrgTypeEnum.FINCOMP.getNumber()) || finorgTypeNumber.equals(FinOrgTypeEnum.CLEARINGHOUSE.getNumber())) {
                Map finorgInfos = BusinessDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id", (QFilter[])qfiltersAccount.toArray(new QFilter[0]));
                List finorgInfoIds = finorgInfos.values().stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                ArrayList<QFilter> accBankQfilter = new ArrayList<QFilter>();
                if (queryOrgIdList.size() > 0) {
                    accBankQfilter.add(new QFilter("company.id", "in", queryOrgIdList));
                }
                accBankQfilter.add(new QFilter("bank", "in", finorgInfoIds));
                accBankQfilter.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                DynamicObjectCollection accBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank.id,bank.name", (QFilter[])accBankQfilter.toArray(new QFilter[0]));
                List filterAccBanks = accBanks.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("bank.id")) && EmptyUtil.isNoEmpty((String)e.getString("bank.name"))).collect(Collectors.toList());
                if (filterAccBanks.size() > 0) {
                    for (DynamicObject bank : filterAccBanks) {
                        ComboItem item = new ComboItem();
                        item.setCaption(new LocaleString(bank.getString("bank.name")));
                        item.setValue(String.valueOf(bank.getLong("bank.id")));
                        if (acctItems.contains(item)) continue;
                        acctItems.add(item);
                    }
                }
            }
        }
        return acctItems;
    }

    protected void orgCommonFilterChange(Map<String, List<Object>> acctFilter) {
        if (acctFilter != null) {
            ArrayList<String> acctList = new ArrayList<String>();
            acctList.add("");
            acctFilter.put("Value", acctList);
            this.selectedAcctIdList.clear();
        }
    }

    protected void initAccountBanks(List<Object> selectedOrgIdList) {
        List queryFinancialTypeIdList;
        QFilter typeQfilter;
        DynamicObjectCollection finorgTypes;
        String selectProperties = "id,bankaccountnumber,bank.id,bank.name,bank.bank_cate.id,bank.bank_cate.name";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (selectedOrgIdList != null && selectedOrgIdList.size() > 0) {
            List orgIds = selectedOrgIdList.stream().filter(Objects::nonNull).map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            qfilters.add(new QFilter("company.id", "in", orgIds));
        }
        if (this.selectedBankIdList != null && this.selectedBankIdList.size() > 0) {
            ArrayList<Object> bankIdList = new ArrayList<Object>();
            for (Object id : this.selectedBankIdList) {
                bankIdList.add(id instanceof String && !StringUtils.isBlank((Object)id) ? Long.valueOf((String)id) : id);
            }
            DynamicObject acountBankTempDO = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank.id", "in", bankIdList), VisibleVirtualAcctHelper.notVirtualAcctQf()});
            if (EmptyUtil.isNoEmpty((DynamicObject)acountBankTempDO)) {
                qfilters.add(new QFilter("bank.id", "in", bankIdList));
            } else {
                qfilters.add(new QFilter("bank.bank_cate.id", "in", bankIdList));
            }
        }
        qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        if (this.selectFinancialTypeIdList != null && this.selectFinancialTypeIdList.size() > 0 && (finorgTypes = QueryServiceHelper.query((String)"bd_finorgtype", (String)"id,number", (QFilter[])new QFilter[]{typeQfilter = new QFilter("id", "in", queryFinancialTypeIdList = this.selectFinancialTypeIdList.stream().map(e -> Long.valueOf(String.valueOf(e))).collect(Collectors.toList()))})) != null && finorgTypes.size() > 0) {
            String finorgTypeNumber = ((DynamicObject)finorgTypes.get(0)).getString("number");
            qfilters.add(new QFilter("bank.finorgtype.number", "=", (Object)finorgTypeNumber));
        }
        this.accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]), null);
    }

    private void cacheSelectedOrgIdList(List<Object> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    protected boolean isDefaultOpen() {
        FormShowParameter parameters = this.getView().getFormShowParameter();
        return parameters.getCustomParam("setDefaultFilters") == null;
    }

    private boolean checkFinancialTypeIsBank(QFilter qFilter) {
        String selectFinancialTypeId = this.getPageCache().get("selectFinancialTypeId");
        if (EmptyUtil.isNoEmpty((String)selectFinancialTypeId)) {
            return "615763944224700416".equals(selectFinancialTypeId);
        }
        QFilter filter = new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
        return QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
    }

    private void updateProperty(QFilter qFilter) {
        switch (qFilter.getProperty()) {
            case "bank.bank_cate.id": {
                qFilter.__setProperty("accountbank.bank.bank_cate.id");
                break;
            }
            case "bank.id": {
                qFilter.__setProperty("accountbank.bank.id");
                break;
            }
            case "financialtype.id": {
                qFilter.__setProperty("accountbank.bank.finorgtype.id");
                break;
            }
        }
    }
}

