/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.attachview;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.AttachViewInfo;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AttachViewPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected final Log log = LogFactory.getLog(AttachViewPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entry");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String attachInfoStr = (String)fsp.getCustomParam("customparam_attachviewInfo");
        if (EmptyUtil.isNoEmpty((String)attachInfoStr)) {
            this.insertAttachEntryVal(JSON.parseArray((String)attachInfoStr, AttachViewInfo.class));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "download": {
                DynamicObject entryObj = (DynamicObject)this.getModel().getEntryEntity("entry").get(this.getModel().getEntryCurrentRowIndex("entry"));
                String url = entryObj.getString("fileurl");
                this.getView().download(url);
                break;
            }
            case "attachmentview": {
                DynamicObject entryObjView = (DynamicObject)this.getModel().getEntryEntity("entry").get(this.getModel().getEntryCurrentRowIndex("entry"));
                Long attPkId = entryObjView.getLong("attpkid");
                DynamicObject data = TmcDataServiceHelper.loadSingle((Object)attPkId, (String)"bos_attachment");
                TmcOperateServiceHelper.execOperate((String)"attachmentview", (String)"bos_attachment", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)OperateOption.create());
                break;
            }
            case "alldownload": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
                for (DynamicObject entry : entrys) {
                    String singleUrl = entry.getString("fileurl");
                    this.getView().download(singleUrl);
                }
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"bizbillno", (CharSequence)evt.getFieldName())) {
            BillShowParameter parameter = new BillShowParameter();
            DynamicObject entryRow = this.getModel().getEntryRowEntity("entry", evt.getRowIndex());
            parameter.setStatus(OperationStatus.VIEW);
            String entityName = entryRow.getString("bizentity");
            String billNo = entryRow.getString("bizbillno");
            parameter.setFormId(entityName);
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billNo).toArray());
            parameter.setPkId((Object)bizBill.getLong("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void insertAttachEntryVal(List<AttachViewInfo> attachInfos) {
        List entryValueMap = attachInfos.stream().map(o -> {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("bizbillno", o.getBizBillNo());
            dataMap.put("entityname", o.getEntityname());
            dataMap.put("bizentity", o.getBizEntity());
            dataMap.put("attachname", o.getAttachName());
            dataMap.put("uploader", o.getUploader());
            dataMap.put("uploadtime", o.getUploadTime());
            dataMap.put("remark", o.getRemark());
            dataMap.put("fileurl", o.getFileUrl());
            dataMap.put("attpkid", o.getAttPkId());
            return dataMap;
        }).collect(Collectors.toList());
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), entryValueMap);
    }
}

