/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.formplugin.common.balance;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.IBalanceUpdatePlugin;
import kd.bos.db.DBRoute;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.BalanceUpdateInfo;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.BalanceUpdateHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public abstract class AbstractBalanceUpdatePlugin
extends AbstractFormPlugin
implements IBalanceUpdatePlugin {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String SNAP_COLS = "fid,fkeycol,fcompanyid,faccountbankid,fcurrencyid,fbizdate,fdebitamount,fcreditamount,famount,flstbalance,fvalibalance";
    private static final String UPDATE_BAL_SQL = "UPDATE %s SET famount = ? + fcreditamount - fdebitamount, flstbalance = ?, fvalibalance = ? + fcreditamount - fdebitamount, fmodifytime = ? WHERE fid = ?";
    private static final String DELETE_BLAL_SQL = "DELETE FROM %s WHERE fid = ? AND (fcreditamount + fdebitamount) = 0";

    protected abstract String getEntityName();

    public void afterUpdate(BalanceUpdateArgs args) {
        DataSet ds = args.getUpdatedBalData(SNAP_COLS);
        while (ds.hasNext()) {
            BalanceUpdateInfo balanceUpdateInfo = this.transBalance(ds.next());
            if (this.deleteForAmountZero(balanceUpdateInfo)) {
                this.afterUpdateBillBalance(balanceUpdateInfo);
                continue;
            }
            BigDecimal lstBalance = this.getLstBalance(balanceUpdateInfo);
            String updateSql = String.format(UPDATE_BAL_SQL, this.getEntityTableName());
            TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])new Object[]{lstBalance, lstBalance, lstBalance, new Date(), balanceUpdateInfo.getId()});
            this.afterUpdateBillBalance(balanceUpdateInfo);
        }
    }

    protected void afterUpdateBillBalance(BalanceUpdateInfo balanceUpdateInfo) {
        BalanceUpdateHelper.updateNetxBizDateBalance((String)this.getEntityName(), (BalanceUpdateInfo)balanceUpdateInfo);
    }

    private BalanceUpdateInfo transBalance(Row row) {
        return BalanceUpdateInfo.build((Long)row.getLong("faccountbankid"), (Long)row.getLong("fcompanyid"), (Long)row.getLong("fcurrencyid")).setId(row.getLong("fid")).setBizDate(row.getDate("fbizdate")).setAmount(row.getBigDecimal("famount")).setLstBalance(row.getBigDecimal("flstbalance")).setValiBalance(row.getBigDecimal("fvalibalance")).setDebitAmount(row.getBigDecimal("fdebitamount")).setCreditAmount(row.getBigDecimal("fcreditamount"));
    }

    protected boolean deleteForAmountZero(BalanceUpdateInfo balanceUpdateInfo) {
        BigDecimal creditAmount = BalanceUpdateHelper.defaultZero((BigDecimal)balanceUpdateInfo.getCreditAmount());
        BigDecimal debitAmount = BalanceUpdateHelper.defaultZero((BigDecimal)balanceUpdateInfo.getDebitAmount());
        if (BalanceUpdateHelper.isZero((BigDecimal)creditAmount) && BalanceUpdateHelper.isZero((BigDecimal)debitAmount)) {
            return TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)String.format(DELETE_BLAL_SQL, this.getEntityTableName()), (Object[])new Object[]{balanceUpdateInfo.getId()});
        }
        return false;
    }

    public void afterRollback(BalanceUpdateArgs args) {
        this.afterUpdate(args);
    }

    protected BigDecimal getBillInitBalance(BalanceUpdateInfo balanceInfo) {
        return BigDecimal.ZERO;
    }

    protected BalanceUpdateInfo queryLstBalance(BalanceUpdateInfo balanceInfo) {
        return BalanceUpdateHelper.queryLstBalance((String)this.getEntityName(), (Long)balanceInfo.getBizBillId(), (Long)balanceInfo.getCurrencyId(), (Date)balanceInfo.getBizDate());
    }

    protected String getEntityTableName() {
        return BalanceUpdateHelper.getEntityTableName((String)this.getEntityName());
    }

    protected BigDecimal getLstBalance(BalanceUpdateInfo balanceInfo) {
        BigDecimal lstBalance = balanceInfo.getLstBalance();
        if (lstBalance == null || lstBalance.compareTo(BigDecimal.ZERO) == 0) {
            BalanceUpdateInfo lstBalanceInfo = this.queryLstBalance(balanceInfo);
            lstBalance = lstBalanceInfo == null ? this.getBillInitBalance(balanceInfo) : lstBalanceInfo.getAmount();
        }
        return lstBalance;
    }
}

